/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.server.layers.layer3.engine;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.server.layers.layer3.engine.IMessageStreamer;
import org.neodatis.odb.core.server.layers.layer3.engine.Message;
import org.neodatis.tool.wrappers.OdbString;

public class DefaultMessageStreamer
implements IMessageStreamer {
    private OutputStream out;
    private InputStream in;
    private ObjectOutputStream oos;
    private ObjectInputStream ois;
    private Socket socket;
    private String host;
    private int port;
    private String name;
    private boolean isClosed;

    public DefaultMessageStreamer(String host, int port, String name) {
        this.host = host;
        this.port = port;
        this.name = name;
        this.initSocket();
    }

    public DefaultMessageStreamer(Socket socket) throws IOException {
        this.socket = socket;
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
        this.oos = new ObjectOutputStream(this.out);
        this.ois = new ObjectInputStream(new BufferedInputStream(this.in));
    }

    private void initSocket() {
        if (this.socket == null) {
            try {
                this.socket = new Socket(this.host, this.port);
                this.socket.setTcpNoDelay(true);
                this.out = this.socket.getOutputStream();
                this.in = this.socket.getInputStream();
                this.oos = new ObjectOutputStream(new BufferedOutputStream(this.out));
                this.ois = new ObjectInputStream(new BufferedInputStream(this.in));
            }
            catch (Exception e) {
                throw new ODBRuntimeException(NeoDatisError.CLIENT_NET_ERROR, (Throwable)e);
            }
        }
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.name));
        }
    }

    public void close() {
        try {
            this.oos.flush();
            this.oos.close();
            this.ois.close();
            this.out.close();
            this.in.close();
            this.isClosed = true;
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.CLIENT_NET_ERROR, (Throwable)e);
        }
    }

    public void write(Message message) throws Exception {
        this.oos.writeObject(message);
        this.oos.flush();
    }

    public void clearCache() {
        try {
            this.oos.reset();
        }
        catch (IOException e) {
            throw new ODBRuntimeException(NeoDatisError.NET_SERIALISATION_ERROR.addParameter(OdbString.exceptionToString(e, true)));
        }
    }

    public Message read() throws Exception {
        return (Message)this.ois.readObject();
    }
}

