/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.values;

import java.util.List;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.query.execution.IQueryFieldAction;
import org.neodatis.odb.core.query.values.AbstractQueryFieldAction;
import org.neodatis.odb.impl.core.query.list.objects.LazySimpleListOfAOI;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.NeoDatisCollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SublistAction
extends AbstractQueryFieldAction {
    private IOdbList<Object> sublist;
    private int fromIndex;
    private int size;
    private boolean throwExceptionIfOutOfBound;

    public SublistAction(String attributeName, String alias, int fromIndex, int size, boolean throwExceptionIfOutOfBound) {
        super(attributeName, alias, true);
        this.fromIndex = fromIndex;
        this.size = size;
        this.throwExceptionIfOutOfBound = throwExceptionIfOutOfBound;
    }

    public SublistAction(String attributeName, String alias, int fromIndex, int toIndex) {
        super(attributeName, alias, true);
        this.fromIndex = fromIndex;
        this.size = toIndex - fromIndex;
        this.throwExceptionIfOutOfBound = true;
    }

    @Override
    public void execute(OID oid, AttributeValuesMap values) {
        List l = (List)values.get(this.attributeName);
        int localFromIndex = this.fromIndex;
        int localEndIndex = this.fromIndex + this.size;
        if (!this.throwExceptionIfOutOfBound) {
            if (localFromIndex > l.size() - 1) {
                localFromIndex = 0;
            }
            if (localEndIndex > l.size()) {
                localEndIndex = l.size();
            }
        }
        this.sublist = new LazySimpleListOfAOI<Object>(this.size, this.getInstanceBuilder(), this.returnInstance());
        this.sublist.addAll(NeoDatisCollectionUtil.sublistGeneric(l, localFromIndex, localEndIndex));
    }

    @Override
    public Object getValue() {
        return this.sublist;
    }

    @Override
    public void end() {
    }

    @Override
    public void start() {
    }

    public List<Object> getSubList() {
        return this.sublist;
    }

    @Override
    public IQueryFieldAction copy() {
        return new SublistAction(this.attributeName, this.alias, this.fromIndex, this.size, this.throwExceptionIfOutOfBound);
    }
}

