/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.nq;

import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.execution.IQueryExecutionPlan;
import org.neodatis.tool.wrappers.OdbTime;

public class NativeQueryExecutionPlan
implements IQueryExecutionPlan {
    protected ClassInfo classInfo;
    protected boolean useIndex;
    protected ClassInfoIndex classInfoIndex;
    protected IQuery query;
    protected long start;
    protected long end;

    public NativeQueryExecutionPlan(ClassInfo classInfo, IQuery query) {
        this.classInfo = classInfo;
        this.query = query;
        query.setExecutionPlan(this);
        this.init();
    }

    protected void init() {
        this.useIndex = false;
    }

    public ClassInfoIndex getIndex() {
        return this.classInfoIndex;
    }

    public boolean useIndex() {
        return this.useIndex;
    }

    public String getDetails() {
        StringBuffer buffer = new StringBuffer();
        if (this.classInfoIndex == null) {
            buffer.append("No index used, Execution time=").append(this.getDuration()).append("ms");
            return buffer.toString();
        }
        return buffer.append("Following indexes have been used : ").append(this.classInfoIndex.getName()).append(", Execution time=").append(this.getDuration()).append("ms").toString();
    }

    public void end() {
        this.end = OdbTime.getCurrentTimeInMs();
    }

    public long getDuration() {
        return this.end - this.start;
    }

    public void start() {
        this.start = OdbTime.getCurrentTimeInMs();
    }
}

