/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer3.refactor;

import java.io.IOException;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer3.IRefactorManager;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;

public class DefaultRefactorManager
implements IRefactorManager {
    protected IStorageEngine storageEngine;

    public DefaultRefactorManager(IStorageEngine storageEngine) {
        this.storageEngine = storageEngine;
    }

    public void addField(String className, Class fieldType, String fieldName) {
        MetaModel metaModel = this.storageEngine.getSession(true).getMetaModel();
        ClassInfo ci = metaModel.getClassInfo(className, true);
        ClassAttributeInfo cai = new ClassAttributeInfo(-1, fieldName, fieldType.getName(), ci);
        ci.addAttribute(cai);
        this.storageEngine.getObjectWriter().updateClassInfo(ci, true);
    }

    public void changeFieldType(String className, String attributeName, Class newType) {
    }

    public void removeClass(String className) {
    }

    public void removeField(String className, String attributeName) throws IOException {
        MetaModel metaModel = this.storageEngine.getSession(true).getMetaModel();
        ClassInfo ci = metaModel.getClassInfo(className, true);
        ClassAttributeInfo cai2 = ci.getAttributeInfoFromName(attributeName);
        ci.removeAttribute(cai2);
        this.storageEngine.getObjectWriter().updateClassInfo(ci, true);
    }

    public void renameClass(String fullClassName, String newFullClassName) throws IOException {
        MetaModel metaModel = this.storageEngine.getSession(true).getMetaModel();
        ClassInfo ci = metaModel.getClassInfo(fullClassName, true);
        ci.setFullClassName(newFullClassName);
        this.storageEngine.getObjectWriter().updateClassInfo(ci, true);
    }

    public void renameField(String className, String attributeName, String newAttributeName) throws IOException {
        MetaModel metaModel = this.storageEngine.getSession(true).getMetaModel();
        ClassInfo ci = metaModel.getClassInfo(className, true);
        ClassAttributeInfo cai2 = ci.getAttributeInfoFromName(attributeName);
        cai2.setName(newAttributeName);
        this.storageEngine.getObjectWriter().updateClassInfo(ci, true);
    }
}

