/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.objectbrowser.hierarchy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.gui.IBrowserContainer;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.objectbrowser.hierarchy.NativeAttributeValueWrapper;
import org.neodatis.odb.gui.objectbrowser.hierarchy.NonNativeObjectInfoWrapper;
import org.neodatis.odb.gui.objectbrowser.hierarchy.ObjectBrowserModel;
import org.neodatis.odb.gui.objectbrowser.update.ObjectIntrospectorPanel;
import org.neodatis.tool.ILogger;

public class HierarchicObjectBrowserPanel
extends JPanel
implements ActionListener,
TreeSelectionListener {
    private ClassInfo ci;
    private List objectValues;
    private JTree tree;
    private ObjectBrowserModel model;
    JButton btDeleteObject;
    JButton btUpdateObject;
    JPanel updatePanel;
    private ILogger logger;
    private boolean isEditing;
    private NativeAttributeValueWrapper attributeBeingEdited;
    private NonNativeObjectInfoWrapper objectBeingEdited;
    private NonNativeObjectInfoWrapper selectedObject;
    private OID selectedOid;
    private IStorageEngine engine;
    private IBrowserContainer browser;

    public HierarchicObjectBrowserPanel(IBrowserContainer browser, IStorageEngine engine, ClassInfo ci, List objectValues, boolean withButtons, ILogger logger) {
        this.ci = ci;
        this.objectValues = objectValues;
        this.isEditing = false;
        this.attributeBeingEdited = null;
        this.engine = engine;
        this.browser = browser;
        this.logger = logger;
        this.initGUI(withButtons);
    }

    private void initGUI(boolean withButtons) {
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setLayout(new BorderLayout(4, 4));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.ci.getFullClassName());
        this.model = new ObjectBrowserModel(this.ci, this.objectValues, root);
        this.tree = new JTree(this.model);
        this.tree.addTreeSelectionListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setPreferredSize(new Dimension(200, 200));
        this.add(scrollPane);
        this.updatePanel = new JPanel(new FlowLayout(0));
        this.btDeleteObject = new JButton(Messages.getString("Delete Object"));
        this.btUpdateObject = new JButton(Messages.getString("Update/Introspect Object"));
        this.btDeleteObject.setActionCommand("delete-object");
        this.btUpdateObject.setActionCommand("update-object");
        this.btDeleteObject.addActionListener(this);
        this.btUpdateObject.addActionListener(this);
        this.updatePanel.add(this.btUpdateObject);
        this.updatePanel.add(this.btDeleteObject);
        this.enableUpdateButton(false);
        if (withButtons) {
            this.add((Component)this.updatePanel, "South");
        }
    }

    private void enableUpdateButton(boolean enable) {
        this.btDeleteObject.setEnabled(enable);
        this.btUpdateObject.setEnabled(enable);
    }

    private void showUpdateButton(boolean yes) {
        this.btDeleteObject.setVisible(yes);
        this.btUpdateObject.setVisible(yes);
        if (yes) {
            this.enableUpdateButton(true);
        }
    }

    private void enableUpdateFields(boolean enable) {
        this.updatePanel.invalidate();
    }

    private void showUpdateFields(boolean visible) {
        this.showUpdateButton(!visible);
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("delete-object")) {
            this.deleteObject();
            return;
        }
        if (actionCommand.equals("update-object")) {
            this.updateObject();
            return;
        }
    }

    private void updateObject() {
        ObjectIntrospectorPanel panel = new ObjectIntrospectorPanel(this.engine, this.ci, this.browser, this.selectedObject.getNnoi(), this.logger);
        this.browser.browse("Updating object", panel, -1);
    }

    private void deleteObject() {
        NonNativeObjectInfo nnoi = this.selectedObject.getNnoi();
        System.out.println("Deleting object with id " + this.selectedObject.getNnoi().getOid());
        try {
            int r = JOptionPane.showConfirmDialog(this, Messages.getString("Delete object of type ") + nnoi.getClassInfo().getFullClassName() + Messages.getString(" with id ") + nnoi.getOid(), Messages.getString("Confirm Deletion"), 0);
            if (r == 0) {
                this.engine.deleteObjectWithOid(this.selectedObject.getNnoi().getOid(), false);
                TreePath tp = this.tree.getSelectionModel().getLeadSelectionPath();
                System.out.println("delete done!");
                System.out.println(tp);
                this.selectedObject.setDeleted(true);
                this.tree.expandPath(tp);
                this.tree.collapsePath(tp);
                this.enableUpdateButton(false);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Messages.getString("Error while deleting object (" + e.getMessage() + ")"));
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object object = this.tree.getLastSelectedPathComponent();
        TreePath tp = this.tree.getSelectionPath();
        if (object != null && object instanceof NonNativeObjectInfoWrapper && tp.getPathCount() == 2) {
            this.selectedObject = (NonNativeObjectInfoWrapper)object;
            this.selectedOid = this.selectedObject.getNnoi().getOid();
            if (!this.selectedObject.isDeleted()) {
                this.btDeleteObject.setText(Messages.getString("Delete object with oid ") + this.selectedObject.getNnoi().getOid());
                this.btUpdateObject.setText(Messages.getString("Update object with oid ") + this.selectedObject.getNnoi().getOid());
                this.showUpdateFields(false);
            } else {
                this.btDeleteObject.setText(Messages.getString("Delete ..."));
                this.enableUpdateButton(false);
            }
        }
    }

    public OID getSelectedOid() {
        return this.selectedOid;
    }
}

