/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GlobalProperties;
import org.gtdfree.Messages;
import org.gtdfree.model.Action;
import org.gtdfree.model.ActionEvent;
import org.gtdfree.model.ConsistencyException;
import org.gtdfree.model.Folder;
import org.gtdfree.model.FolderEvent;
import org.gtdfree.model.GTDData;
import org.gtdfree.model.GTDDataXMLTools;
import org.gtdfree.model.GTDModel;
import org.gtdfree.model.GTDModelListener;
import org.gtdfree.model.Project;

public class GTDDataXML
implements GTDData {
    private GTDModel model;
    protected volatile boolean changed = false;
    private SaveThread saveThread;
    private boolean autoSave = true;
    private int i = 0;
    private GlobalProperties gp;
    private File file;
    private boolean closed = false;
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(this.getClass());

    public GTDDataXML() {
    }

    public GTDDataXML(File f, GlobalProperties gp) {
        this.initialize(f, gp);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public GTDDataXML(GlobalProperties gp, GTDModel model) {
        this.initialize(null, gp);
        this.model = model;
    }

    @Override
    public void initialize(File f, GlobalProperties gp) {
        this.gp = gp;
        if (f == null) {
            return;
        }
        if (f.exists() && f.isFile() || !f.isDirectory() && f.getName().toLowerCase().endsWith(".xml")) {
            this.file = f;
        } else {
            if (!f.exists()) {
                f.mkdir();
            }
            this.file = new File(f, "gtd-free-data.xml");
        }
    }

    @Override
    public GTDModel restore() throws IOException {
        if (this.model == null) {
            this.model = new GTDModel();
            this.model.initialize(this);
            System.out.println("Loading XML file " + this.getDataFile().getAbsolutePath());
            if (this.getDataFile().exists()) {
                try {
                    GTDDataXMLTools.load(this.model, this.getDataFile());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    GTDDataXMLTools.DataHeader[] dh = this.findBackupFiles();
                    this.handleFailedLoad(this.model, dh, 0, e);
                }
            } else {
                GTDDataXMLTools.DataHeader[] dh = this.findBackupFiles();
                if (dh != null && dh.length > 0) {
                    this.handleFailedLoad(this.model, dh, 0, new FileNotFoundException("Missing main data file: '" + this.getDataFile().getAbsolutePath() + "'."));
                }
            }
            this.changed = false;
            this.setAutoSave(this.gp.getBoolean("autoSave", true));
        }
        return this.model;
    }

    private void handleFailedLoad(GTDModel m, GTDDataXMLTools.DataHeader[] dh, int i, Exception e) throws IOException {
        if (dh == null || dh.length <= i) {
            int option = JOptionPane.showConfirmDialog(null, Messages.getString("GTDDataXML.Fail.1") + " \n\"" + e.toString().replace(". ", ".\n") + "\"\n\n" + Messages.getString("GTDDataXML.Fail.2") + "\n\n" + Messages.getString("GTDDataXML.Fail.3") + "\n\n" + Messages.getString("GTDDataXML.Fail.4") + " '" + ApplicationHelper.getDataFolder().getAbsolutePath() + "'.\n" + Messages.getString("GTDDataXML.Fail.5") + " '" + this.getDataFile().getName() + "' " + Messages.getString("GTDDataXML.Fail.6") + "\n" + Messages.getString("GTDDataXML.Fail.7"), "GTD-Free - " + Messages.getString("GTDDataXML.Fail.title"), 0, 0);
            if (option == 0) {
                this.autoSave = false;
                if (this.saveThread != null) {
                    this.saveThread.stopSave();
                }
                throw new IOException("Aborting because of previous errors.", e);
            }
            return;
        }
        int option = JOptionPane.showConfirmDialog(null, Messages.getString("GTDDataXML.Fail.1") + " \n\"" + e.toString().replace(". ", ".\n") + "\"\n\n" + Messages.getString("GTDDataXML.Fail.B.1") + " '" + dh[i].getFile().getAbsolutePath() + "',\n" + Messages.getString("GTDDataXML.Fail.B.2") + " " + ApplicationHelper.toISODateTimeString(dh[i].getModified()) + Messages.getString("GTDDataXML.Fail.B.3") + "\n\n" + Messages.getString("GTDDataXML.Fail.3") + "\n\n" + Messages.getString("GTDDataXML.Fail.B.4") + "\n" + Messages.getString("GTDDataXML.Fail.B.5") + "\n\n" + Messages.getString("GTDDataXML.Fail.4") + " '" + ApplicationHelper.getDataFolder().getAbsolutePath() + "'.\n" + Messages.getString("GTDDataXML.Fail.5") + " '" + this.getDataFile().getName() + "' " + Messages.getString("GTDDataXML.Fail.6") + "\n" + Messages.getString("GTDDataXML.Fail.7"), "GTD-Free - " + Messages.getString("GTDDataXML.Fail.title"), 1, 0);
        if (option == 0) {
            try {
                System.out.println("Loading XML file " + dh[i].getFile().getAbsolutePath());
                this.model = new GTDModel();
                this.model.initialize(this);
                GTDDataXMLTools.load(this.model, dh[i].getFile());
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.handleFailedLoad(m, dh, ++i, ex);
            }
        } else {
            if (option == 1) {
                return;
            }
            this.autoSave = false;
            if (this.saveThread != null) {
                this.saveThread.stopSave();
            }
            throw new IOException("Aborting because of previous errors.", e);
        }
    }

    private GTDDataXMLTools.DataHeader[] findBackupFiles() {
        ArrayList<GTDDataXMLTools.DataHeader> l = new ArrayList<GTDDataXMLTools.DataHeader>(10);
        for (int i = 0; i < 10; ++i) {
            File f = ApplicationHelper.createBackupDataFile(this.getDataFile(), i);
            if (!f.exists() || f.length() <= 0L) continue;
            try {
                GTDDataXMLTools.DataHeader dh = new GTDDataXMLTools.DataHeader(f);
                l.add(dh);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Collections.sort(l, new Comparator<GTDDataXMLTools.DataHeader>(){

            @Override
            public int compare(GTDDataXMLTools.DataHeader o1, GTDDataXMLTools.DataHeader o2) {
                if (o1.getModified() == null || o2.getModified() == null) {
                    return 0;
                }
                return (int)(o2.getModified().getTime() - o1.getModified().getTime());
            }
        });
        for (GTDDataXMLTools.DataHeader dataHeader : l) {
            System.out.println(dataHeader);
        }
        return l.toArray(new GTDDataXMLTools.DataHeader[l.size()]);
    }

    public File getDataFile() {
        return this.file != null ? this.file : ApplicationHelper.getDataFile();
    }

    @Override
    public void store() {
        this.notifyUpdate();
    }

    @Override
    public GTDData.ActionProxy getProxy(Action a) {
        if (a.getProxy() != null) {
            return a.getProxy();
        }
        ActionProxyXML p = new ActionProxyXML(a);
        a.setProxy(p);
        this.notifyUpdate();
        return p;
    }

    @Override
    public boolean close(boolean terminal) throws IOException {
        if (this.isAutoSave()) {
            this.setAutoSave(false);
            if (this.isSaveReady()) {
                this.flush();
            }
        } else if (this.isSaveReady() && !terminal) {
            int option = JOptionPane.showConfirmDialog(null, Messages.getString("GTDDataXML.Closing"), Messages.getString("GTDDataXML.Closing.title"), 1, 2);
            if (option == 0) {
                this.flush();
            } else if (option == 2) {
                return false;
            }
        }
        this.closed = true;
        return true;
    }

    @Override
    public synchronized void flush() throws IOException {
        File backup = ApplicationHelper.createBackupDataFile(this.getDataFile(), this.i++ % 10);
        if (backup.exists() && !backup.delete()) {
            throw new IOException("Failed to remove backup file '" + backup.getAbsolutePath() + "'.");
        }
        if (this.getDataFile().exists() && !this.getDataFile().renameTo(backup)) {
            throw new IOException("Failed to make backup copy file '" + backup.getAbsolutePath() + "'.");
        }
        try {
            GTDDataXMLTools.store(this.model, this.getDataFile());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.changed = false;
        this.logger.debug("Saved to " + this.getDataFile().getAbsolutePath());
    }

    public void notifyUpdate() {
        this.changed = true;
        SaveThread st = this.saveThread;
        if (st != null) {
            st.notifySave();
        }
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
        if (autoSave) {
            if (this.saveThread != null) {
                this.saveThread.stopSave();
            }
            this.saveThread = new SaveThread();
            this.saveThread.start();
        } else if (this.saveThread != null) {
            this.saveThread.stopSave();
            this.saveThread = null;
        }
    }

    public boolean isSaveReady() {
        return this.changed;
    }

    @Override
    public GTDData.ActionProxy newAction(int id, Date created, Date resolved, String description) {
        return this.getProxy(new Action(id, created, resolved, description));
    }

    @Override
    public Folder newFolder(int id, String name, Folder.FolderType type) {
        Folder f = null;
        FolderData fd = new FolderData();
        f = type == Folder.FolderType.PROJECT ? new Project(this.model, id, name, fd) : new Folder(this.model, id, name, type, fd);
        this.notifyUpdate();
        return f;
    }

    @Override
    public void suspend(boolean b) {
    }

    @Override
    public GTDData.ActionProxy newAction(int id, Action aa, Integer project) {
        Action a = new Action(id, aa.getCreated(), aa.getResolved(), aa.getDescription());
        a.copy(aa);
        a.setProject(project);
        return this.getProxy(a);
    }

    @Override
    public void checkConsistency(Logger log, boolean fail, boolean correct) throws ConsistencyException {
    }

    @Override
    public String getDatabaseType() {
        return "XML";
    }

    class FolderData
    implements GTDData.FolderDataProxy {
        private List<GTDData.ActionProxy> actions = new ArrayList<GTDData.ActionProxy>();
        private String description;
        private Date created;
        private Date resolved;
        private Date modified;

        @Override
        public Date getCreated() {
            return this.created;
        }

        @Override
        public void setCreated(Date created) {
            this.created = created;
            this.modify();
            GTDDataXML.this.notifyUpdate();
        }

        @Override
        public Date getResolved() {
            return this.resolved;
        }

        @Override
        public void setResolved(Date resolved) {
            this.resolved = resolved;
            this.modify();
            GTDDataXML.this.notifyUpdate();
        }

        @Override
        public Date getModified() {
            return this.modified;
        }

        @Override
        public void setModified(Date modified) {
            this.modified = modified;
        }

        private void modify() {
            this.modified = new Date();
        }

        @Override
        public void add(GTDData.ActionProxy ap) {
            this.actions.add(ap);
            this.modify();
            GTDDataXML.this.notifyUpdate();
        }

        @Override
        public void add(int i, GTDData.ActionProxy ap) {
            this.actions.add(i, ap);
            this.modify();
            GTDDataXML.this.notifyUpdate();
        }

        @Override
        public void clear() {
            this.actions.clear();
            this.modify();
            GTDDataXML.this.notifyUpdate();
        }

        @Override
        public boolean remove(GTDData.ActionProxy i) {
            boolean b = this.actions.remove(i);
            this.modify();
            GTDDataXML.this.notifyUpdate();
            return b;
        }

        @Override
        public boolean remove(int i) {
            boolean b = this.actions.remove(i) != null;
            this.modify();
            GTDDataXML.this.notifyUpdate();
            return b;
        }

        @Override
        public void set(int i, GTDData.ActionProxy actionProxy) {
            this.actions.set(i, actionProxy);
            this.modify();
            GTDDataXML.this.notifyUpdate();
        }

        @Override
        public void sort(Comparator<Action> comparator) {
            Collections.sort(this.actions, new ProxyComparator(comparator));
            this.modify();
            GTDDataXML.this.notifyUpdate();
        }

        @Override
        public GTDData.ActionProxy[] toArray() {
            return this.actions.toArray(new GTDData.ActionProxy[this.actions.size()]);
        }

        @Override
        public void delete() {
            GTDDataXML.this.notifyUpdate();
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void setDescription(String desc) {
            this.description = desc;
            this.modify();
            GTDDataXML.this.notifyUpdate();
        }

        @Override
        public void store() {
            GTDDataXML.this.notifyUpdate();
        }

        @Override
        public boolean contains(GTDData.ActionProxy ap) {
            return this.actions.contains(ap);
        }

        @Override
        public Iterator<GTDData.ActionProxy> iterator(Folder.FolderPreset fp) {
            if (fp == Folder.FolderPreset.OPEN) {
                return new Iterator<GTDData.ActionProxy>(){
                    Iterator<GTDData.ActionProxy> i;
                    GTDData.ActionProxy next;
                    {
                        this.i = FolderData.this.actions.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next == null) {
                            this.next = this._next();
                            if (this.next == null) {
                                return false;
                            }
                        }
                        return true;
                    }

                    public GTDData.ActionProxy _next() {
                        if (this.i.hasNext()) {
                            GTDData.ActionProxy ap = this.i.next();
                            if (!ap.get().isOpen()) {
                                return this._next();
                            }
                            return ap;
                        }
                        return null;
                    }

                    @Override
                    public GTDData.ActionProxy next() {
                        if (!this.hasNext()) {
                            return null;
                        }
                        GTDData.ActionProxy ap = this.next;
                        this.next = null;
                        return ap;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
            return this.actions.iterator();
        }

        @Override
        public GTDData.ActionProxy get(int i) {
            return this.actions.get(i);
        }

        @Override
        public int size() {
            return this.actions.size();
        }

        @Override
        public void suspend(boolean b) {
        }

        private class ProxyComparator
        implements Comparator<GTDData.ActionProxy> {
            Comparator<Action> c;

            public ProxyComparator(Comparator<Action> c) {
                this.c = c;
            }

            @Override
            public int compare(GTDData.ActionProxy o1, GTDData.ActionProxy o2) {
                return this.c.compare(o1.get(), o2.get());
            }
        }
    }

    public class ActionProxyXML
    implements GTDData.ActionProxy {
        private Action a;
        private Folder parent;

        public ActionProxyXML(Action a) {
            this.a = a;
        }

        @Override
        public Action get() {
            return this.a;
        }

        @Override
        public int getId() {
            return this.a.getId();
        }

        @Override
        public void store() {
            GTDDataXML.this.notifyUpdate();
        }

        public boolean equals(Object obj) {
            return obj instanceof ActionProxyXML && ((ActionProxyXML)obj).a == this.a;
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        @Override
        public void delete() {
            GTDDataXML.this.notifyUpdate();
        }

        @Override
        public Folder getParent() {
            return this.parent;
        }

        @Override
        public void setParent(Folder parent) {
            this.parent = parent;
        }
    }

    class SaveThread
    extends Thread
    implements GTDModelListener {
        boolean destroyed;

        public SaveThread() {
            super("GTDDataXML-SaveThread");
            this.destroyed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.destroyed) {
                if (GTDDataXML.this.changed) {
                    try {
                        GTDDataXML.this.flush();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                SaveThread saveThread = this;
                synchronized (saveThread) {
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void elementAdded(FolderEvent a) {
            if (!a.isRecycled()) {
                this.notifySave();
            }
        }

        @Override
        public void elementModified(ActionEvent a) {
            if (!a.isRecycled()) {
                this.notifySave();
            }
        }

        @Override
        public void elementRemoved(FolderEvent a) {
            if (!a.isRecycled()) {
                this.notifySave();
            }
        }

        @Override
        public void folderAdded(Folder folder) {
            this.notifySave();
        }

        @Override
        public void folderModified(FolderEvent folder) {
            if (!folder.isRecycled()) {
                this.notifySave();
            }
        }

        @Override
        public void folderRemoved(Folder folder) {
            this.notifySave();
        }

        @Override
        public void orderChanged(Folder f) {
            this.notifySave();
        }

        public synchronized void notifySave() {
            GTDDataXML.this.logger.debug("Save ready.");
            GTDDataXML.this.changed = true;
            this.notify();
        }

        public synchronized void stopSave() {
            this.destroyed = true;
            this.notify();
        }
    }
}

