/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.gtdfree.GlobalProperties;
import org.gtdfree.model.Action;
import org.gtdfree.model.ConsistencyException;
import org.gtdfree.model.Folder;
import org.gtdfree.model.GTDData;
import org.gtdfree.model.GTDModel;
import org.gtdfree.model.Project;

public class GTDDataDefault
implements GTDData {
    private GTDModel model;
    private boolean closed = false;

    public GTDDataDefault() {
    }

    public GTDDataDefault(GTDModel m) {
        this.model = m;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean close(boolean t) throws IOException {
        this.closed = true;
        return true;
    }

    @Override
    public GTDData.ActionProxy getProxy(Action a) {
        if (a.getProxy() != null) {
            return a.getProxy();
        }
        return new Proxy(a);
    }

    @Override
    public void initialize(File f, GlobalProperties gp) {
    }

    @Override
    public GTDModel restore() throws IOException {
        if (this.model == null) {
            this.model = new GTDModel(null);
        }
        return this.model;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void store() {
    }

    @Override
    public GTDData.ActionProxy newAction(int id, Date created, Date resolved, String description) {
        return new Proxy(new Action(id, created, resolved, description));
    }

    @Override
    public Folder newFolder(int id, String name, Folder.FolderType type) {
        FolderData fd = new FolderData();
        Folder f = type == Folder.FolderType.PROJECT ? new Project(this.model, id, name, fd) : new Folder(this.model, id, name, type, fd);
        fd.setFolder(f);
        return f;
    }

    @Override
    public void suspend(boolean b) {
    }

    @Override
    public GTDData.ActionProxy newAction(int id, Action aa, Integer project) {
        Action a = new Action(id, aa.getCreated(), aa.getResolved(), aa.getDescription());
        a.copy(aa);
        a.setProject(project);
        return this.getProxy(a);
    }

    @Override
    public void checkConsistency(Logger log, boolean fail, boolean correct) throws ConsistencyException {
    }

    @Override
    public String getDatabaseType() {
        return "Dummy";
    }

    class FolderData
    implements GTDData.FolderDataProxy {
        private List<GTDData.ActionProxy> actions = new ArrayList<GTDData.ActionProxy>();
        private String description;
        private Date created;
        private Date resolved;
        private Date modified;

        @Override
        public Date getCreated() {
            return this.created;
        }

        @Override
        public void setCreated(Date created) {
            this.created = created;
        }

        @Override
        public Date getResolved() {
            return this.resolved;
        }

        @Override
        public void setResolved(Date resolved) {
            this.resolved = resolved;
        }

        @Override
        public Date getModified() {
            return this.modified;
        }

        private void modify() {
            this.modified = new Date();
        }

        @Override
        public void setModified(Date modified) {
            this.modified = modified;
        }

        @Override
        public void delete() {
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void setDescription(String desc) {
            this.description = desc;
            this.modify();
        }

        @Override
        public void store() {
        }

        @Override
        public boolean contains(GTDData.ActionProxy ap) {
            return this.actions.contains(ap);
        }

        @Override
        public GTDData.ActionProxy get(int i) {
            return this.actions.get(i);
        }

        @Override
        public int size() {
            return this.actions.size();
        }

        @Override
        public Iterator<GTDData.ActionProxy> iterator(Folder.FolderPreset fp) {
            if (fp == Folder.FolderPreset.OPEN) {
                return new Iterator<GTDData.ActionProxy>(){
                    Iterator<GTDData.ActionProxy> i;
                    GTDData.ActionProxy next;
                    {
                        this.i = FolderData.this.actions.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next == null) {
                            this.next = this._next();
                            if (this.next == null) {
                                return false;
                            }
                        }
                        return true;
                    }

                    public GTDData.ActionProxy _next() {
                        if (this.i.hasNext()) {
                            GTDData.ActionProxy ap = this.i.next();
                            if (!ap.get().isOpen()) {
                                return this._next();
                            }
                            return ap;
                        }
                        return null;
                    }

                    @Override
                    public GTDData.ActionProxy next() {
                        if (!this.hasNext()) {
                            return null;
                        }
                        GTDData.ActionProxy ap = this.next;
                        this.next = null;
                        return ap;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
            return this.actions.iterator();
        }

        public void setFolder(Folder folder) {
        }

        @Override
        public void add(GTDData.ActionProxy ap) {
            this.actions.add(ap);
            this.modify();
        }

        @Override
        public void add(int i, GTDData.ActionProxy ap) {
            this.actions.add(i, ap);
            this.modify();
        }

        @Override
        public void clear() {
            this.actions.clear();
            this.modify();
        }

        @Override
        public boolean remove(GTDData.ActionProxy i) {
            this.modify();
            return this.actions.remove(i);
        }

        @Override
        public boolean remove(int i) {
            this.modify();
            return this.actions.remove(i) != null;
        }

        @Override
        public void set(int i, GTDData.ActionProxy actionProxy) {
            this.actions.set(i, actionProxy);
            this.modify();
        }

        @Override
        public void sort(Comparator<Action> comparator) {
            Collections.sort(this.actions, new ProxyComparator(comparator));
            this.modify();
        }

        @Override
        public GTDData.ActionProxy[] toArray() {
            return this.actions.toArray(new GTDData.ActionProxy[this.actions.size()]);
        }

        @Override
        public void suspend(boolean b) {
        }

        public String toString() {
            return this.actions.toString();
        }

        private class ProxyComparator
        implements Comparator<GTDData.ActionProxy> {
            Comparator<Action> c;

            public ProxyComparator(Comparator<Action> c) {
                this.c = c;
            }

            @Override
            public int compare(GTDData.ActionProxy o1, GTDData.ActionProxy o2) {
                return this.c.compare(o1.get(), o2.get());
            }
        }
    }

    class Proxy
    implements GTDData.ActionProxy {
        Action action;
        Folder parent;

        public Proxy(Action a) {
            this.action = a;
            this.action.setProxy(this);
        }

        @Override
        public Action get() {
            return this.action;
        }

        @Override
        public int getId() {
            return this.action.getId();
        }

        @Override
        public void store() {
        }

        @Override
        public void delete() {
        }

        @Override
        public Folder getParent() {
            return this.parent;
        }

        @Override
        public void setParent(Folder parent) {
            this.parent = parent;
        }

        public String toString() {
            return this.action != null ? this.action.toString() : "NULL";
        }
    }
}

