/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.Messages;
import org.gtdfree.gui.WorkflowPane;
import org.gtdfree.model.Folder;

public class QuickCollectPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GTDFreeEngine engine;
    JTextArea ideaText;
    private AbstractAction clearAction;
    private AbstractAction doneNoteAction;
    private JRadioButton destinationInB;
    private JRadioButton destinationSel;

    public QuickCollectPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        int col = 0;
        this.add((Component)new JLabel(Messages.getString("QuickCollectPanel.Quick")), new GridBagConstraints(col++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 4, 2, 0), 0, 0));
        JScrollPane jsp = new JScrollPane();
        this.ideaText = new JTextArea();
        this.ideaText.setLineWrap(true);
        this.ideaText.setWrapStyleWord(true);
        this.ideaText.setRows(1);
        this.ideaText.setMargin(new Insets(2, 4, 2, 4));
        this.ideaText.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "Enter");
        this.ideaText.getActionMap().put("Enter", new AbstractAction(){
            private static final long serialVersionUID = 1348070910974195411L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (QuickCollectPanel.this.getDoneNoteAction().isEnabled()) {
                    QuickCollectPanel.this.getDoneNoteAction().actionPerformed(e);
                }
            }
        });
        this.ideaText.getInputMap().put(KeyStroke.getKeyStroke(10, 64), "NewLine");
        this.ideaText.getInputMap().put(KeyStroke.getKeyStroke(10, 128), "NewLine");
        this.ideaText.getActionMap().put("NewLine", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickCollectPanel.this.ideaText.insert("\n", QuickCollectPanel.this.ideaText.getCaretPosition());
            }
        });
        jsp.setViewportView(this.ideaText);
        jsp.setMinimumSize(this.ideaText.getPreferredScrollableViewportSize());
        jsp.setPreferredSize(this.ideaText.getPreferredScrollableViewportSize());
        this.add((Component)jsp, new GridBagConstraints(col++, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 4, 2, 0), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        this.destinationInB = new JRadioButton();
        this.destinationInB.setText(Messages.getString("QuickCollectPanel.InB.short"));
        this.destinationInB.setToolTipText(Messages.getString("QuickCollectPanel.InB.desc"));
        this.destinationInB.setSelected(true);
        bg.add(this.destinationInB);
        this.add((Component)this.destinationInB, new GridBagConstraints(col++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 0), 0, 0));
        this.destinationSel = new JRadioButton();
        this.destinationSel.setText(Messages.getString("QuickCollectPanel.Sel.short"));
        this.destinationSel.setToolTipText(Messages.getString("QuickCollectPanel.Sel.desc"));
        bg.add(this.destinationSel);
        this.add((Component)this.destinationSel, new GridBagConstraints(col++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 0, 4, 4), 0, 0));
        JButton b = new JButton();
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setAction(this.getDoneNoteAction());
        this.add((Component)b, new GridBagConstraints(col++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 4, 2, 0), 0, 0));
        b = new JButton();
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setAction(this.getClearAction());
        this.add((Component)b, new GridBagConstraints(col++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 4, 2, 4), 0, 0));
    }

    private Action getClearAction() {
        if (this.clearAction == null) {
            this.clearAction = new AbstractAction(Messages.getString("InBasketPane.Clear"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_clear)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    QuickCollectPanel.this.ideaText.setText("");
                    QuickCollectPanel.this.ideaText.requestFocus();
                }
            };
            this.clearAction.putValue("ShortDescription", Messages.getString("InBasketPane.Clear.desc"));
            this.clearAction.setEnabled(true);
        }
        return this.clearAction;
    }

    private Action getDoneNoteAction() {
        if (this.doneNoteAction == null) {
            this.doneNoteAction = new AbstractAction(Messages.getString("InBasketPane.Add"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_add)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (QuickCollectPanel.this.ideaText.getText() == null || QuickCollectPanel.this.ideaText.getText().length() == 0) {
                        return;
                    }
                    if (QuickCollectPanel.this.destinationInB.isSelected()) {
                        QuickCollectPanel.this.getEngine().getGTDModel().createAction(QuickCollectPanel.this.engine.getGTDModel().getInBucketFolder(), QuickCollectPanel.this.ideaText.getText());
                        QuickCollectPanel.this.ideaText.setText("");
                    } else {
                        Folder f;
                        WorkflowPane wp = QuickCollectPanel.this.getEngine().getActiveWorkflowPane();
                        if (wp != null && (f = wp.getSelectedFolder()) != null && (f.isUserFolder() || f.isInBucket())) {
                            QuickCollectPanel.this.getEngine().getGTDModel().createAction(f, QuickCollectPanel.this.ideaText.getText());
                            QuickCollectPanel.this.ideaText.setText("");
                        }
                    }
                }
            };
            this.doneNoteAction.putValue("ShortDescription", Messages.getString("InBasketPane.Add.desc"));
        }
        return this.doneNoteAction;
    }

    public void setEngine(GTDFreeEngine engine) {
        this.engine = engine;
    }

    public GTDFreeEngine getEngine() {
        return this.engine;
    }
}

