/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.Messages;
import org.gtdfree.model.GTDDataXMLTools;
import org.gtdfree.model.GTDModel;

public class ImportExampleDialog {
    private JDialog dialog;
    private JRadioButton serverRadio;
    private JRadioButton localRadio;
    private GTDFreeEngine engine;

    public static void main(String[] args) {
        ImportExampleDialog id = new ImportExampleDialog();
        id.getDialog(null).setVisible(true);
    }

    public JDialog getDialog(final Frame owner) {
        if (this.dialog == null) {
            this.dialog = new JDialog(owner, true);
            this.dialog.setTitle(Messages.getString("ImportExampleDialog.Imp.title"));
            JPanel p = new JPanel();
            p.setLayout(new GridBagLayout());
            int row = 0;
            JLabel l = new JLabel(Messages.getString("ImportExampleDialog.Imp.desc"));
            p.add((Component)l, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 17, 2, new Insets(11, 11, 11, 11), 0, 0));
            ButtonGroup bg = new ButtonGroup();
            this.serverRadio = new JRadioButton();
            this.serverRadio.setText(Messages.getString("ImportExampleDialog.Imp.Ser"));
            bg.add(this.serverRadio);
            p.add((Component)this.serverRadio, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 17, 2, new Insets(4, 11, 0, 11), 0, 0));
            l = new JLabel(Messages.getString("ImportExampleDialog.Imp.Ser.desc"));
            l.setFont(l.getFont().deriveFont(2));
            p.add((Component)l, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 17, 2, new Insets(4, 33, 4, 33), 0, 0));
            this.localRadio = new JRadioButton();
            this.localRadio.setText(Messages.getString("ImportExampleDialog.Imp.Loc"));
            bg.add(this.localRadio);
            p.add((Component)this.localRadio, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 17, 2, new Insets(4, 11, 0, 11), 0, 0));
            l = new JLabel(Messages.getString("ImportExampleDialog.Imp.Loc..desc"));
            l.setFont(l.getFont().deriveFont(2));
            p.add((Component)l, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 17, 2, new Insets(4, 33, 4, 33), 0, 0));
            this.serverRadio.setSelected(true);
            JButton b = new JButton();
            b.setText(Messages.getString("ImportExampleDialog.Import"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportExampleDialog.this.dialog.dispose();
                    ImportThread im = new ImportThread(ImportExampleDialog.this.serverRadio.isSelected(), owner);
                    im.start();
                }
            });
            p.add((Component)b, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 13, 0, new Insets(11, 11, 11, 4), 0, 0));
            b = new JButton();
            b.setText(Messages.getString("ImportExampleDialog.Cancel"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportExampleDialog.this.dialog.dispose();
                }
            });
            p.add((Component)b, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 10, 0, new Insets(11, 4, 11, 11), 0, 0));
            this.dialog.setContentPane(p);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setLocationRelativeTo(owner);
        }
        return this.dialog;
    }

    public void setEngine(GTDFreeEngine e) {
        this.engine = e;
    }

    class ImportThread
    extends Thread {
        private boolean server;
        private ProgressMonitor monitor;
        private GTDModel model;
        private Frame owner;

        public ImportThread(boolean server, Frame owner) {
            this.server = server;
            this.owner = owner;
        }

        @Override
        public void run() {
            try {
                this.monitor = new ProgressMonitor(this.owner, Messages.getString("ImportExampleDialog.Imp"), "", 0, 3);
                this.monitor.setMillisToDecideToPopup(0);
                this.monitor.setMillisToPopup(0);
                this.importExample(this.server);
                if (!this.monitor.isCanceled()) {
                    this.monitor.close();
                    ImportExampleDialog.this.engine.getGlobalProperties().putProperty("examplesImported", true);
                    JOptionPane.showMessageDialog(this.owner, Messages.getString("ImportExampleDialog.Imp.OK"), Messages.getString("ImportExampleDialog.Import"), 1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.monitor.close();
                JOptionPane.showMessageDialog(this.owner, Messages.getString("ImportExampleDialog.Imp.Fail") + " " + e.getMessage(), Messages.getString("ImportExampleDialog.Imp.Fail.title"), 0);
            }
        }

        private void importExample(boolean server) throws IOException, XMLStreamException, FactoryConfigurationError {
            InputStream example = null;
            if (server) {
                this.monitor.setNote(Messages.getString("ImportExampleDialog.Cont"));
                this.monitor.setProgress(0);
                String page = ImportExampleDialog.this.engine.getConfiguration().getProperty("example.url");
                URL url = new URL(page);
                BufferedReader rr = new BufferedReader(new InputStreamReader(url.openStream()));
                try {
                    ImportThread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if (this.monitor.isCanceled()) {
                    return;
                }
                try {
                    while (rr.ready()) {
                        int i;
                        if (this.monitor.isCanceled()) {
                            return;
                        }
                        String l = rr.readLine();
                        if (example != null || (i = l.indexOf("id=\"example\"")) <= 0) continue;
                        l = l.substring(i + 19);
                        l = l.substring(0, l.indexOf(34));
                        url = new URL(l);
                        example = url.openStream();
                    }
                }
                catch (IOException ex) {
                    throw ex;
                }
                finally {
                    if (rr != null) {
                        try {
                            rr.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            InputStream is = ApplicationHelper.class.getClassLoader().getResourceAsStream("gtd-free-example.xml");
            if (is != null) {
                example = is;
            }
            if (example != null) {
                if (this.monitor.isCanceled()) {
                    try {
                        example.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                this.monitor.setNote(Messages.getString("ImportExampleDialog.Read"));
                this.monitor.setProgress(1);
                this.model = new GTDModel(null);
                GTDDataXMLTools.importFile(this.model, example);
                try {
                    example.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.monitor.isCanceled()) {
                    return;
                }
                this.monitor.setNote(Messages.getString("ImportExampleDialog.Imp.File"));
                this.monitor.setProgress(2);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (ImportThread.this.monitor.isCanceled()) {
                                return;
                            }
                            ImportExampleDialog.this.engine.getGTDModel().importData(ImportThread.this.model);
                        }
                    });
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            } else {
                throw new IOException("Failed to obtain remote example file.");
            }
        }
    }
}

