/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.gtdfree.Messages;
import org.gtdfree.gui.ActionTransferHandler;
import org.gtdfree.gui.StringCellEditor;
import org.gtdfree.model.Action;
import org.gtdfree.model.Folder;
import org.gtdfree.model.GTDModel;

public class ActionFolderList
extends JTable {
    private static final long serialVersionUID = 1L;
    private GTDModel gtdModel;
    private FolderTableModel model = new FolderTableModel();
    private ActionTransferHandler transferHandler;

    public ActionFolderList() {
        this.initialize();
    }

    private void initialize() {
        this.setAutoCreateColumnsFromModel(true);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setModel(this.model);
        StringCellEditor sce = new StringCellEditor();
        sce.setFont(sce.getFont().deriveFont(1));
        this.setDefaultEditor(String.class, sce);
        this.setDefaultRenderer(String.class, new CellRenderer());
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.setRowHeight(fm.getHeight() + 3);
        this.transferHandler = new ActionTransferHandler(){
            private static final long serialVersionUID = 0L;

            @Override
            protected boolean importActions(Action[] a, Folder source, int[] indexes, TransferHandler.TransferSupport support) {
                int i = ActionFolderList.this.rowAtPoint(support.getDropLocation().getDropPoint());
                if (i > -1 && a != null) {
                    Folder target = ActionFolderList.this.model.getFolder(i);
                    ActionFolderList.this.gtdModel.moveActions(a, target);
                    return true;
                }
                return false;
            }

            @Override
            protected Action[] exportActions() {
                return null;
            }

            @Override
            protected int[] exportIndexes() {
                return null;
            }

            @Override
            protected Folder exportSourceFolder() {
                return null;
            }
        };
        this.setTransferHandler(this.transferHandler);
    }

    public GTDModel getGTDModel() {
        return this.gtdModel;
    }

    public void setGTDModel(GTDModel m) {
        this.gtdModel = m;
        this.model.reload(m);
        this.transferHandler.setModel(this.gtdModel);
    }

    public Folder getSelectedFolder() {
        int i = this.getSelectedRow();
        if (i > -1) {
            return this.model.getFolder(i);
        }
        return null;
    }

    public void addFolder(String name) {
        Folder f = this.gtdModel.createFolder(name, Folder.FolderType.ACTION);
        int i = this.model.addFolder(f);
        this.getSelectionModel().setSelectionInterval(i, i);
    }

    class FolderTableModel
    extends AbstractTableModel
    implements Comparator<Folder> {
        private static final long serialVersionUID = 1L;
        List<Folder> data = new ArrayList<Folder>();

        FolderTableModel() {
        }

        public int addFolder(Folder f) {
            this.data.add(f);
            this.sort();
            this.fireTableStructureChanged();
            return this.data.indexOf(f);
        }

        public void reload(GTDModel m) {
            this.data.clear();
            for (Folder folder : m) {
                if (folder.getType() != Folder.FolderType.ACTION) continue;
                this.data.add(folder);
            }
            this.sort();
            this.fireTableStructureChanged();
        }

        @Override
        public int compare(Folder o1, Folder o2) {
            return o1.getName().compareTo(o2.getName());
        }

        private void sort() {
            Collections.sort(this.data, this);
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.data.get(rowIndex).getName();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public String getColumnName(int column) {
            return Messages.getString("ActionFolderList.Lists");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                this.data.get(rowIndex).rename(aValue.toString());
                this.sort();
                this.fireTableDataChanged();
            }
        }

        public Folder getFolder(int i) {
            return this.data.get(i);
        }
    }

    class CellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setFont(this.getFont().deriveFont(1));
            return this;
        }
    }
}

