/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.addons;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.addons.ExportAddOn;
import org.gtdfree.model.Action;
import org.gtdfree.model.ActionsCollection;
import org.gtdfree.model.Folder;
import org.gtdfree.model.GTDModel;

public class PlainTextExportAddOn
implements ExportAddOn {
    private String description = "Exports GTD-Free data as plain text.";
    private ExportAddOn.ExportOrder[] orders = new ExportAddOn.ExportOrder[]{ExportAddOn.ExportOrder.FoldersActions, ExportAddOn.ExportOrder.ProjectsActions};
    private String name = "Plain Text";
    private FileFilter[] fileFilters = new FileFilter[]{new FileNameExtensionFilter("Plain text file", "txt")};

    @Override
    public void export(GTDModel model, ActionsCollection collection, OutputStream out, ExportAddOn.ExportOrder order, FileFilter ff, boolean compact) throws Exception {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
        Iterator<Object> it = collection.iterator(order);
        pw.println();
        pw.println("                                GTD-FREE DATA");
        pw.println();
        pw.print("@EXPORTED: ");
        pw.println(ApplicationHelper.toISODateTimeString(new Date()));
        pw.println("@FILE ENCODING: UTF-8");
        pw.println();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof Folder) {
                Folder f = (Folder)o;
                if (f.isProject()) {
                    if (order != ExportAddOn.ExportOrder.ProjectsActions) continue;
                    pw.print("@PROJECT: ");
                    pw.println(f.getName());
                    pw.print("@ID: ");
                    pw.println(f.getId());
                    pw.println("@DESCRIPTION: ");
                    pw.print("~~");
                    pw.print(f.getDescription());
                    pw.println("~~");
                    pw.println();
                    continue;
                }
                if (order != ExportAddOn.ExportOrder.FoldersActions) continue;
                pw.print("@LIST: ");
                pw.println(f.getName());
                pw.print("@ID: ");
                pw.println(f.getId());
                pw.println("@DESCRIPTION: ");
                pw.print("~~");
                pw.print(f.getDescription());
                pw.println("~~");
                pw.println();
                continue;
            }
            if (o instanceof Action) {
                Action a = (Action)o;
                pw.print("@ACTION: ");
                pw.println(a.getId());
                pw.print("@STATUS: ");
                pw.println((Object)a.getResolution());
                pw.println("@DESCRIPTION: ");
                pw.print("~~");
                pw.print(a.getDescription());
                pw.println("~~");
                pw.println();
                continue;
            }
            if (o != ActionsCollection.ACTIONS_WITHOUT_PROJECT) continue;
            pw.println(o.toString());
            pw.println();
        }
        pw.flush();
    }

    @Override
    public ExportAddOn.ExportOrder getDefaultExportOrder() {
        return ExportAddOn.ExportOrder.FoldersProjectsActions;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ExportAddOn.ExportOrder[] getSupportedExportOrders() {
        return this.orders;
    }

    @Override
    public FileFilter[] getFileFilters() {
        return this.fileFilters;
    }

    @Override
    public JComponent getComponent() {
        return null;
    }

    @Override
    public void initialize(GTDFreeEngine engine) {
    }
}

