#
# Simple awk script to generate a .def file from an .exp file
# Copyright (C) 2000 Andrew Zabolotny  All Rights Reserved
#
# The following variables should be defined prior to running this script:
#
#   LOCALS = 1 if only local functions should be put into the EXPORTS section.
#   IMPORT = the name of the library we import from (to which forwarders point).
#

BEGIN{
  count = 0;
  if (IMPORT == "")
  {
    print "The IMPORT variable is not defined. Run this script"
    print "with the -v IMPORT=xxx command-line options."
    exit(-1);
  }
}

END{
  print "IMPORTS"
  for (i = 1; i < count; i++)
  {
    prefix = (exptype [i] == "L") ? "FWD" : "";
    print "	" prefix expname [i] " = " IMPORT "." expord [i];
  }

  print "EXPORTS"
  for (i = 1; i < count; i++)
    if ((LOCALS == 1) == (exptype [i] == "L"))
      print "	" expname [i] " @" expord [i] " " expopt [i];
}

/#.*/{
  /* Ignore lines beginning with # */
  next;
}

{
  /* Ignore empty lines */
  if ($0 == "") next;
  count++;
  exptype [count] = $1;
  expname [count] = $2;
  expord [count] = $3;
  expopt [count] = ($4 == "") ? "NONAME" : $4;
}
