#include "actioneventqueue.h"
#include <iostream>
using std::cout;

namespace p {
    ActionEventQueue* aequeue;
}

bool done = false;

class SimpleEvent : public ActionEvent {
public:
    SimpleEvent() : ActionEvent(1), n(30) {}
    void run() {
        cout << "Simple Event, " << n-- << " ticks remaining\n";
        if (0 == n) {
            done = true;
            delete this; return;
        }
        p::aequeue->scheduleEvent(this);
    }
private:
    int n;
};

int main()
{
    SDL_Init(SDL_INIT_TIMER);
    p::aequeue = new ActionEventQueue();
    p::aequeue->scheduleEvent(new SimpleEvent());
    cout << "Starting up\n";
    while (!done) {
        p::aequeue->runEvents();
    }
    cout << "Shutting down\n";
    delete p::aequeue;
    SDL_Quit();
    return 0;
}

