// mode: -*- C++ -*-
#ifndef IMAGECACHE_H
#define IMAGECACHE_H

#include <map>
#include <string>
#include <vector>
#include "SDL.h"
#include "shpimage.h"

struct ImageCacheEntry
{
    ImageCacheEntry();
    ~ImageCacheEntry();
    void clear();
    SDL_Surface *image;
    SDL_Surface *shadow;
};

class ImageCache
{
public:
    ImageCache();
    ~ImageCache();
    void setImagePool(std::vector<SHPImage *> *imagepool);
    ImageCacheEntry& getImage(Uint32 imgnum);

    /** @TODO Arbitrary post-processing filter, e.g. colour fiddling.
     * ImageCacheEntry& getText(const char*); // Caches text
     * 1) typedef void (FilterFunc*)(Uint32, ImageCacheEntry&);  OR
     * 2) Policy class that provides this API:
     *    struct FilterFunc : public binary_functor(?) {
     *         void operator()(Uint32, ImageCacheEntry&);
     *    };
     * void applyFilter(const char* fname, const FilterFunc&);
     */
    /// @brief Loads the shpimage fname into the imagecache.
    Uint32 loadImage(const char* fname);

    void newCache();
private:
    std::map<Uint32, ImageCacheEntry> cache, prevcache;
    std::map<std::string, Uint32> namecache;
    std::vector<SHPImage*>* imagepool;
};

#endif
