// mode: -*- C++ -*-
#ifndef FONT_H
#define FONT_H
#include <string>
#include <vector>
#include "SDL_types.h"
#include "shpimage.h"

class Font : SHPBase {
public:
    Font(const std::string& fontname);
    ~Font();
    Uint32 getHeight() const;
    Uint32 calcTextWidth(const std::string& text) const;
    void drawText(const std::string& text, SDL_Surface* dest, Uint32 startx, Uint32 starty) const;
    using SHPBase::getName;
private:
    SDL_Surface* fontimg;
    std::vector<SDL_Rect> chrdest;
};
#endif
