#include "common.h"
#include "logger.h"
#include "moneycounter.h"
#include "soundengine.h"

void MoneyCounter::run()
{
    queued = false;
    Uint8 Dcred = step(creditleft);
    Uint8 Ddebt = step(debitleft);
    if (Dcred > 0) {
        money += Dcred;
    } else if (sound && creditsound != -1) {
        pc::sfxeng->StopLoopedSound(creditsound);
        creditsound = -1;
    }
    if (Ddebt > 0) {
        money -= Ddebt;
    } else if (sound && debitsound != -1) {
        pc::sfxeng->StopLoopedSound(debitsound);
        debitsound = -1;
    }

    if (Dcred > 0 || Ddebt > 0) {
        p::aequeue->scheduleEvent(this);
        queued = true;
    }
}

void MoneyCounter::addCredit(Uint32 amount)
{
    creditleft += amount;
    if (sound && -1 == creditsound) {
        /// @TODO Get this value from a global config object
        creditsound = pc::sfxeng->PlayLoopedSound("tone15.aud",0);
    }
    reshedule();
}

void MoneyCounter::addDebit(Uint32 amount)
{
    debitleft += amount;
    if (sound && -1 == debitsound) {
        /// @TODO Get this value from a global config object
        debitsound = pc::sfxeng->PlayLoopedSound("tone16.aud",0);
    }
    reshedule();
}

Uint8 MoneyCounter::step(Uint32& value)
{
    if (0 == value) {
        return 0;
    }
    if (value < delta) {
        Uint8 oldvalue = value;
        value = 0;
        return oldvalue;
    } else {
        value -= delta;
        return delta;
    }
}

void MoneyCounter::reshedule() {
    if (!queued) {
        queued = true;
        p::aequeue->scheduleEvent(this);
    }
}
