/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.exolab.castor.jdo.engine.BaseFactory;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorRegistry;
import org.exolab.castor.jdo.engine.SQLTypes;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.ExtendedFieldHandler;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.GeneralizedFieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerFriend;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.CacheTypeMapping;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.mapping.xml.Param;
import org.exolab.castor.mapping.xml.types.DirtyType;
import org.exolab.castor.util.Messages;

public class JDOMappingLoader
extends MappingLoader {
    private Hashtable _keyGenDefs = new Hashtable();
    private Hashtable _keyGenDescs = new Hashtable();
    private BaseFactory _factory;
    private KeyGeneratorRegistry _keyGenReg = new KeyGeneratorRegistry();
    static /* synthetic */ Class class$org$exolab$castor$mapping$FieldHandler;

    public JDOMappingLoader(ClassLoader loader, PrintWriter logWriter) {
        super(loader, logWriter);
    }

    protected ClassDescriptor createDescriptor(ClassMapping clsMap) throws MappingException {
        CacheTypeMapping cacheMapping;
        if (clsMap.getMapTo() == null || clsMap.getMapTo().getTable() == null) {
            return NoDescriptor;
        }
        ClassDescriptor clsDesc = this.loadClassDescriptor(clsMap.getName());
        if (clsDesc != null && clsDesc instanceof JDOClassDescriptor) {
            return clsDesc;
        }
        clsDesc = super.createDescriptor(clsMap);
        if (clsDesc.getIdentity() == null) {
            throw new MappingException("mapping.noIdentity", clsDesc.getJavaClass().getName());
        }
        String keyGenName = clsMap.getKeyGenerator();
        KeyGeneratorDescriptor keyGenDesc = null;
        if (keyGenName != null) {
            KeyGeneratorDef keyGenDef = (KeyGeneratorDef)this._keyGenDefs.get(keyGenName);
            Properties params = new Properties();
            String keyGenFactoryName = keyGenName;
            if (keyGenDef != null) {
                keyGenFactoryName = keyGenDef.getName();
                Enumeration enumeration = keyGenDef.enumerateParam();
                while (enumeration.hasMoreElements()) {
                    Param par = (Param)enumeration.nextElement();
                    params.put(par.getName(), par.getValue());
                }
            }
            if ((keyGenDesc = (KeyGeneratorDescriptor)this._keyGenDescs.get(keyGenName)) == null) {
                keyGenDesc = new KeyGeneratorDescriptor(keyGenName, keyGenFactoryName, params, this._keyGenReg);
                this._keyGenDescs.put(keyGenName, keyGenDesc);
            }
        }
        JDOClassDescriptor jd = (cacheMapping = clsMap.getCacheTypeMapping()) != null ? new JDOClassDescriptor(clsDesc, clsMap.getMapTo().getTable(), keyGenDesc, cacheMapping.getType().toString(), cacheMapping.getCapacity()) : new JDOClassDescriptor(clsDesc, clsMap.getMapTo().getTable(), keyGenDesc, null, 0);
        jd.setMapping(clsMap);
        return jd;
    }

    protected String[] getSqlTypes(FieldMapping fieldMap) {
        int current;
        if (fieldMap.getSql() == null) {
            return new String[0];
        }
        String sqlType = fieldMap.getSql().getType();
        if (sqlType == null) {
            return new String[0];
        }
        ArrayList<String> types = new ArrayList<String>();
        int begin = 0;
        int state = 0;
        block4: for (current = 0; current < sqlType.length(); ++current) {
            switch (state) {
                case 0: {
                    if (sqlType.charAt(current) == ' ') {
                        types.add(sqlType.substring(begin, current));
                        begin = current + 1;
                        continue block4;
                    }
                    if (sqlType.charAt(current) != '[') continue block4;
                    state = 1;
                    continue block4;
                }
                case 1: {
                    if (sqlType.charAt(current) != ']') continue block4;
                    state = 0;
                }
            }
        }
        types.add(sqlType.substring(begin, current));
        String[] result = new String[types.size()];
        return types.toArray(result);
    }

    protected TypeInfo getTypeInfo(Class fieldType, CollectionHandler colHandler, FieldMapping fieldMap) throws MappingException {
        TypeConvertor convertorTo = null;
        TypeConvertor convertorFrom = null;
        String convertorParam = null;
        String typeName = null;
        Class sqlType = null;
        fieldType = Types.typeFromPrimitive(fieldType);
        String[] sqlTypes = this.getSqlTypes(fieldMap);
        if (fieldMap.getSql() != null && sqlTypes.length > 0) {
            typeName = sqlTypes[0];
            sqlType = SQLTypes.typeFromName(typeName);
        } else {
            sqlType = fieldType;
        }
        if (this._factory != null) {
            sqlType = this._factory.adjustSqlType(sqlType);
        }
        if (fieldType != sqlType) {
            block14: {
                try {
                    convertorTo = SQLTypes.getConvertor(sqlType, fieldType);
                }
                catch (MappingException ex) {
                    boolean isTypeSafeEnum = false;
                    if (fieldType != null && !JDOMappingLoader.isPrimitive(fieldType)) {
                        Constructor cons = null;
                        try {
                            cons = fieldType.getConstructor(EMPTY_ARGS);
                            if (!Modifier.isPublic(cons.getModifiers())) {
                                cons = null;
                            }
                        }
                        catch (NoSuchMethodException nsmx) {
                            // empty catch block
                        }
                        try {
                            int mods;
                            Method method;
                            Class<?> returnType;
                            if (cons == null && (returnType = (method = fieldType.getMethod("valueOf", STRING_ARG)).getReturnType()) != null && fieldType.isAssignableFrom(returnType) && Modifier.isStatic(mods = method.getModifiers())) {
                                convertorTo = new SQLTypes.SQLTypeConvertor(sqlType, fieldType){
                                    private Method method = null;

                                    public Object convert(Object obj, String param) {
                                        try {
                                            if (this.method == null) {
                                                this.method = this.toType.getMethod("valueOf", STRING_ARG);
                                            }
                                            return this.method.invoke((Object)this.toType, (String)obj);
                                        }
                                        catch (Exception ex) {
                                            return null;
                                        }
                                    }
                                };
                                Types.addEnumType(fieldType);
                                isTypeSafeEnum = true;
                            }
                        }
                        catch (NoSuchMethodException nsmx) {
                            // empty catch block
                        }
                    }
                    if (isTypeSafeEnum) break block14;
                    throw new MappingException("mapping.noConvertor", sqlType.getName(), fieldType.getName());
                }
            }
            convertorFrom = SQLTypes.getConvertor(fieldType, sqlType);
            if (typeName != null) {
                convertorParam = SQLTypes.paramFromName(typeName);
            }
        }
        return new TypeInfo(fieldType, convertorTo, convertorFrom, convertorParam, fieldMap.getRequired(), null, colHandler);
    }

    protected FieldDescriptor createFieldDesc(Class javaClass, FieldMapping fieldMap) throws MappingException {
        int[] sType;
        if (fieldMap.getSql() == null) {
            return super.createFieldDesc(javaClass, fieldMap);
        }
        String fieldName = fieldMap.getName();
        Class fieldType = null;
        if (fieldMap.getType() != null) {
            try {
                fieldType = this.resolveType(fieldMap.getType());
            }
            catch (ClassNotFoundException except) {
                throw new MappingException("mapping.classNotFound", fieldMap.getType());
            }
        }
        CollectionHandler colHandler = null;
        if (fieldMap.getCollection() != null) {
            Class colType = CollectionHandlers.getCollectionType(fieldMap.getCollection().toString());
            colHandler = CollectionHandlers.getHandler(colType);
        }
        TypeInfo typeInfo = this.getTypeInfo(fieldType, colHandler, fieldMap);
        FieldHandlerFriend exfHandler = null;
        FieldHandler handler = null;
        if (fieldMap.getHandler() != null) {
            Class handlerClass = null;
            try {
                handlerClass = this.resolveType(fieldMap.getHandler());
            }
            catch (ClassNotFoundException except) {
                throw new MappingException("mapping.classNotFound", fieldMap.getHandler());
            }
            if (!(class$org$exolab$castor$mapping$FieldHandler == null ? (class$org$exolab$castor$mapping$FieldHandler = JDOMappingLoader.class$("org.exolab.castor.mapping.FieldHandler")) : class$org$exolab$castor$mapping$FieldHandler).isAssignableFrom(handlerClass)) {
                String err = "The class '" + fieldMap.getHandler() + "' must implement " + (class$org$exolab$castor$mapping$FieldHandler == null ? (class$org$exolab$castor$mapping$FieldHandler = JDOMappingLoader.class$("org.exolab.castor.mapping.FieldHandler")) : class$org$exolab$castor$mapping$FieldHandler).getName();
                throw new MappingException(err);
            }
            Constructor constructor = null;
            try {
                constructor = handlerClass.getConstructor(new Class[0]);
                handler = (FieldHandler)constructor.newInstance(new Object[0]);
            }
            catch (Exception except) {
                String err = "The class '" + handlerClass.getName() + "' must have a default public constructor.";
                throw new MappingException(err);
            }
            if (handler instanceof ExtendedFieldHandler) {
                exfHandler = (ExtendedFieldHandler)handler;
            }
            colHandler = typeInfo.getCollectionHandler();
            typeInfo.setCollectionHandler(null);
            handler = new FieldHandlerImpl(handler, typeInfo);
            typeInfo.setCollectionHandler(colHandler);
        }
        boolean generalized = exfHandler instanceof GeneralizedFieldHandler;
        FieldHandler custom = handler;
        if (generalized) {
            fieldType = ((GeneralizedFieldHandler)exfHandler).getFieldType();
        }
        if (generalized || handler == null) {
            MappingLoader.TypeInfoReference typeInfoRef = new MappingLoader.TypeInfoReference(this);
            typeInfoRef.typeInfo = typeInfo;
            handler = this.createFieldHandler(javaClass, fieldType, fieldMap, typeInfoRef);
            if (custom != null) {
                ((GeneralizedFieldHandler)exfHandler).setFieldHandler(handler);
                handler = custom;
            } else {
                typeInfo = typeInfoRef.typeInfo;
            }
        }
        FieldDescriptorImpl fieldDesc = new FieldDescriptorImpl(fieldName, typeInfo, handler, fieldMap.getTransient());
        fieldDesc.setRequired(fieldMap.getRequired());
        if (exfHandler != null) {
            exfHandler.setFieldDescriptor(fieldDesc);
        }
        if (fieldMap.getSql().getTransient()) {
            fieldDesc.setTransient(true);
        }
        String[] sqlName = fieldMap.getSql().getName();
        String[] sqlTypes = this.getSqlTypes(fieldMap);
        int len = sqlTypes.length;
        if (len > 0) {
            sType = new int[len];
            for (int i = 0; i < len; ++i) {
                Class sqlType = SQLTypes.typeFromName(sqlTypes[i]);
                if (this._factory != null) {
                    sqlType = this._factory.adjustSqlType(sqlType);
                }
                sType[i] = SQLTypes.getSQLType(sqlType);
            }
        } else {
            Class sqlType = fieldDesc.getFieldType();
            if (this._factory != null) {
                sqlType = this._factory.adjustSqlType(sqlType);
            }
            sType = new int[]{SQLTypes.getSQLType(sqlType)};
        }
        return new JDOFieldDescriptor(fieldDesc, sqlName, sType, !DirtyType.IGNORE.equals(fieldMap.getSql().getDirty()), fieldMap.getSql().getManyTable(), fieldMap.getSql().getManyKey(), fieldMap.getSql().getReadonly());
    }

    public void loadMapping(MappingRoot mapping, Object param) throws MappingException {
        this._factory = (BaseFactory)param;
        Enumeration enumeration = mapping.enumerateKeyGeneratorDef();
        while (enumeration.hasMoreElements()) {
            KeyGeneratorDef keyGenDef = (KeyGeneratorDef)enumeration.nextElement();
            String name = keyGenDef.getAlias();
            if (name == null) {
                name = keyGenDef.getName();
            }
            if (this._keyGenDefs.get(name) != null) {
                throw new MappingException(Messages.format("mapping.dupKeyGen", name));
            }
            this._keyGenDefs.put(name, keyGenDef);
        }
        super.loadMapping(mapping, null);
        this._keyGenDefs = null;
        this._keyGenDescs = null;
        this._keyGenReg = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

