/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.windowcloser;

import com.mayastudios.mscl.mwt.windowcloser.IWindowCloseListener;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class CWindowCloser
extends WindowAdapter {
    private final Window m_window;
    private final IWindowCloseListener m_listener;

    private CWindowCloser(Window window, IWindowCloseListener iWindowCloseListener) {
        this.m_window = window;
        this.m_listener = iWindowCloseListener;
        window.addWindowListener(this);
        if (this.m_window instanceof JFrame) {
            JFrame jFrame = (JFrame)window;
            jFrame.setDefaultCloseOperation(0);
        } else if (this.m_window instanceof JDialog) {
            JDialog jDialog = (JDialog)window;
            jDialog.setDefaultCloseOperation(0);
        }
    }

    public static void initObservation(Window window) {
        CWindowCloser.initObservation(window, null);
    }

    public static void initObservation(Window window, IWindowCloseListener iWindowCloseListener) {
        new CWindowCloser(window, iWindowCloseListener);
    }

    public static void closeWindow(Window window) {
        window.setVisible(false);
        window.dispose();
        System.gc();
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.m_listener != null && !this.m_listener.windowClosingPerformed()) {
            return;
        }
        this.m_window.dispose();
        System.gc();
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (this.m_listener == null || !this.m_listener.terminateApp()) {
            return;
        }
        System.gc();
        System.exit(this.m_listener.getExitCode());
    }
}

