/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.widgets;

import java.awt.AWTException;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;

public class SplashScreen
extends JWindow {
    private static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    private static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private static final SplashScreen INSTANCE = new SplashScreen();
    private JLabel m_oImage = new JLabel();
    private JPanel m_oCurOverlay = null;
    private Timer m_oTimer = new Timer(0, new TimerListener());
    private IPaintListener m_oListener = null;

    private SplashScreen() {
        this.getContentPane().add(this.m_oImage);
        this.setCursor(WAIT_CURSOR);
        this.setAlwaysOnTop(true);
        this.m_oTimer.setRepeats(false);
    }

    public static void showAlwaysOnTop(boolean bl) {
        INSTANCE.setAlwaysOnTop(bl);
    }

    public static void openSplashScreen(Icon icon, IPaintListener iPaintListener, boolean bl) {
        SplashScreen.openSplashScreen(icon, iPaintListener, bl, null);
    }

    public static synchronized void openSplashScreen(Icon icon, IPaintListener iPaintListener, boolean bl, JPanel jPanel) {
        ImageIcon imageIcon;
        if (icon == null) {
            throw new IllegalArgumentException("No splash image available!");
        }
        if (bl && (imageIcon = SplashScreen.composeAlphaDesktopImage((SplashScreen.SCREEN_SIZE.width - icon.getIconWidth()) / 2, (SplashScreen.SCREEN_SIZE.height - icon.getIconHeight()) / 2, icon)) != null) {
            icon = imageIcon;
        }
        SplashScreen.INSTANCE.m_oImage.setIcon(icon);
        if (jPanel != null) {
            if (SplashScreen.INSTANCE.m_oCurOverlay != null) {
                INSTANCE.getLayeredPane().remove(SplashScreen.INSTANCE.m_oCurOverlay);
            }
            jPanel.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
            jPanel.setCursor(WAIT_CURSOR);
            jPanel.setOpaque(false);
            INSTANCE.getLayeredPane().add(jPanel);
            SplashScreen.INSTANCE.m_oCurOverlay = jPanel;
        }
        INSTANCE.setBounds((SplashScreen.SCREEN_SIZE.width - icon.getIconWidth()) / 2, (SplashScreen.SCREEN_SIZE.height - icon.getIconHeight()) / 2, icon.getIconWidth(), icon.getIconHeight());
        SplashScreen.INSTANCE.m_oListener = iPaintListener;
        INSTANCE.setVisible(true);
    }

    public static ImageIcon composeAlphaDesktopImage(int n, int n2, Icon icon) {
        BufferedImage bufferedImage;
        Object object;
        try {
            object = new Robot();
            ((Robot)object).delay(200);
            bufferedImage = ((Robot)object).createScreenCapture(new Rectangle(n, n2, icon.getIconWidth(), icon.getIconHeight()));
        }
        catch (AWTException aWTException) {
            return null;
        }
        object = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 1);
        Graphics2D graphics2D = (Graphics2D)((BufferedImage)object).getGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return new ImageIcon((Image)object);
    }

    public static void closeSplashScreen() {
        SplashScreen.closeSplashScreen(0);
    }

    public static synchronized void closeSplashScreen(int n) {
        SplashScreen.INSTANCE.m_oTimer.stop();
        if (n <= 0) {
            INSTANCE._hideSplashScreen();
        } else {
            SplashScreen.INSTANCE.m_oTimer.setInitialDelay(n);
            SplashScreen.INSTANCE.m_oTimer.start();
        }
    }

    private void _hideSplashScreen() {
        this.setVisible(false);
        this.dispose();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_oListener != null) {
            this.m_oListener.paintPerformed();
            this.m_oListener = null;
        }
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SplashScreen.this._hideSplashScreen();
        }
    }

    public static interface IPaintListener {
        public void paintPerformed();
    }
}

