/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.widgets;

import com.mayastudios.mscl.mwt.CBufferedComponent;
import com.mayastudios.mscl.mwt.widgets.AutoFillViewContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.ViewportLayout;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class CTableScrollPane
extends JScrollPane {
    public CTableScrollPane(JTable jTable) {
        CTableContainer cTableContainer = new CTableContainer();
        cTableContainer.setContent(jTable);
        super.setViewportView(cTableContainer);
        this.setColumnHeaderView(jTable.getTableHeader());
        Border border = this.getBorder();
        if (border == null || border instanceof UIResource) {
            this.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        }
        this.setCorner("UPPER_RIGHT_CORNER", new CCornerImage());
    }

    @Deprecated
    public void setViewport(JViewport jViewport) {
        super.setViewport(jViewport);
    }

    @Deprecated
    public void setViewportView(Component component) {
        super.setViewportView(component);
    }

    protected JViewport createViewport() {
        return new CTableViewport();
    }

    public static class CTableHeaderImage {
        private final JTableHeader mf_oEmptyTableHeader;
        private final CBufferedComponent mf_oTableHeaderOffscreen = new CBufferedComponent();
        private static final CTableHeaderImage INSTANCE = new CTableHeaderImage();

        private CTableHeaderImage() {
            JTable jTable = new JTable(new Object[][]{{""}}, new Object[]{""});
            this.mf_oEmptyTableHeader = jTable.getTableHeader();
            this.mf_oTableHeaderOffscreen.getPanel().setLayout(new BorderLayout());
            this.mf_oTableHeaderOffscreen.getPanel().add(this.mf_oEmptyTableHeader);
        }

        public static synchronized BufferedImage createImage(int n, int n2) {
            CTableHeaderImage.INSTANCE.mf_oEmptyTableHeader.getColumnModel().getColumn(0).setWidth(n);
            return CTableHeaderImage.INSTANCE.mf_oTableHeaderOffscreen.convertToBufferedImage(n, n2);
        }
    }

    private class CCornerImage
    extends JComponent {
        private CCornerImage() {
        }

        protected void paintComponent(Graphics graphics) {
            graphics.drawImage(CTableHeaderImage.createImage(this.getWidth() + 10, this.getHeight()), -5, 0, null);
        }
    }

    private static class CTableContainer
    extends AutoFillViewContainer {
        private static final Color BACKGROUND_COLOR = new Color(90, 85, 85);
        private JTable m_oContainedTable = null;

        private CTableContainer() {
        }

        public void setContent(Component component) {
            this.m_oContainedTable = component instanceof JTable ? (JTable)component : null;
            super.setContent(component);
        }

        protected void paintComponent(Graphics2D graphics2D) {
            if (this.m_oContainedTable == null) {
                super.paintComponent(graphics2D);
                return;
            }
            graphics2D.setColor(BACKGROUND_COLOR);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.m_oContainedTable.getRowCount() > 0) {
                int n = 0;
                int n2 = this.m_oContainedTable.getIntercellSpacing().height;
                int n3 = this.getWidth();
                int n4 = n3 - this.m_oContainedTable.getWidth();
                int n5 = this.m_oContainedTable.getWidth();
                Color color = this.m_oContainedTable.getGridColor();
                Color color2 = this.m_oContainedTable.getBackground();
                for (int i = 0; i < this.m_oContainedTable.getRowCount(); ++i) {
                    int n6 = this.m_oContainedTable.getRowHeight(i);
                    if (n + n6 - 1 >= 0 && n + n6 - 1 < this.getHeight()) {
                        TableCellRenderer tableCellRenderer = this.m_oContainedTable.getCellRenderer(i, 0);
                        Component component = tableCellRenderer.getTableCellRendererComponent(this.m_oContainedTable, this.m_oContainedTable.getValueAt(i, 0), this.m_oContainedTable.isRowSelected(i), this.m_oContainedTable.hasFocus(), i, 0);
                        if (!component.isOpaque()) {
                            graphics2D.setColor(color2);
                        } else {
                            graphics2D.setColor(component.getBackground());
                        }
                        graphics2D.fillRect(n5, n, n4, n6 - 1);
                        graphics2D.setColor(color);
                        if (n2 == 1) {
                            graphics2D.drawLine(n5, n + n6 - 1, n3, n + n6 - 1);
                        } else {
                            graphics2D.fillRect(n5, n + n6 - n2, n4, n2);
                        }
                    }
                    n += n6;
                }
                graphics2D.drawLine(0, n, n3, n);
            }
        }

        public Dimension getPreferredScrollableViewportSize() {
            if (this.m_oContainedTable == null) {
                return new Dimension(0, 0);
            }
            return this.m_oContainedTable.getPreferredScrollableViewportSize();
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            if (this.m_oContainedTable == null) {
                return 1;
            }
            return this.m_oContainedTable.getScrollableBlockIncrement(rectangle, n, n2);
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            if (this.m_oContainedTable == null) {
                return 1;
            }
            return this.m_oContainedTable.getScrollableUnitIncrement(rectangle, n, n2);
        }
    }

    private class CTableViewport
    extends JViewport {
        public CTableViewport() {
            this.setLayout(new CTableHeaderLayoutManager());
        }

        protected void paintComponent(Graphics graphics) {
            Component component = this.getView();
            if (component instanceof JTableHeader) {
                JTableHeader jTableHeader = (JTableHeader)component;
                int n = jTableHeader.getColumnModel().getTotalColumnWidth();
                int n2 = this.getWidth() - n + 5;
                graphics.drawImage(CTableHeaderImage.createImage(n2, this.getHeight()), n, 0, null);
            } else {
                super.paintComponent(graphics);
            }
        }

        private class CTableHeaderLayoutManager
        extends ViewportLayout {
            private CTableHeaderLayoutManager() {
            }

            public void layoutContainer(Container container) {
                CTableViewport cTableViewport = (CTableViewport)container;
                Component component = cTableViewport.getView();
                if (!(component instanceof JTableHeader)) {
                    super.layoutContainer(container);
                    return;
                }
                JTableHeader jTableHeader = (JTableHeader)component;
                cTableViewport.setViewSize(new Dimension(jTableHeader.getColumnModel().getTotalColumnWidth(), container.getHeight()));
            }
        }
    }
}

