/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.widgets;

import com.mayastudios.mscl.MSCLResLoader;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.mwt.widgets.ABoundsHelperPanel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class CActivityIndicator
extends ABoundsHelperPanel {
    private static final ImageIcon INDICATOR_IMAGE;
    private static final int INDICATOR_WIDTH;
    private static final int INDICATOR_HEIGHT;
    private JLabel m_oLastImage;

    public CActivityIndicator() {
        super(true);
        this.setBorder(BorderFactory.createLineBorder(SystemColor.controlDkShadow));
        this.setFocusable(false);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, INDICATOR_HEIGHT);
    }

    public Dimension getPreferredSize() {
        return new Dimension(INDICATOR_WIDTH, INDICATOR_HEIGHT);
    }

    public int getPrefferedHeight() {
        Insets insets = this.getInsets();
        return INDICATOR_HEIGHT + insets.top + insets.bottom;
    }

    protected void boundsChanged(int n, int n2, ABoundsHelperPanel.EChangeType eChangeType) {
        if (!eChangeType.isResized()) {
            return;
        }
        Insets insets = this.getInsets();
        int n3 = n / INDICATOR_WIDTH + 1;
        if (this.getComponentCount() < n3) {
            for (int i = this.getComponentCount(); i < n3; ++i) {
                JLabel jLabel = new JLabel(INDICATOR_IMAGE);
                jLabel.setHorizontalAlignment(2);
                jLabel.setBounds(i * INDICATOR_WIDTH + insets.left, insets.top, INDICATOR_WIDTH, INDICATOR_HEIGHT);
                this.add(jLabel);
                this.m_oLastImage = jLabel;
            }
        }
        this.m_oLastImage.setBounds((n3 - 1) * INDICATOR_WIDTH + insets.left, insets.top, n % INDICATOR_WIDTH - insets.right - insets.left, INDICATOR_HEIGHT);
    }

    static {
        try {
            INDICATOR_IMAGE = MSCLResLoader.LOADER.getIconExcpt("mwt/activity-indicator.gif");
            INDICATOR_WIDTH = INDICATOR_IMAGE.getIconWidth();
            INDICATOR_HEIGHT = INDICATOR_IMAGE.getIconHeight();
        }
        catch (ResourceLoader.ResourceLoadException resourceLoadException) {
            throw new ExceptionInInitializerError(resourceLoadException);
        }
    }
}

