/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.dockpane.statusbar;

import com.mayastudios.mscl.grafics.CColorEx;
import com.mayastudios.mscl.mwt.dockpane.DockPaneGfxFactory;
import com.mayastudios.mscl.mwt.dockpane.statusbar.CGripperControl;
import com.mayastudios.mscl.mwt.dockpane.statusbar.CStatusBarCell;
import com.mayastudios.mscl.mwt.tablelayout.CCellProps;
import com.mayastudios.mscl.mwt.tablelayout.CTableLayout;
import com.mayastudios.mscl.mwt.widgets.APaintHelperPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.Window;
import javax.swing.JPanel;

public class CStatusBar
extends APaintHelperPanel {
    private static final CColorEx BG_COLOR = DockPaneGfxFactory.BAR_BACKGROUND;
    private static final CColorEx BOTTOM_COLOR = DockPaneGfxFactory.BAR_BACKGROUND_LIGHT.brighter(12);
    private static final int SHADOW_GRADIENT_HEIGHT = 4;
    private static final GradientPaint SHADOW_GRADIENT = new GradientPaint(0.0f, 1.0f, SystemColor.controlDkShadow, 0.0f, 5.0f, BG_COLOR);
    private static final int BAR_GRADIENT_HEIGHT = 12;
    private static final int MIN_STATUSBAR_HEIGHT = 23;
    private static final int TOP_MARGIN = 7;
    private static final int BOTTOM_MARGIN = 2;
    private static final int LEFT_MARGIN = 5;
    private static final int RIGHT_MARGIN = 5;
    private final JPanel mf_oCellPanel = new JPanel();
    private final CTableLayout mf_oLayoutMngr = CTableLayout.initLayout(this.mf_oCellPanel);
    private final CGripperControl mf_oGripper = new CGripperControl();
    private boolean m_bIsResizable = false;
    private GradientPaint m_oStatusBarGradient = CStatusBar._createBarGradient(23);

    public CStatusBar() {
        this.mf_oCellPanel.setOpaque(false);
        this.mf_oLayoutMngr.setMargins(5, 7, 5, 2);
        this.mf_oLayoutMngr.mf_oProps.setAlignment(CCellProps.AX.maximized, CCellProps.AY.center);
        this.mf_oLayoutMngr.addRow.AutoGlueRow();
        this.setLayout(new BorderLayout());
        this.add((Component)this.mf_oCellPanel, "Center");
        this.add((Component)this.mf_oGripper, "After");
        this.disableResizable();
        this.validate();
    }

    public void addField(Component component, boolean bl) {
        this.setField(component, -1, bl);
    }

    public void setField(Component component, int n, boolean bl) {
        int n2 = this.mf_oCellPanel.getComponentCount();
        if (n >= n2) {
            n = -1;
        }
        if (n < 0) {
            CStatusBarCell cStatusBarCell = new CStatusBarCell(component);
            if (n2 != 0) {
                cStatusBarCell.showSeperator(true);
            }
            if (bl) {
                this.mf_oLayoutMngr.addCell.AutoGlueCell(cStatusBarCell);
            } else {
                this.mf_oLayoutMngr.addCell.AutoWidthCell(cStatusBarCell);
            }
        } else {
            ((CStatusBarCell)this.mf_oCellPanel.getComponent(n)).setComponent(component);
        }
        this.validate();
    }

    public void validate() {
        Component[] componentArray = this.mf_oCellPanel.getComponents();
        int n = 14;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].isVisible()) continue;
            n = Math.max(n, componentArray[i].getPreferredSize().height);
        }
        if ((n += 9) != this.getPreferredSize().height) {
            Dimension dimension = new Dimension(Integer.MAX_VALUE, n);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.m_oStatusBarGradient = CStatusBar._createBarGradient(n);
        }
        super.validate();
    }

    public void enableResizable(Window window) {
        this.mf_oGripper.setResizableWindow(window);
        this._setResizable(true);
    }

    public void disableResizable() {
        this.mf_oGripper.setResizableWindow(null);
        this._setResizable(false);
    }

    private void _setResizable(boolean bl) {
        this.mf_oGripper.setVisible(bl);
        this.m_bIsResizable = bl;
        this.repaint();
    }

    public final boolean isResizable() {
        return this.m_bIsResizable;
    }

    protected void paintComponent(Graphics2D graphics2D) {
        Dimension dimension = this.getSize();
        graphics2D.setColor(BG_COLOR);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.setColor(SystemColor.controlHighlight);
        graphics2D.drawLine(0, 0, dimension.width, 0);
        graphics2D.setPaint(SHADOW_GRADIENT);
        graphics2D.fillRect(0, 1, dimension.width, 4);
        graphics2D.setPaint(this.m_oStatusBarGradient);
        graphics2D.fillRect(0, dimension.height - 12, dimension.width, 12);
    }

    private static GradientPaint _createBarGradient(int n) {
        return new GradientPaint(0.0f, n - 12, BG_COLOR, 0.0f, n, BOTTOM_COLOR);
    }
}

