/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.dockpane;

import com.mayastudios.mscl.TStack;
import com.mayastudios.mscl.mwt.dockpane.ADockableTab;
import com.mayastudios.mscl.mwt.dockpane.CDockContentPane;
import com.mayastudios.mscl.mwt.dockpane.CTabView;
import com.mayastudios.mscl.mwt.dockpane.statusbar.CStatusBar;
import com.mayastudios.mscl.mwt.dockpane.toolbar.CToolbar;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.RootPaneContainer;

public class CDockPane {
    private static final int INSETS = 4;
    private final CDockContentPane mf_oContentPane = new CDockContentPane(this, true);
    private final MyOwnFocusTraversalPolicy mf_oFocusPolicy = new MyOwnFocusTraversalPolicy();
    private final CTabView mf_oTabView = new CTabView(true);
    private RootPaneContainer m_oRootPaneContainer = null;
    private Container m_oOriginalContentPane = null;
    private ADockableTab m_oMostRecentTab = null;
    private final CStatusBar m_oStatusBar = new CStatusBar();
    private CToolbar m_oToolbar = null;

    public CDockPane(RootPaneContainer rootPaneContainer, boolean bl) {
        this.m_oRootPaneContainer = rootPaneContainer;
        this.mf_oContentPane.setFocusTraversalPolicy(this.mf_oFocusPolicy);
        this.mf_oContentPane.setFocusCycleRoot(true);
        this.mf_oContentPane.add(this.mf_oTabView);
        this.mf_oContentPane.add(this.m_oStatusBar);
        if (bl) {
            this.enablePane();
        }
    }

    public void showStatusBar(boolean bl, Window window) {
        this.m_oStatusBar.setVisible(bl);
        if (window == null) {
            this.m_oStatusBar.disableResizable();
        } else {
            this.m_oStatusBar.enableResizable(window);
        }
        this.resizePane(this.mf_oContentPane.getWidth(), this.mf_oContentPane.getHeight());
    }

    public final CStatusBar getStatusBar() {
        return this.m_oStatusBar;
    }

    public void enablePane() {
        if (this.m_oOriginalContentPane != null) {
            return;
        }
        this.m_oOriginalContentPane = this.m_oRootPaneContainer.getContentPane();
        this._changeContentPane(this.mf_oContentPane, this.m_oOriginalContentPane);
    }

    public void disablePane() {
        if (this.m_oOriginalContentPane == null) {
            return;
        }
        this._changeContentPane(this.m_oOriginalContentPane, this.mf_oContentPane);
        this.m_oOriginalContentPane = null;
    }

    private void _changeContentPane(Container container, Container container2) {
        container.setBounds(container2.getBounds());
        this.m_oRootPaneContainer.setContentPane(container);
    }

    public void setToolbar(CToolbar cToolbar) {
        if (this.m_oToolbar != null) {
            this.mf_oContentPane.remove(this.m_oToolbar);
        }
        this.m_oToolbar = cToolbar;
        if (this.m_oToolbar != null) {
            this.mf_oContentPane.add(this.m_oToolbar);
        }
        this.resizePane(this.mf_oContentPane.getWidth(), this.mf_oContentPane.getHeight());
    }

    public void addTab(ADockableTab aDockableTab) {
        this.mf_oTabView.addTab(aDockableTab);
    }

    public ADockableTab getFocusedTab() {
        return this.m_oMostRecentTab;
    }

    void setMostRecentTab(ADockableTab aDockableTab) {
        this.m_oMostRecentTab = aDockableTab;
        this.mf_oFocusPolicy.moveToFront(aDockableTab);
    }

    void removeFromRecentList(ADockableTab aDockableTab) {
        this.mf_oFocusPolicy.remove(aDockableTab);
    }

    public void closeAllTabs() {
        this.mf_oTabView.removeAllTabs();
    }

    void resizePane(int n, int n2) {
        int n3;
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (this.m_oStatusBar.isVisible()) {
            n3 = this.m_oStatusBar.getPreferredSize().height;
            rectangle.height -= n3;
            this.m_oStatusBar.setBounds(0, rectangle.y + rectangle.height, n, n3);
            this.m_oStatusBar.validate();
        }
        rectangle.grow(-4, -4);
        if (this.m_oToolbar != null) {
            n3 = this.m_oToolbar.getPreferredSize().height;
            this.m_oToolbar.setBounds(rectangle.x, rectangle.y, rectangle.width, n3);
            this.m_oToolbar.validate();
            rectangle.y += n3 + 4;
            rectangle.height -= n3 + 4;
        }
        this.mf_oTabView.setBounds(rectangle);
    }

    private final class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private TStack<Component> m_oRecentStack = new TStack();

        private MyOwnFocusTraversalPolicy() {
        }

        void moveToFront(ADockableTab aDockableTab) {
            assert (aDockableTab.getContentPanel() != null);
            this.m_oRecentStack.moveToFront(aDockableTab.getContentPanel());
        }

        void remove(ADockableTab aDockableTab) {
            this.m_oRecentStack.remove(aDockableTab.getContentPanel());
        }

        public Component getComponentAfter(Container container, Component component) {
            return this._getNext();
        }

        public Component getComponentBefore(Container container, Component component) {
            return this._getNext();
        }

        public Component getDefaultComponent(Container container) {
            return this._getNext();
        }

        public Component getLastComponent(Container container) {
            return this._getNext();
        }

        public Component getFirstComponent(Container container) {
            return this._getNext();
        }

        private Component _getNext() {
            if (this.m_oRecentStack.getSize() == 0) {
                return null;
            }
            return this.m_oRecentStack.getFirst();
        }
    }
}

