/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl;

import com.mayastudios.mscl.HashCode;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileLock;

public class SingleAppInstance {
    private File m_oLockFile = null;
    private FileOutputStream m_oLockStream = null;
    private FileLock m_oLock = null;
    private static final SingleAppInstance INSTANCE = new SingleAppInstance();

    private SingleAppInstance() {
    }

    protected void finalize() throws Throwable {
        if (this.m_oLockStream != null) {
            this.m_oLock = null;
            this.m_oLockStream.close();
            this.m_oLockStream = null;
            this.m_oLockFile.delete();
        }
        if (this.m_oLockFile != null) {
            this.m_oLockFile = null;
        }
    }

    public static synchronized void initAppLock(String string) throws CSingleInstanceException {
        if (SingleAppInstance.INSTANCE.m_oLockFile != null) {
            return;
        }
        String string2 = System.getProperty("java.io.tmpdir");
        if (string2 == null) {
            throw new CSingleInstanceException("java.io.tmpdir is undefined");
        }
        SingleAppInstance.INSTANCE.m_oLockFile = new File(String.format("%s%s%s.%s.lock", string2, System.getProperty("file.separator"), string, HashCode.createFromString(System.getProperty("user.name"), HashCode.EHashAlgorithm.MD5)));
    }

    public static synchronized boolean checkAppLock() throws CSingleInstanceException, IOException {
        Closeable closeable;
        if (SingleAppInstance.INSTANCE.m_oLock != null) {
            return true;
        }
        if (SingleAppInstance.INSTANCE.m_oLockFile == null) {
            throw new CSingleInstanceException("Not initialized!");
        }
        try {
            closeable = new FileOutputStream(SingleAppInstance.INSTANCE.m_oLockFile);
            FileLock fileLock = ((FileOutputStream)closeable).getChannel().tryLock();
            if (fileLock == null) {
                return false;
            }
            SingleAppInstance.INSTANCE.m_oLockStream = closeable;
            SingleAppInstance.INSTANCE.m_oLock = fileLock;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException("should never happen!");
        }
        try {
            closeable = new OutputStreamWriter(SingleAppInstance.INSTANCE.m_oLockStream);
            ((Writer)closeable).write("lock");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static class CSingleInstanceException
    extends Exception {
        public CSingleInstanceException(String string) {
            super(string);
        }
    }
}

