/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl;

import java.io.PrintStream;
import java.util.Vector;

public class Log {
    public static final int CLASSNAME = 1;
    public static final int CLASSNAME_FULL = 2;
    public static final int UID = 4;
    public static final int TO_STRING = 8;
    public static final int STACKTRACE = 16;
    public static final int STACKTRACE_COMPLETE = 32;
    public static final int CLASSID_STACKTRACE = 21;
    public static final int FULL_CLASSID_STACKTRACE = 29;
    private static final int SHORT_STACKTRACE_DEPTH = 5;
    private static final String INDENTION = "   ";
    private static PrintStream s_oOutStream = System.out;
    private static Vector<Integer> s_oHashList = new Vector();

    public static void print(String string, Object object, int n) {
        String string2 = string;
        if ((n & 1) != 0 || (n & 2) != 0 || (n & 4) != 0 || (n & 8) != 0) {
            boolean bl = false;
            string2 = string2 + "\n   with [";
            if ((n & 1) != 0) {
                string2 = object != null ? string2 + object.getClass().getSimpleName() : string2 + "null";
                bl = true;
            }
            if ((n & 2) != 0) {
                string2 = string2 + Log.addSeperator(bl);
                string2 = object != null ? string2 + object.getClass().getCanonicalName() : string2 + "null";
                bl = true;
            }
            if ((n & 4) != 0) {
                string2 = string2 + Log.addSeperator(bl);
                string2 = string2 + "UID: " + Integer.toString(Log._getObjectID(object));
                bl = true;
            }
            if ((n & 8) != 0 && object != null) {
                string2 = string2 + Log.addSeperator(bl);
                string2 = string2 + "String: " + object.toString();
            }
            string2 = string2 + "]";
        }
        if ((n & 0x10) != 0) {
            string2 = string2 + "\n   stack: " + Log._getStackTrace(3, 5);
        } else if ((n & 0x20) != 0) {
            string2 = string2 + "\n   stack: " + Log._getStackTrace(3, -1);
        }
        Log._print(string2);
    }

    private static final String addSeperator(boolean bl) {
        if (bl) {
            return " | ";
        }
        return "";
    }

    public static void print(String string, Object object) {
        assert (object != null);
        Log._print(String.format("[%s|UID: %d] %s", object.getClass().getSimpleName(), new Integer(Log._getObjectID(object)), string));
    }

    public static void print(String string) {
        Log._print(string);
    }

    private static synchronized int _getObjectID(Object object) {
        if (object == null) {
            return -1;
        }
        Integer n = new Integer(object.hashCode());
        int n2 = s_oHashList.indexOf(n);
        if (n2 == -1) {
            s_oHashList.add(n);
            n2 = s_oHashList.size() - 1;
        }
        return n2 + 1;
    }

    private static String _getStackTrace(int n, int n2) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        if (stackTraceElementArray.length <= n) {
            return "";
        }
        if (n2 == -1) {
            n2 = stackTraceElementArray.length - n;
        }
        String string = stackTraceElementArray[n].toString();
        for (int i = n + 1; i < n + n2; ++i) {
            string = string + "\n          " + stackTraceElementArray[i].toString();
        }
        return string;
    }

    private static synchronized void _print(String string) {
        String string2 = Log._getStackTrace(3, 1);
        s_oOutStream.print(String.format("%s\n%sat %s\n", string, INDENTION, string2));
        s_oOutStream.flush();
    }
}

