/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashCode {
    public static String createFromString(String string, EHashAlgorithm eHashAlgorithm) {
        MessageDigest messageDigest = eHashAlgorithm.getDigest();
        messageDigest.update(string.getBytes());
        return HashCode._convertDigestToHex(messageDigest);
    }

    public static String createFromFile(String string, EHashAlgorithm eHashAlgorithm) throws FileNotFoundException, IOException {
        return HashCode.createFromStream(new FileInputStream(string), eHashAlgorithm);
    }

    public static String createFromFile(File file, EHashAlgorithm eHashAlgorithm) throws FileNotFoundException, IOException {
        return HashCode.createFromStream(new FileInputStream(file), eHashAlgorithm);
    }

    public static String createFromStream(InputStream inputStream, EHashAlgorithm eHashAlgorithm) throws IOException {
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, eHashAlgorithm.getDigest());
        while (digestInputStream.read() != -1) {
        }
        digestInputStream.close();
        return HashCode._convertDigestToHex(digestInputStream.getMessageDigest());
    }

    private static String _convertDigestToHex(MessageDigest messageDigest) {
        byte[] byArray = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer(500);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(String.format("%02x", new Integer(0xFF & byArray[i])));
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EHashAlgorithm {
        MD5("MD5"),
        SHA("SHA-1");

        private final String m_strName;

        private EHashAlgorithm(String string2) {
            this.m_strName = string2;
        }

        public MessageDigest getDigest() {
            try {
                return MessageDigest.getInstance(this.m_strName);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalStateException("Should never happen!");
            }
        }
    }
}

