/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.launcher.impl;

import com.mayastudios.launcher.AppInfo;
import com.mayastudios.launcher.impl.ArgumentList;
import com.mayastudios.launcher.impl.BootstrapInformation;
import com.mayastudios.launcher.impl.LauncherUserException;
import com.mayastudios.launcher.impl.SubProcess;
import java.awt.GraphicsEnvironment;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Launcher {
    public static final String RELATIVE_LAUNCHER_JAR_LOCATION = "lib/";
    public static final String PRINT_CMDLINE_LENGTH_PROPERTY = "bootstrap.printCmdLineLength";
    public static final String NO_LAUNCH_PROPERTY = "bootstrap.noLaunch";
    public static final int RESTART_EXIT_CODE = 255;
    public static final int LAUNCHER_VERSION = PackageVersionInfo._REVISION;
    private static final String PATH_SEPERATOR = System.getProperty("path.separator");
    private final boolean m_printCommandLineLength = Boolean.parseBoolean(System.getProperty("bootstrap.printCmdLineLength", "false"));
    private final boolean m_launchApp = !Boolean.parseBoolean(System.getProperty("bootstrap.noLaunch", "false"));
    private final String[] m_appArgs = AppInfo.getAppArgs();
    private final BootstrapInformation m_bootstrapInformation = new BootstrapInformation();

    public int run() {
        ArgumentList commandLine = this.assembleCommandline();
        if (this.m_launchApp) {
            SubProcess process = SubProcess.exec(commandLine, null, AppInfo.getAppPath());
            return process.getExitCode();
        }
        StringBuilder command = new StringBuilder(256);
        for (String part : commandLine) {
            command.append('\"').append(part.replace("\\", "\\\\").replace("\"", "\\\"")).append("\" ");
        }
        if (this.m_printCommandLineLength) {
            System.out.print(command.length() + 9);
        }
        System.out.print(command.toString());
        return 0;
    }

    private ArgumentList assembleCommandline() {
        ArgumentList commandline = new ArgumentList(new String[0]);
        commandline.add("java");
        for (Map.Entry<Object, Object> prop : this.m_bootstrapInformation.getAppProperties().entrySet()) {
            String key = prop.getKey().toString();
            String value = prop.getValue().toString();
            if (key.contains("=") || value.contains("=")) {
                throw new LauncherUserException("Neither the property keys nor their values must contain an equal sign.");
            }
            if (value.charAt(value.length() - 1) == '\\') {
                value = value + '\\';
            }
            commandline.add("-D" + key + "=" + value);
        }
        commandline.add("-cp");
        StringBuilder classpath = new StringBuilder(256);
        for (String part : this.m_bootstrapInformation.getClassPath()) {
            if (classpath.length() != 0) {
                classpath.append(PATH_SEPERATOR);
            }
            classpath.append(part);
        }
        commandline.add(classpath.toString());
        for (String option : this.m_bootstrapInformation.getNonStadardOptions()) {
            commandline.add(option);
        }
        commandline.add(this.m_bootstrapInformation.getMainClass());
        for (String arg : this.m_appArgs) {
            commandline.add(arg);
        }
        return commandline;
    }

    public static void main(String[] p_args) {
        try {
            Launcher launcher;
            int exitCode;
            AppInfo.init(p_args);
            while ((exitCode = (launcher = new Launcher()).run()) == 255) {
            }
            System.exit(exitCode);
        }
        catch (Exception e) {
            StringWriter errorOutput = new StringWriter();
            PrintWriter writer = new PrintWriter(errorOutput);
            if (e instanceof LauncherUserException) {
                writer.println(e.getMessage());
                if (e.getCause() != null) {
                    e.getCause().printStackTrace(writer);
                }
            } else {
                e.printStackTrace(writer);
            }
            Launcher.printError(errorOutput.toString());
        }
    }

    private static void printError(final String p_content) {
        if (!GraphicsEnvironment.isHeadless()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        Class<?> systemLaFClass = Class.forName(UIManager.getSystemLookAndFeelClassName());
                        UIManager.setLookAndFeel((LookAndFeel)systemLaFClass.newInstance());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.out.print(p_content);
                    JOptionPane.showMessageDialog(null, p_content, "Error", 0);
                    System.exit(1);
                }
            });
        } else {
            System.out.print(p_content);
            System.exit(1);
        }
    }

    private static final class PackageVersionInfo {
        private static final Pattern REVISION_PATTERN = Pattern.compile("\\$LastChangedRevision[:]?[ ]*(\\d+)[ ]*\\$");
        private static final String REVISION_BASE = "$LastChangedRevision: 225 $";
        private static final Pattern BUILD_DATE_PATTERN = Pattern.compile("\\$LastChangedDate[:]?[ ]*(\\d{4})-(\\d{2})-(\\d{2}) (\\d{2}):(\\d{2}):(\\d{2}) ([+-]\\d{4})[ ]*.*\\$");
        private static final String BUILD_DATE_BASE = "$LastChangedDate: 2009-10-23 11:13:16 +0200 $";
        private static final String VERSION_BASE = "0.2";
        public static final int UNKNOWN_REVISION = -1;
        public static final Calendar UNKNOWN_BUILD_DATE = new GregorianCalendar();
        public static final String _VERSION = "0.2";
        public static final int _REVISION;
        public static final Calendar _BUILD_DATE;
        public static final String _BUILD_DATE_STRING;

        private PackageVersionInfo() {
        }

        private static int getRevision() {
            Matcher matcher = REVISION_PATTERN.matcher(REVISION_BASE);
            if (!matcher.matches()) {
                return -1;
            }
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        private static Calendar getBuildDate() {
            Matcher matcher = BUILD_DATE_PATTERN.matcher(BUILD_DATE_BASE);
            if (!matcher.matches()) {
                return UNKNOWN_BUILD_DATE;
            }
            try {
                GregorianCalendar date = new GregorianCalendar(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)));
                date.setTimeZone(TimeZone.getTimeZone("GMT" + matcher.group(7)));
                return date;
            }
            catch (NumberFormatException e) {
                return UNKNOWN_BUILD_DATE;
            }
        }

        static {
            UNKNOWN_BUILD_DATE.setTimeInMillis(0L);
            _REVISION = PackageVersionInfo.getRevision();
            _BUILD_DATE = PackageVersionInfo.getBuildDate();
            DateFormat formatter = DateFormat.getDateTimeInstance(1, 1);
            _BUILD_DATE_STRING = formatter.format(_BUILD_DATE.getTime());
        }
    }
}

