/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.launcher.impl;

import com.mayastudios.launcher.AppInfo;
import com.mayastudios.launcher.IBootstrap;
import com.mayastudios.launcher.impl.EasyJniClassLoader;
import com.mayastudios.launcher.impl.LauncherUserException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapInformation {
    public static final String BOOTSTRAP_PROPERTIES_FILENAME = "launcher.xml";
    public static final String BOOTSTRAP_CLASSPATH_KEY = "bootstrap.classpath";
    public static final String BOOTSTRAP_CLASS_KEY = "bootstrap.class";
    private static final String CLASSLOADER_KEY = "java.system.class.loader";
    private final Properties m_bootstrapProperties;
    private final String m_mainClass;
    private final List<String> m_classPath;
    private final List<String> m_nonStadardOptions;
    private final Properties m_appProperties;

    public BootstrapInformation() {
        IBootstrap bootstrapper;
        File locationFile = new File(AppInfo.getAppPath(), BOOTSTRAP_PROPERTIES_FILENAME);
        if (!locationFile.exists()) {
            throw new LauncherUserException("The bootstrap location file '" + locationFile + "' doesn't exist.");
        }
        if (!locationFile.canRead()) {
            throw new LauncherUserException("The bootstrap location file '" + locationFile + "' is not readable.");
        }
        this.m_bootstrapProperties = new Properties();
        try {
            this.m_bootstrapProperties.loadFromXML(new FileInputStream(locationFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            bootstrapper = this.loadBootstrapClass();
        }
        catch (LauncherUserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("The boot strap class could not be loaded.", e);
        }
        bootstrapper.prepareStart();
        this.m_mainClass = bootstrapper.getMainClass();
        if (this.m_mainClass == null || this.m_mainClass.trim().length() == 0) {
            throw new LauncherUserException("The main class must be specified.");
        }
        this.m_classPath = Collections.unmodifiableList(new ArrayList<String>(bootstrapper.getClassPath()));
        if (this.m_classPath == null || this.m_classPath.size() == 0) {
            throw new LauncherUserException("The class path must not be empty.");
        }
        List<String> options = bootstrapper.getNonStadardOptions();
        this.m_nonStadardOptions = options != null ? Collections.unmodifiableList(new ArrayList<String>(options)) : Collections.emptyList();
        Properties props = new Properties();
        props.setProperty("bootstrap.appPath", AppInfo.getAppPath());
        props.setProperty("bootstrap.workingDir", AppInfo.getWorkingDir());
        props.setProperty(CLASSLOADER_KEY, EasyJniClassLoader.class.getName());
        if ("mac os x".equalsIgnoreCase(System.getProperty("os.name"))) {
            props.setProperty("apple.laf.useScreenMenuBar", "true");
            props.setProperty("apple.awt.antialiasing", "true");
            props.setProperty("apple.awt.textantialiasing", "true");
        }
        this.m_appProperties = (props = bootstrapper.getAdditionalProperties(props)) != null ? props : new Properties();
    }

    private IBootstrap loadBootstrapClass() {
        Class<?> bootstrapClass;
        URLClassLoader classLoader;
        String bootstrapClasspath = this.getProperty(BOOTSTRAP_CLASSPATH_KEY);
        String bootstrapClassName = this.getProperty(BOOTSTRAP_CLASS_KEY);
        Class<IBootstrap> bootstrapInterface = IBootstrap.class;
        if (bootstrapClasspath.trim().length() == 0) {
            throw new LauncherUserException("The bootstrap classpath must not be empty.");
        }
        try {
            String[] parts = bootstrapClasspath.split(":");
            URL[] classPathUrls = new URL[parts.length];
            for (int x = 0; x < parts.length; ++x) {
                classPathUrls[x] = new File(AppInfo.getAppPath(), parts[x]).toURL();
            }
            classLoader = new URLClassLoader(classPathUrls);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        try {
            bootstrapClass = classLoader.loadClass(bootstrapClassName);
        }
        catch (ClassNotFoundException e) {
            throw new LauncherUserException("The specified bootstrap class '" + bootstrapClassName + "' could not be found.");
        }
        if (bootstrapClass.isInterface() || Modifier.isAbstract(bootstrapClass.getModifiers())) {
            throw new LauncherUserException("The bootstrap class must not be an interface nor an abstract class.");
        }
        Class<?>[] implementedInterfaces = bootstrapClass.getInterfaces();
        boolean isImplementingBootstrapInterface = false;
        for (Class<?> implementedInterface : implementedInterfaces) {
            if (implementedInterface != bootstrapInterface) continue;
            isImplementingBootstrapInterface = true;
            break;
        }
        if (!isImplementingBootstrapInterface) {
            throw new LauncherUserException("The bootstrap class must implement the interface '" + bootstrapInterface.getName() + "'.");
        }
        try {
            return (IBootstrap)bootstrapClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new LauncherUserException("The bootstrap class has no empty argument list constructor.");
        }
        catch (InvocationTargetException e) {
            throw new LauncherUserException("The bootstrap class' constructor has thrown an exception.", e.getCause());
        }
        catch (ExceptionInInitializerError e) {
            throw new LauncherUserException("The initialization of bootstrap class has thrown an exception.", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getProperty(String p_key) {
        return this.getProperty(p_key, true);
    }

    private String getProperty(String p_key, boolean p_failWhenNotFound) {
        String value = this.m_bootstrapProperties.getProperty(p_key);
        if (value == null && p_failWhenNotFound) {
            throw new LauncherUserException("The property '" + p_key + "' could not be found in the bootstrap properties");
        }
        return value;
    }

    public String getMainClass() {
        return this.m_mainClass;
    }

    public List<String> getClassPath() {
        return this.m_classPath;
    }

    public List<String> getNonStadardOptions() {
        return this.m_nonStadardOptions;
    }

    public Properties getAppProperties() {
        return this.m_appProperties;
    }
}

