/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp.impl;

import com.mayastudios.ixml.common.WrappedText;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class MultilineLabel
extends JComponent {
    private boolean m_bInitialized = false;
    private String m_strText = null;
    private ETextAlignment m_eAlignment = ETextAlignment.START;
    private WrappedText m_oWrappedText = null;
    private int m_iMaxWidth = Short.MAX_VALUE;
    private JLabel mf_oLabel = new JLabel();

    public MultilineLabel() {
        this(null);
    }

    public MultilineLabel(String p_strText) {
        this(p_strText, Short.MAX_VALUE);
    }

    public MultilineLabel(int p_iMaxWidth) {
        this("", p_iMaxWidth);
    }

    public MultilineLabel(String p_strText, int p_iMaxWidth) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add(this.mf_oLabel);
        this.m_strText = p_strText;
        this.setMaxWidth(p_iMaxWidth);
    }

    public void setText(String p_strText) {
        this.m_strText = p_strText;
        this._updateWrappedText();
    }

    public void setOpaque(boolean p_bIsOpaque) {
        super.setOpaque(p_bIsOpaque);
        this.mf_oLabel.setOpaque(p_bIsOpaque);
    }

    public String getText() {
        return this.m_strText;
    }

    public void setMaxWidth(int p_iMaxWidth) {
        if (p_iMaxWidth < 0) {
            throw new IllegalArgumentException("Invalid maximum width: " + p_iMaxWidth);
        }
        this.m_iMaxWidth = p_iMaxWidth;
        this._updateWrappedText();
    }

    private WrappedText _getWrappedText() {
        if (!this.m_bInitialized) {
            this._updateWrappedText();
        }
        return this.m_oWrappedText;
    }

    private void _updateWrappedText() {
        String strAlign;
        Graphics oDC = this.getGraphics();
        if (oDC == null) {
            return;
        }
        this.m_bInitialized = true;
        if (this.m_strText == null || this.m_strText.trim().length() == 0 || this.m_iMaxWidth == 0) {
            this.m_oWrappedText = null;
            this.mf_oLabel.setText(null);
            return;
        }
        this.m_oWrappedText = new WrappedText(this.m_strText.replace("<br>", "&lt;br&gt;"), this.mf_oLabel.getFont(), oDC, this.m_iMaxWidth, true);
        StringBuilder oLabel = new StringBuilder(this.m_strText.length() + this.m_oWrappedText.getLineCount() * 4 + 100);
        switch (this.m_eAlignment) {
            case CENTER: {
                strAlign = "center";
                break;
            }
            case END: {
                if (this.getComponentOrientation().isLeftToRight()) {
                    strAlign = "right";
                    break;
                }
                strAlign = "left";
                break;
            }
            default: {
                strAlign = this.getComponentOrientation().isLeftToRight() ? "left" : "right";
            }
        }
        oLabel.append("<html><p align=\"").append(strAlign).append("\">");
        for (String strLine : this.m_oWrappedText.getLines()) {
            oLabel.append(strLine).append("<br>");
        }
        this.mf_oLabel.setText(oLabel.toString());
    }

    public void setPreferredSize(Dimension p_oPreferredSize) {
        if (p_oPreferredSize != null) {
            this.setMaxWidth(p_oPreferredSize.width);
        }
        super.setPreferredSize(p_oPreferredSize);
    }

    public Dimension getPreferredSize() {
        WrappedText oText = this._getWrappedText();
        if (this.isPreferredSizeSet() || oText == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.m_oWrappedText.getWidth(), this.m_oWrappedText.getHeight());
    }

    public void setTextAlignment(ETextAlignment p_eAlignment) {
        this.m_eAlignment = p_eAlignment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ETextAlignment {
        START,
        CENTER,
        END;

    }
}

