/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp.flexlayout;

import java.awt.Insets;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlexArranger {
    private FlexArranger() {
    }

    public static void sizeElements(List<? extends IFlexArrangable> p_oElementList, int p_iOverallSize, FlexAdditionalLayoutInfo p_oInfo) {
        if (p_oElementList.size() == 0) {
            return;
        }
        int iPrefSize = 0;
        int iOverallFlex = 0;
        int iOverallSpacing = 0;
        LinkedList<ResizeInfo> oResizeList = new LinkedList<ResizeInfo>();
        for (IFlexArrangable iFlexArrangable : p_oElementList) {
            int iCurPrefSize = iFlexArrangable.getPreferredSize();
            oResizeList.add(new ResizeInfo(iFlexArrangable, iCurPrefSize));
            iPrefSize += iCurPrefSize;
            iOverallFlex += iFlexArrangable.getFlexValue();
            if (oResizeList.size() == p_oElementList.size()) continue;
            iOverallSpacing += iFlexArrangable.getSpacing();
        }
        int iRemainingDifference = p_iOverallSize - iPrefSize - iOverallSpacing;
        int iRemainingElements = iRemainingDifference == 0 ? 0 : (iRemainingDifference < 0 ? p_oElementList.size() : iOverallFlex);
        block1: while (iRemainingDifference > 0 && iRemainingElements > 0) {
            int iDifference = iRemainingDifference / iRemainingElements;
            int iOnePxWiderCount = Math.abs(iRemainingDifference) % iRemainingElements;
            for (ResizeInfo resizeInfo : oResizeList) {
                if (iRemainingDifference == 0) continue block1;
                if (!resizeInfo.m_bTakeIntoAccount) continue;
                if (iRemainingDifference < 0) {
                    if (resizeInfo.m_iMinMaxSize == -1) {
                        resizeInfo.m_iMinMaxSize = resizeInfo.mf_oArrangable.getMinimumSize();
                    }
                    resizeInfo.m_iSize += iDifference;
                    if (resizeInfo.m_iSize < resizeInfo.m_iMinMaxSize) {
                        iRemainingDifference -= resizeInfo.m_iSize - resizeInfo.m_iMinMaxSize;
                        resizeInfo.m_iSize = resizeInfo.m_iMinMaxSize;
                        resizeInfo.m_bTakeIntoAccount = false;
                        --iRemainingElements;
                        continue;
                    }
                    if (iOnePxWiderCount > 0 && resizeInfo.m_iSize > resizeInfo.m_iMinMaxSize) {
                        ++resizeInfo.m_iSize;
                        --iOnePxWiderCount;
                        iRemainingDifference -= iDifference + 1;
                        continue;
                    }
                    iRemainingDifference -= iDifference;
                    resizeInfo.m_bTakeIntoAccount = false;
                    --iRemainingElements;
                    continue;
                }
                if (iRemainingDifference <= 0) continue;
                int iFlexValue = resizeInfo.mf_oArrangable.getFlexValue();
                if (iFlexValue > 0) {
                    if (resizeInfo.m_iMinMaxSize == -1) {
                        resizeInfo.m_iMinMaxSize = resizeInfo.mf_oArrangable.getMaximumSize();
                    }
                    resizeInfo.m_iSize += iDifference * iFlexValue;
                    if (resizeInfo.m_iSize > resizeInfo.m_iMinMaxSize) {
                        iRemainingDifference -= resizeInfo.m_iMinMaxSize - (resizeInfo.m_iSize - iDifference * iFlexValue);
                        resizeInfo.m_iSize = resizeInfo.m_iMinMaxSize;
                        resizeInfo.m_bTakeIntoAccount = false;
                        iRemainingElements -= iFlexValue;
                        continue;
                    }
                    if (iOnePxWiderCount > 0 && resizeInfo.m_iSize < resizeInfo.m_iMinMaxSize) {
                        ++resizeInfo.m_iSize;
                        --iOnePxWiderCount;
                        iRemainingDifference -= iDifference * iFlexValue + 1;
                        continue;
                    }
                    iRemainingDifference -= iDifference * iFlexValue;
                    if (resizeInfo.m_iSize != resizeInfo.m_iMinMaxSize) continue;
                    resizeInfo.m_bTakeIntoAccount = false;
                    iRemainingElements -= iFlexValue;
                    continue;
                }
                resizeInfo.m_bTakeIntoAccount = false;
            }
        }
        int iPos = 0;
        for (ResizeInfo oResizeInfo : oResizeList) {
            oResizeInfo.mf_oArrangable.setBounds(iPos, oResizeInfo.m_iSize, p_oInfo);
            iPos += oResizeInfo.m_iSize + oResizeInfo.mf_oArrangable.getSpacing();
        }
    }

    public static class FlexAdditionalLayoutInfo {
        public final Insets mf_oInsets;
        public final int mf_iOtherDimSize;

        public FlexAdditionalLayoutInfo(Insets p_oInsets, int p_iOtherDimSize) {
            this.mf_oInsets = p_oInsets;
            this.mf_iOtherDimSize = p_iOtherDimSize;
        }
    }

    public static interface IFlexArrangable {
        public int getFlexValue();

        public int getSpacing();

        public int getMinimumSize();

        public int getPreferredSize();

        public int getMaximumSize();

        public void setBounds(int var1, int var2, FlexAdditionalLayoutInfo var3);
    }

    private static class ResizeInfo {
        public boolean m_bTakeIntoAccount = true;
        public final IFlexArrangable mf_oArrangable;
        public int m_iSize;
        public int m_iMinMaxSize = -1;

        public ResizeInfo(IFlexArrangable p_oArrangable, int p_iPrefSize) {
            this.mf_oArrangable = p_oArrangable;
            this.m_iSize = p_iPrefSize;
        }
    }
}

