/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp.base;

import com.mayastudios.ixml.common.BaseFactory;
import com.mayastudios.ixml.common.IXMLError;
import com.mayastudios.ixml.common.IXMLException;
import com.mayastudios.ixml.document.DocumentCompFactory;
import com.mayastudios.ixml.document.comp.AttributeParser;
import com.mayastudios.ixml.document.comp.base.EIXMLAttrib;
import com.mayastudios.ixml.document.comp.base.EIXMLType;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IXMLBaseElement {
    public static Color s_oDebugFrameColor = null;
    private final EIXMLType mf_eType;
    private final String mf_strID;
    private final HashMap<EIXMLAttrib, String> mf_oAttribs = new HashMap();
    private final LinkedList<IXMLBaseElement> mf_oChildElements;
    private final HashMap<String, IXMLBaseElement> mf_oChildElementIDs;

    public IXMLBaseElement(EIXMLType p_eType, String p_strID, boolean p_bCanHaveChildren) {
        this.mf_eType = p_eType;
        this.mf_oChildElements = p_bCanHaveChildren ? new LinkedList() : null;
        this.mf_oChildElementIDs = p_bCanHaveChildren ? new HashMap() : null;
        this.mf_strID = p_strID;
    }

    public EIXMLType getType() {
        return this.mf_eType;
    }

    protected abstract JComponent createComponentImpl(InfoStack var1, CreateInfo var2) throws IXMLError, IXMLException;

    public JComponent createComponent(InfoStack p_oElementStack, CreateInfo p_oCreateInfo) throws IXMLError, IXMLException {
        JComponent oComponent = this.createComponentImpl(p_oElementStack, p_oCreateInfo);
        p_oCreateInfo.notifyHandlers(this.mf_strID, oComponent);
        return oComponent;
    }

    public String getID() {
        return this.mf_strID;
    }

    public void setAttribute(EIXMLAttrib p_oAttribute, String p_strValue) {
        if (p_strValue == null) {
            this.mf_oAttribs.remove((Object)p_oAttribute);
        } else {
            this.mf_oAttribs.put(p_oAttribute, p_strValue);
        }
    }

    public String getAttributeAsString(EIXMLAttrib p_oAttribute) {
        return this.getAttributeAsString(p_oAttribute, true);
    }

    public String getAttributeAsString(EIXMLAttrib p_oAttribute, boolean p_bParseLabel) {
        EIXMLAttrib.EAttribType eType = p_oAttribute.getType();
        switch (eType) {
            case STRING: 
            case LABEL: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The given attribute is not from type 'string' or 'label' but: " + p_oAttribute.getType().toString());
            }
        }
        String strValue = this.mf_oAttribs.get((Object)p_oAttribute);
        if (eType == EIXMLAttrib.EAttribType.LABEL && p_bParseLabel) {
            strValue = AttributeParser.parseLabel(strValue);
        } else if (strValue == null) {
            strValue = "";
        }
        return strValue;
    }

    public Integer getAttributeAsInt(EIXMLAttrib p_eAttribute) throws IXMLError {
        int iValue;
        EIXMLAttrib.EAttribType eType = p_eAttribute.getType();
        if (eType != EIXMLAttrib.EAttribType.INT && eType != EIXMLAttrib.EAttribType.POSITIVE_INT) {
            throw new IllegalArgumentException("The given attribute is not from type 'int' but: " + (Object)((Object)eType));
        }
        String strValue = this.mf_oAttribs.get((Object)p_eAttribute);
        if (strValue == null) {
            return null;
        }
        try {
            iValue = Integer.parseInt(strValue);
        }
        catch (NumberFormatException oException) {
            throw new IXMLError((Throwable)oException, "The value \"%s\" for attribute \"%s@%s\" is not a valid integer number.", new Object[]{strValue, p_eAttribute, this.mf_eType});
        }
        if (eType == EIXMLAttrib.EAttribType.POSITIVE_INT && iValue < 0) {
            throw new IXMLError("The value \"%d\" for attribute \"%s@%s\" is negative but must be positive.", new Object[]{iValue, p_eAttribute, this.mf_eType});
        }
        return iValue;
    }

    public int getAttributeAsInt(EIXMLAttrib p_eAttribute, int p_iDefaultValue) throws IXMLError {
        Integer oValue = this.getAttributeAsInt(p_eAttribute);
        if (oValue == null) {
            return p_iDefaultValue;
        }
        return oValue;
    }

    public boolean getAttributeAsBoolean(EIXMLAttrib p_eAttribute, boolean p_bDefaultValue) throws IXMLError {
        if (p_eAttribute.getType() != EIXMLAttrib.EAttribType.BOOLEAN) {
            throw new IllegalArgumentException("The given attribute is not from type 'boolean' but: " + p_eAttribute.getType().toString());
        }
        String strValue = this.mf_oAttribs.get((Object)p_eAttribute);
        if (strValue == null) {
            return p_bDefaultValue;
        }
        if ("true".equals(strValue.toLowerCase())) {
            return true;
        }
        if ("false".equals(strValue.toLowerCase())) {
            return false;
        }
        throw new IXMLError("Invalid value (%s) for boolean attribute \"%s@%s\".", new Object[]{strValue, p_eAttribute, this});
    }

    public int getAttributeAsOption(EIXMLAttrib p_eAttribute) throws IXMLError {
        if (p_eAttribute.getType() != EIXMLAttrib.EAttribType.OPTION) {
            throw new IllegalArgumentException("The given attribute is not from type 'option' but: " + p_eAttribute.getType().toString());
        }
        String strValue = this.mf_oAttribs.get((Object)p_eAttribute);
        if (strValue == null) {
            return -1;
        }
        try {
            return p_eAttribute.getOptionValueIndex(strValue);
        }
        catch (EIXMLAttrib.OptionValueException oException) {
            throw new IXMLError((Throwable)oException);
        }
    }

    public int getAttributeAsOption(EIXMLAttrib p_eAttribute, int p_iDefaultOption) throws IXMLError {
        int iOption = this.getAttributeAsOption(p_eAttribute);
        if (iOption == -1) {
            return p_iDefaultOption;
        }
        return iOption;
    }

    public URL getAttributeAsURL(EIXMLAttrib p_oAttribute) throws IXMLError {
        if (p_oAttribute.getType() != EIXMLAttrib.EAttribType.URL) {
            throw new IllegalArgumentException("The given attribute is not from type 'url' but: " + p_oAttribute.getType().toString());
        }
        return AttributeParser.parseResourceURL(this.mf_oAttribs.get((Object)p_oAttribute));
    }

    protected boolean allowToAddChildElement(IXMLBaseElement p_oNewChildElement) {
        EIXMLType eAddType = p_oNewChildElement.mf_eType;
        switch (this.mf_eType.getCategory()) {
            case TOPLEVEL: 
            case CHILD: {
                if (!eAddType.isTopLevel() && eAddType.isChildOf(this.mf_eType)) break;
                return false;
            }
            case TOPLEVEL_CONTAINER: 
            case CHILD_CONTAINER: {
                if (eAddType.isTopLevel()) break;
                return false;
            }
        }
        return true;
    }

    public boolean appendChildElement(IXMLBaseElement p_oElement) {
        return this.appendChildElement(p_oElement, null);
    }

    public boolean appendChildElement(IXMLBaseElement p_oElement, IXMLBaseElement p_oAppendBefore) {
        if (this.mf_oChildElements == null || !this.allowToAddChildElement(p_oElement)) {
            return false;
        }
        int iIndex = p_oAppendBefore != null ? this.mf_oChildElements.indexOf(p_oAppendBefore) : -1;
        if (iIndex != -1) {
            this.mf_oChildElements.add(iIndex, p_oElement);
        } else {
            this.mf_oChildElements.add(p_oElement);
        }
        if (p_oElement.mf_strID != null) {
            this.mf_oChildElementIDs.put(p_oElement.mf_strID, p_oElement);
        }
        return true;
    }

    public LinkedList<IXMLBaseElement> getChildElements() {
        return this.mf_oChildElements;
    }

    public IXMLBaseElement getChildElementByID(String p_strID) {
        return this.mf_oChildElementIDs.get(p_strID);
    }

    public String toString() {
        return this.mf_eType.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NodeCompFactory<Type> {
        private final Class<Type> mf_oCompBaseClass;
        private final Method mf_oFactoryMethod;
        private boolean m_bIsClassInitialized = false;
        private Constructor<Type> m_oCustomControlClass = null;

        public NodeCompFactory(Class<Type> p_oCompBaseClass, String p_strFactoryMethodName) {
            this.mf_oCompBaseClass = p_oCompBaseClass;
            Method[] aoMethods = DocumentCompFactory.class.getMethods();
            Method oFactoryMethod = null;
            for (Method oMethod : aoMethods) {
                if (!oMethod.getName().equals(p_strFactoryMethodName)) continue;
                if (oFactoryMethod != null) {
                    throw new IllegalStateException("The factory method \"" + p_strFactoryMethodName + "\" was found twice. This is not allowed.");
                }
                oFactoryMethod = oMethod;
            }
            if (oFactoryMethod == null) {
                throw new IllegalArgumentException("Could not find the factory method \"" + p_strFactoryMethodName + "\".");
            }
            if (!p_oCompBaseClass.isAssignableFrom(oFactoryMethod.getReturnType())) {
                throw new IllegalArgumentException("The factory method \"" + p_strFactoryMethodName + "\" doesn't return an instance of " + p_oCompBaseClass.getSimpleName());
            }
            this.mf_oFactoryMethod = oFactoryMethod;
        }

        public Type create(CreateInfo p_oCreateInfo, Object ... p_aoParameters) throws IXMLError {
            if (!this.m_bIsClassInitialized) {
                this.m_bIsClassInitialized = true;
                String strClass = IXMLBaseElement.this.getAttributeAsString(EIXMLAttrib.CLASS);
                if (strClass.length() > 0) {
                    try {
                        Class<?> oCustClass = Class.forName(strClass);
                        if (!this.mf_oCompBaseClass.isAssignableFrom(oCustClass)) {
                            throw new ClassCastException("The class " + strClass + " is no instance of " + this.mf_oCompBaseClass.getSimpleName());
                        }
                        this.m_oCustomControlClass = oCustClass.getConstructor(this.mf_oFactoryMethod.getParameterTypes());
                    }
                    catch (Exception oException) {
                        throw new IXMLError((Throwable)oException);
                    }
                }
            }
            try {
                if (this.m_oCustomControlClass == null) {
                    return (Type)this.mf_oFactoryMethod.invoke((Object)p_oCreateInfo.mf_oCompFactory, p_aoParameters);
                }
                return this.m_oCustomControlClass.newInstance(p_aoParameters);
            }
            catch (Exception oException) {
                throw new IXMLError((Throwable)oException);
            }
        }
    }

    protected static interface IIDHandler {
        public void handleID(String var1, JComponent var2, BaseFactory var3) throws IXMLError, IXMLException;

        public void finish(String var1, BaseFactory var2) throws IXMLError, IXMLException;
    }

    protected static class CreateInfo {
        public final DocumentCompFactory mf_oCompFactory;
        private final HashMap<String, LinkedList<IIDHandler>> mf_oIDMap = new HashMap(32);

        public CreateInfo(DocumentCompFactory p_oComponentFactory) {
            this.mf_oCompFactory = p_oComponentFactory;
        }

        public void registerIDHandler(String p_strID, IIDHandler p_oHandler) {
            if (p_strID == null || p_strID.length() == 0) {
                throw new IllegalArgumentException("Empty IDs are not allowed.");
            }
            LinkedList<IIDHandler> oHandlerList = this.mf_oIDMap.get(p_strID);
            if (oHandlerList == null) {
                oHandlerList = new LinkedList();
                this.mf_oIDMap.put(p_strID, oHandlerList);
            }
            oHandlerList.add(p_oHandler);
        }

        protected void notifyHandlers(String p_strID, JComponent p_oCreatedComponent) throws IXMLError, IXMLException {
            if (p_strID == null || p_strID.length() == 0) {
                return;
            }
            LinkedList<IIDHandler> oList = this.mf_oIDMap.get(p_strID);
            if (oList == null) {
                return;
            }
            for (IIDHandler oHandler : oList) {
                oHandler.handleID(p_strID, p_oCreatedComponent, this.mf_oCompFactory);
            }
        }

        protected void finish() throws IXMLError, IXMLException {
            Set<Map.Entry<String, LinkedList<IIDHandler>>> oEntries = this.mf_oIDMap.entrySet();
            for (Map.Entry<String, LinkedList<IIDHandler>> oEntry : oEntries) {
                LinkedList<IIDHandler> oList = oEntry.getValue();
                for (IIDHandler oHandler : oList) {
                    oHandler.finish(oEntry.getKey(), this.mf_oCompFactory);
                }
            }
        }
    }

    protected class InfoStack {
        public final IXMLBaseElement mf_oElement;
        public final JComponent mf_oCreatedComponent;
        public final boolean mf_bCreateOpaque;
        private final InfoStack mf_oParentFrame;

        public InfoStack(InfoStack p_oParentFrame, JComponent p_oComponent, Boolean p_oCreateOpaqueComponents) {
            this.mf_oParentFrame = p_oParentFrame;
            this.mf_oElement = IXMLBaseElement.this;
            this.mf_oCreatedComponent = p_oComponent;
            this.mf_bCreateOpaque = p_oCreateOpaqueComponents == null ? (p_oParentFrame != null ? p_oParentFrame.mf_bCreateOpaque : true) : p_oCreateOpaqueComponents;
        }

        public InfoStack getNext() {
            return this.mf_oParentFrame;
        }
    }
}

