/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp;

import com.mayastudios.ixml.common.BaseEventManager;
import com.mayastudios.ixml.common.BaseFactory;
import com.mayastudios.ixml.common.IXMLError;
import com.mayastudios.ixml.common.KeepAliveReference;
import com.mayastudios.ixml.common.LabelCaption;
import com.mayastudios.ixml.document.comp.AttributeParser;
import com.mayastudios.ixml.document.comp.base.EIXMLAttrib;
import com.mayastudios.ixml.document.comp.base.EIXMLType;
import com.mayastudios.ixml.document.comp.base.IXMLBaseElement;
import com.mayastudios.ixml.document.comp.impl.MultilineLabel;
import com.mayastudios.ixml.document.parser.IXMLTagHandler;
import com.mayastudios.ixml.labels.LabelsCore;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.xml.sax.Attributes;

public class IXMLLabelNode
extends IXMLBaseElement {
    private final IXMLBaseElement.NodeCompFactory<JLabel> mf_oSLNodeFactory = new IXMLBaseElement.NodeCompFactory<JLabel>(this, JLabel.class, "createLabel");
    private final IXMLBaseElement.NodeCompFactory<MultilineLabel> mf_oMLNodeFactory = new IXMLBaseElement.NodeCompFactory<MultilineLabel>(this, MultilineLabel.class, "createMultiLineLabel");

    public IXMLLabelNode(String p_strID) {
        super(EIXMLType.LABEL, p_strID, false);
    }

    protected JComponent createComponentImpl(IXMLBaseElement.InfoStack p_oParentComponent, IXMLBaseElement.CreateInfo p_oCreateInfo) throws IXMLError {
        SLLabelChangeListener oChangeListener;
        String strLabel = this.getAttributeAsString(EIXMLAttrib.CAPTION, false);
        int iTextAlign = this.getAttributeAsOption(EIXMLAttrib.TEXTALIGN);
        if (this.getAttributeAsBoolean(EIXMLAttrib.MULTILINE, false)) {
            MultilineLabel oLabel = this.mf_oMLNodeFactory.create(p_oCreateInfo, this.getAttributeAsInt(EIXMLAttrib.MAXWIDTH, Short.MAX_VALUE));
            MLLabelChangeListener oChangeListener2 = new MLLabelChangeListener(strLabel, oLabel);
            oChangeListener2.labelsChanged(false);
            if (iTextAlign == EIXMLAttrib.TEXTALIGN_VALUE_CENTER) {
                oLabel.setTextAlignment(MultilineLabel.ETextAlignment.CENTER);
            } else if (iTextAlign == EIXMLAttrib.TEXTALIGN_VALUE_END) {
                oLabel.setTextAlignment(MultilineLabel.ETextAlignment.END);
            }
            return oLabel;
        }
        JLabel oLabel = this.mf_oSLNodeFactory.create(p_oCreateInfo, new Object[0]);
        String strLabelFor = this.getAttributeAsString(EIXMLAttrib.LABELFOR);
        if (strLabelFor.length() > 0) {
            p_oCreateInfo.registerIDHandler(strLabelFor, new LabelForHandler(oLabel));
            oChangeListener = new SLLabelChangeListener(strLabel, oLabel, true);
        } else {
            oChangeListener = new SLLabelChangeListener(strLabel, oLabel, false);
        }
        oChangeListener.labelsChanged(false);
        if (iTextAlign == EIXMLAttrib.TEXTALIGN_VALUE_CENTER) {
            oLabel.setHorizontalAlignment(0);
        } else if (iTextAlign == EIXMLAttrib.TEXTALIGN_VALUE_END) {
            oLabel.setHorizontalAlignment(11);
        }
        return oLabel;
    }

    public static void registerTags() {
        IXMLTagHandler.registerTag(new IXMLTagHandler("label"){

            public IXMLBaseElement create(Attributes p_oAttributes) {
                return new IXMLLabelNode(p_oAttributes.getValue("id"));
            }
        });
    }

    private class LabelForHandler
    implements IXMLBaseElement.IIDHandler {
        private final JLabel mf_oLabel;
        private boolean m_bHandled = false;

        public LabelForHandler(JLabel p_oLabel) {
            this.mf_oLabel = p_oLabel;
        }

        public void finish(String p_strID, BaseFactory p_oFactory) throws IXMLError {
            if (!this.m_bHandled) {
                p_oFactory.handleWarning("Couldn't find component with ID \"" + p_strID + "\" for label \"" + this.mf_oLabel.getText() + "\".");
            }
        }

        public void handleID(String p_strID, JComponent p_oIDComponent, BaseFactory p_oFactory) {
            this.mf_oLabel.setLabelFor(p_oIDComponent);
            this.m_bHandled = true;
        }
    }

    private static class MLLabelChangeListener
    extends LabelCaption
    implements LabelsCore.ILabelsChangeListener {
        private final KeepAliveReference<MultilineLabel> mf_oLabel;

        public MLLabelChangeListener(String p_strLabel, MultilineLabel p_oLabel) {
            super(p_strLabel);
            this.mf_oLabel = new KeepAliveReference((Object)this, (Object)p_oLabel);
            LabelsCore.addLabelsChangeListener((LabelsCore.ILabelsChangeListener)this, (BaseEventManager.ERefType)BaseEventManager.ERefType.REGULAR);
        }

        public void labelsChanged(boolean p_bLocaleHasChanged) {
            ((MultilineLabel)this.mf_oLabel.getReferrent()).setText(this.toString());
        }
    }

    private static class SLLabelChangeListener
    extends LabelCaption
    implements LabelsCore.ILabelsChangeListener {
        private final JLabel mf_oLabel;
        private final boolean mf_bSetMnemonic;

        public SLLabelChangeListener(String p_strLabel, JLabel p_oLabel, boolean p_bSetMnemonic) {
            super(p_strLabel);
            this.mf_oLabel = p_oLabel;
            this.mf_bSetMnemonic = p_bSetMnemonic;
            LabelsCore.addLabelsChangeListener((LabelsCore.ILabelsChangeListener)this, (BaseEventManager.ERefType)BaseEventManager.ERefType.REGULAR);
        }

        public void labelsChanged(boolean p_bLocaleHasChanged) {
            AttributeParser.MnemonicCaption oMnemonic = new AttributeParser.MnemonicCaption(this.toString());
            JLabel oLabel = this.mf_oLabel;
            oLabel.setText(oMnemonic.mf_strConvertedCaption);
            if (this.mf_bSetMnemonic) {
                oLabel.setDisplayedMnemonic(oMnemonic.mf_iMnemonicKeyCode);
                oLabel.setDisplayedMnemonicIndex(oMnemonic.mf_iMnemonicIndex);
            } else {
                oLabel.setDisplayedMnemonicIndex(-1);
            }
        }
    }
}

