/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs.task;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.CategoryList;
import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.resources.StringFunctions;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.fred.client.view.dialogs.textfields.CNonEmptyTextfield;
import com.mayastudios.mscl.mwt.widgets.button.CFlatButtonBorder;
import com.mayastudios.mscl.mwt.widgets.inputcontols.CTextFieldEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class CDlgTaskProperties
extends ADialogEx {
    private CTaskImpl m_oTask = null;
    private String m_strName = null;
    private String m_strShortName = null;
    private String m_strDescription = null;
    private CNonEmptyTextfield m_oNameTextfield = null;
    private CTextFieldEx m_oShortnameTextfield = null;
    private JTextArea m_oDescriptionTextArea = null;
    private JComboBox m_oProjectComboBox = null;
    private JComboBox m_oDefaultCategoryComboBox = null;

    public CDlgTaskProperties(CTaskImpl cTaskImpl) {
        super((JFrame)MainController.getInstance().getMainWindow(), Labels.get("CDLGTASKPROPERTIES", new Object[0]), Labels.get(!CDlgTaskProperties._canEdit(cTaskImpl) ? "CDLGTASKPROPERTIES_SUBTITLE" : "CDLGTASKPROPERTIES_SUBTITLE_EDIT", new Object[0]), "images/dialog-icon-task.png", true, CDlgTaskProperties._canEdit(cTaskImpl) ? ADialogEx.OK_BUTTON_TEXT.toString() : ADialogEx.CLOSE_BUTTON_TEXT.toString(), CDlgTaskProperties._canEdit(cTaskImpl) ? 3 : 1, new Dimension(485, 285));
        this.m_oTask = cTaskImpl;
        this.getContentPanel().setLayout(null);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        JLabel jLabel = this.addLabel(Labels.get("NAME", new Object[0]), jPanel, true, 20, 20, 100, 20);
        this.m_oNameTextfield = this.addNonEmptyTextfield(jPanel, jLabel, 190, 20, 250, 20);
        this.m_oNameTextfield.setText(this.m_oTask.getName());
        this.m_oNameTextfield.setEditable(CDlgTaskProperties._canEdit(cTaskImpl));
        jLabel = this.addLabel(Labels.get("SHORTNAME", new Object[0]), jPanel, true, 20, 50, 100, 20);
        this.m_oShortnameTextfield = this.addMaxLengthTextfield(jPanel, 190, 50, 100, 20);
        this.m_oShortnameTextfield.setText(this.m_oTask.getShortName());
        this.m_oShortnameTextfield.setMaxTextLength(5);
        this.m_oShortnameTextfield.setEditable(CDlgTaskProperties._canEdit(cTaskImpl));
        jLabel = this.addLabel(Labels.get("DESCRIPTION", new Object[0]), jPanel, true, 20, 80, 100, 20);
        this.m_oDescriptionTextArea = super.addTextarea(jPanel, true, 190, 80, 250, 80);
        this.m_oDescriptionTextArea.setEditable(CDlgTaskProperties._canEdit(cTaskImpl));
        this.m_oDescriptionTextArea.setLineWrap(true);
        this.m_oDescriptionTextArea.setWrapStyleWord(true);
        this.m_oDescriptionTextArea.setText(this.m_oTask.getDescription());
        this.addLabel(Labels.get("PROJECT", new Object[0]), jPanel, true, 20, 170, 100, 20);
        this.m_oProjectComboBox = this.addComboBox(jPanel, ProjectList.getInstance().getProjectComboBoxModel(), 190, 170, 200, 20);
        this.m_oProjectComboBox.setSelectedItem(cTaskImpl.getProject());
        this.m_oProjectComboBox.setEnabled(false);
        this.addLabel(Labels.get("DEFAULTCATEGORY", new Object[0]), jPanel, true, 20, 200, 150, 20);
        this.m_oDefaultCategoryComboBox = this.addComboBox(jPanel, CategoryList.getCategoriesComboBoxModel(), 190, 200, 200, 20);
        this.m_oDefaultCategoryComboBox.setSelectedItem(this.m_oTask.getDefaultCCategory());
        this.m_oDefaultCategoryComboBox.setEnabled(CDlgTaskProperties._canEdit(cTaskImpl));
        this.addLabel(Labels.get("TASK_TYPE", new Object[0]), jPanel, true, 20, 230, 150, 20);
        if (cTaskImpl.isSubscibed()) {
            this.addLabel(Labels.get("TASK_TYPE_TEAM_SUBSCRIBED", new Object[0]), jPanel, false, 190, 230, 290, 20);
        } else if (cTaskImpl.isBroadcasted()) {
            this.addLabel(Labels.get("TASK_TYPE_TEAM_BROADCASTED", new Object[0]), jPanel, false, 190, 230, 290, 20);
        } else if (cTaskImpl.getProject().isBroadcasted()) {
            this.addLabel(Labels.get("TASK_TYPE_NOT_YET_BROADCASTED", new Object[0]), jPanel, false, 190, 230, 290, 20);
        } else {
            this.addLabel(Labels.get("TASK_TYPE_SINGLE", new Object[0]), jPanel, false, 190, 230, 290, 20);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder((Border)new CFlatButtonBorder(CFlatButtonBorder.EState.LOWERED));
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 100);
        TableColumn tableColumn2 = new TableColumn(1, 200);
        tableColumn.setHeaderValue(Labels.get("ATTRIBUTE", new Object[0]));
        tableColumn2.setHeaderValue(Labels.get("VALUE", new Object[0]));
        defaultTableColumnModel.addColumn(tableColumn);
        defaultTableColumnModel.addColumn(tableColumn2);
        CPropertiesTableModel cPropertiesTableModel = new CPropertiesTableModel();
        cPropertiesTableModel.setDataSource(cTaskImpl);
        JTable jTable = new JTable(cPropertiesTableModel, defaultTableColumnModel);
        JTableHeader jTableHeader = jTable.getTableHeader();
        jPanel2.add((Component)jTableHeader, "North");
        jPanel2.add((Component)jTable, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(null);
        jPanel2.setBounds(10, 10, 460, jPanel2.getPreferredSize().height);
        jPanel3.add(jPanel2);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.setOpaque(false);
        jTabbedPane.addTab(Labels.get("COMMON", new Object[0]), jPanel);
        jPanel3.setOpaque(false);
        jTabbedPane.addTab(Labels.get("STATISTICS", new Object[0]), jPanel3);
        jTabbedPane.setBounds(0, 0, 485, 285);
        this.getContentPanel().add(jTabbedPane);
    }

    private static boolean _canEdit(CTaskImpl cTaskImpl) {
        return !cTaskImpl.getProject().isClosed() && !cTaskImpl.isSubscibed() && !cTaskImpl.isBroadcasted();
    }

    @Override
    public boolean onOK() {
        if (this.evaluateValidationList(true, true) != null) {
            return false;
        }
        String string = StringFunctions.isNameValid(this.m_oNameTextfield.getText());
        String string2 = StringFunctions.isTaskShortNameValid(this.m_oShortnameTextfield.getText());
        CProjectImpl cProjectImpl = (CProjectImpl)this.m_oProjectComboBox.getSelectedItem();
        if (string != null) {
            this.setErrorText(string);
            return false;
        }
        if (string2 != null) {
            this.setErrorText(string2);
            return false;
        }
        if (!cProjectImpl.isTaskNameValid(this.m_oTask, this.m_oNameTextfield.getText())) {
            this.setErrorText(Labels.get("MSG_DUPLICATE_TASK_NAME", new Object[0]));
            return false;
        }
        if (!cProjectImpl.isTaskShortNameValid(this.m_oTask, this.m_oShortnameTextfield.getText())) {
            this.setErrorText(Labels.get("MSG_DUPLICATE_TASK_SHORTNAME", new Object[0]));
            return false;
        }
        this.m_strName = this.m_oNameTextfield.getText();
        this.m_oTask.setName(this.m_strName);
        this.m_strShortName = this.m_oShortnameTextfield.getText();
        this.m_oTask.setShortName(this.m_strShortName);
        this.m_strDescription = this.m_oDescriptionTextArea.getText();
        this.m_oTask.setDescription(this.m_strDescription);
        CategoryList.CCategory cCategory = (CategoryList.CCategory)this.m_oDefaultCategoryComboBox.getSelectedItem();
        this.m_oTask.setDefaultCategory(cCategory);
        return true;
    }

    class CPropertiesTableModel
    extends AbstractTableModel {
        private static final int PROP_CREATED_AT = 0;
        private static final int PROP_SUBSCRIBED_AT = 1;
        private static final int PROP_EFFORT_COUNT = 2;
        private static final int PROP_REPLICATEDEFFORT_COUNT = 3;
        private static final int PROP_NOTREPLICATEDEFFORT_COUNT = 4;
        private static final int PROP_ACCEPTED_EFFORT_COUNT = 5;
        private static final int PROP_NOTYETACCEPTED_EFFORT_COUNT = 6;
        private static final int PROP_NOTACCEPTED_EFFORT_COUNT = 7;
        private static final int PROP_ACCUMULATED_DURATION = 8;
        String[][] m_aData = new String[][]{{Labels.get("PROP_CREATED_AT", new Object[0]), null}, {Labels.get("PROP_SUBSCRIBED_AT", new Object[0]), null}, {Labels.get("PROP_EFFORT_COUNT", new Object[0]), null}, {Labels.get("PROP_REPLICATEDEFFORT_COUNT", new Object[0]), null}, {Labels.get("PROP_NOTREPLICATEDEFFORT_COUNT", new Object[0]), null}, {Labels.get("PROP_ACCEPTED_EFFORT_COUNT", new Object[0]), null}, {Labels.get("PROP_NOTYETACCEPTED_EFFORT_COUNT", new Object[0]), null}, {Labels.get("PROP_NOTACCEPTED_EFFORT_COUNT", new Object[0]), null}, {Labels.get("PROP_ACCUMULATED_DURATION", new Object[0]), null}};

        CPropertiesTableModel() {
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.m_aData[n][n2];
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.m_aData.length;
        }

        public void setDataSource(CTaskImpl cTaskImpl) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (cTaskImpl.getCreatedAt() != null) {
                this.m_aData[0][1] = DateTime.getDateTimeString(cTaskImpl.getCreatedAt());
            }
            if (cTaskImpl.getSubscribedAt() != null) {
                this.m_aData[1][1] = DateTime.getDateTimeString(cTaskImpl.getSubscribedAt());
            }
            n = cTaskImpl.getStatistic().getFieldValue(0);
            this.m_aData[2][1] = Integer.toString(n);
            n5 = cTaskImpl.getStatistic().getFieldValue(2);
            this.m_aData[3][1] = Integer.toString(n5);
            n6 = n - n5;
            this.m_aData[4][1] = Integer.toString(n6);
            n2 = cTaskImpl.getStatistic().getFieldValue(3);
            this.m_aData[5][1] = Integer.toString(n2);
            n3 = cTaskImpl.getStatistic().getFieldValue(4);
            this.m_aData[7][1] = Integer.toString(n3);
            n4 = n - n2 - n3;
            this.m_aData[6][1] = Integer.toString(n4);
            this.m_aData[8][1] = DateTime.getDurationString(cTaskImpl.getStatistic().getFieldValue(1), false);
        }
    }
}

