/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs.task;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.CategoryList;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.resources.StringFunctions;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.fred.client.view.dialogs.textfields.CNonEmptyTextfield;
import com.mayastudios.ixml.common.SystemInfo;
import com.mayastudios.mscl.mwt.widgets.inputcontols.CTextFieldEx;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class CDlgTaskCreateTask
extends ADialogEx {
    private static final int LABEL_WIDTH = SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 100 : 130;
    private static final int LABEL_FIELD_GAP = 20;
    private static final int FIELD_WIDTH = SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 250 : 300;
    CTaskImpl m_oCreatedTask = null;
    boolean m_bShortNameChangesHaveOccured = false;
    CNonEmptyTextfield m_oNameTextfield = null;
    CTextFieldEx m_oShortnameTextfield = null;
    JTextArea m_oDescriptionTextArea = null;
    JComboBox m_oProjectComboBox = null;
    JComboBox m_oDefaultCategoryComboBox = null;

    public CDlgTaskCreateTask(CProjectImpl cProjectImpl, CategoryList.CCategory cCategory) {
        super((JFrame)MainController.getInstance().getMainWindow(), Labels.get("CDLGTASKCREATETASK", new Object[0]), Labels.get("CDLGTASKCREATETASK_SUBTITLE", new Object[0]), "images/dialog-icon-task.png", true, Labels.get("BUTTON_CREATE", new Object[0]), 3, new Dimension(LABEL_WIDTH + 20 + FIELD_WIDTH, 200));
        this.getContentPanel().setLayout(null);
        JLabel jLabel = this.addLabel(Labels.get("NAME", new Object[0]), this.getContentPanel(), true, 0, 0, LABEL_WIDTH, 20);
        this.m_oNameTextfield = this.addNonEmptyTextfield(this.getContentPanel(), jLabel, LABEL_WIDTH + 20, 0, FIELD_WIDTH, 20);
        this.m_oNameTextfield.addFocusListener(new CNameFocusListener());
        jLabel = this.addLabel(Labels.get("SHORTNAME", new Object[0]), this.getContentPanel(), true, 0, 30, LABEL_WIDTH, 20);
        this.m_oShortnameTextfield = this.addMaxLengthTextfield(this.getContentPanel(), LABEL_WIDTH + 20, 30, 100, 20);
        this.m_oShortnameTextfield.addFocusListener((FocusListener)new CShortNameFocusListener());
        this.m_oShortnameTextfield.setMaxTextLength(5);
        jLabel = this.addLabel(Labels.get("DESCRIPTION", new Object[0]), this.getContentPanel(), true, 0, 60, LABEL_WIDTH, 20);
        this.m_oDescriptionTextArea = super.addTextarea(this.getContentPanel(), true, LABEL_WIDTH + 20, 60, FIELD_WIDTH, 80);
        this.m_oDescriptionTextArea.setLineWrap(true);
        this.m_oDescriptionTextArea.setWrapStyleWord(true);
        this.addLabel(Labels.get("PROJECT", new Object[0]), this.getContentPanel(), true, 0, 150, LABEL_WIDTH, 20);
        this.m_oProjectComboBox = this.addComboBox(this.getContentPanel(), ProjectList.getInstance().getProjectsForTaskCreation(), LABEL_WIDTH + 20, 150, FIELD_WIDTH, 20);
        if (cProjectImpl != null) {
            this.m_oProjectComboBox.setSelectedItem(cProjectImpl);
        }
        this.addLabel(Labels.get("DEFAULTCATEGORY", new Object[0]), this.getContentPanel(), true, 0, 180, LABEL_WIDTH, 20);
        this.m_oDefaultCategoryComboBox = this.addComboBox(this.getContentPanel(), CategoryList.getCategoriesComboBoxModel(), LABEL_WIDTH + 20, 180, FIELD_WIDTH, 20);
        if (cCategory != null) {
            this.m_oDefaultCategoryComboBox.setSelectedItem(cCategory);
        }
    }

    @Override
    public boolean onOK() {
        if (this.evaluateValidationList(true, true) != null) {
            return false;
        }
        String string = StringFunctions.isNameValid(this.m_oNameTextfield.getText());
        String string2 = StringFunctions.isTaskShortNameValid(this.m_oShortnameTextfield.getText());
        CProjectImpl cProjectImpl = (CProjectImpl)this.m_oProjectComboBox.getSelectedItem();
        if (string != null) {
            this.setErrorText(string);
            return false;
        }
        if (string2 != null) {
            this.setErrorText(string2);
            return false;
        }
        if (!cProjectImpl.isTaskNameValid(null, this.m_oNameTextfield.getText())) {
            this.setErrorText(Labels.get("MSG_DUPLICATE_TASK_NAME", new Object[0]));
            return false;
        }
        if (!cProjectImpl.isTaskShortNameValid(null, this.m_oShortnameTextfield.getText())) {
            this.setErrorText(Labels.get("MSG_DUPLICATE_TASK_SHORTNAME", new Object[0]));
            return false;
        }
        this.m_oCreatedTask = CTaskImpl.create();
        this.m_oCreatedTask.setName(this.m_oNameTextfield.getText());
        this.m_oCreatedTask.setShortName(this.m_oShortnameTextfield.getText());
        this.m_oCreatedTask.setDescription(this.m_oDescriptionTextArea.getText());
        this.m_oCreatedTask.setProject((CProjectImpl)this.m_oProjectComboBox.getSelectedItem());
        this.m_oCreatedTask.setDefaultCategory((CategoryList.CCategory)this.m_oDefaultCategoryComboBox.getSelectedItem());
        return true;
    }

    public CTaskImpl getCreatedTask() {
        return this.m_oCreatedTask;
    }

    public class CShortNameFocusListener
    implements FocusListener {
        private String m_strContentAtBegin = null;
        private String m_strContentAtEnd = null;

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.m_strContentAtBegin = CDlgTaskCreateTask.this.m_oShortnameTextfield.getText();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.m_strContentAtEnd = CDlgTaskCreateTask.this.m_oShortnameTextfield.getText();
            if (!this.m_strContentAtBegin.equals(this.m_strContentAtEnd)) {
                CDlgTaskCreateTask.this.m_bShortNameChangesHaveOccured = true;
            }
        }
    }

    class CNameFocusListener
    implements FocusListener {
        CNameFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            String string = null;
            String string2 = null;
            int n = 0;
            int n2 = 0;
            string = CDlgTaskCreateTask.this.m_oNameTextfield.getText();
            if (string != "") {
                string = string.trim();
                CDlgTaskCreateTask.this.m_oNameTextfield.setText(string);
                if (!CDlgTaskCreateTask.this.m_bShortNameChangesHaveOccured) {
                    n = string.length();
                    n2 = n > 5 ? 5 : n;
                    string2 = string.substring(0, n2);
                    string2 = string2.toUpperCase();
                    CDlgTaskCreateTask.this.m_oShortnameTextfield.setText(string2);
                }
            }
        }
    }
}

