/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs.project;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import de.wb.view.CSelectedList;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class CDlgProjectSubscribeProjectList
extends ADialogEx {
    private CProjectImpl m_oSelectedProject = null;
    private boolean m_bStartSubscribeTasks = false;
    private JCheckBox m_oStartSubTasksCheckBox = null;
    private CSelectedList m_oProjectList = null;

    public CDlgProjectSubscribeProjectList(Vector<CProjectImpl> vector) {
        super((JFrame)MainController.getInstance().getMainWindow(), Labels.get("CDLGPROJECTSUBSCRIBE", new Object[0]), Labels.get("CDLGPROJECTSUBSCRIBE_SUBTITLE", new Object[0]), "images/dialog-icon-project-server.png", true, Labels.get("BUTTON_SUBSCRIBE", new Object[0]), 3, new Dimension(380, 370));
        this.getContentPanel().setLayout(null);
        this.addLabel(Labels.get("AVAILABLE_PROJECTS", new Object[0]) + Labels.get("LABEL_NEWEST_FIRST", new Object[0]), this.getContentPanel(), true, 0, 0, 380, 20);
        CProjectSelectListModel cProjectSelectListModel = new CProjectSelectListModel(vector);
        this.m_oProjectList = this.addSelectedList(cProjectSelectListModel);
        this.m_oProjectList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.m_oProjectList);
        jScrollPane.setBounds(10, 30, 370, 300);
        this.getContentPanel().add(jScrollPane);
        this.m_oStartSubTasksCheckBox = new JCheckBox(Labels.get("CHECKBOX_SELECT_TASKS_AFTERWARDS", new Object[0]));
        this.m_oStartSubTasksCheckBox.setBounds(0, 350, 370, 20);
        this.getContentPanel().add(this.m_oStartSubTasksCheckBox);
    }

    public CProjectImpl getProject() {
        return this.m_oSelectedProject;
    }

    public boolean startSubscribeTasks() {
        return this.m_bStartSubscribeTasks;
    }

    @Override
    public boolean onOK() {
        if (this.evaluateValidationList(true, true) != null) {
            return false;
        }
        this.m_oSelectedProject = (CProjectImpl)this.m_oProjectList.getSelectedValue();
        this.m_bStartSubscribeTasks = this.m_oStartSubTasksCheckBox.isSelected();
        return true;
    }

    private class CProjectSelectListModel
    extends AbstractListModel {
        private Vector<CProjectImpl> m_oProjects = null;

        public CProjectSelectListModel(Vector<CProjectImpl> vector) {
            if (vector == null || vector.size() == 0) {
                return;
            }
            CProjectImpl cProjectImpl = null;
            int n = vector.size();
            this.m_oProjects = new Vector(n);
            for (int i = 0; i < n; ++i) {
                cProjectImpl = vector.elementAt(i);
                if (cProjectImpl.isClosed() || cProjectImpl.isUserProjectLeader() || ProjectList.getInstance().contains(cProjectImpl)) continue;
                this.m_oProjects.add(cProjectImpl);
            }
        }

        @Override
        public Object getElementAt(int n) {
            return this.m_oProjects.elementAt(this.m_oProjects.size() - n - 1);
        }

        @Override
        public int getSize() {
            if (this.m_oProjects == null) {
                return 0;
            }
            return this.m_oProjects.size();
        }
    }
}

