/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs.help;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.fred.client.resources.FredInfo;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.dialogs.ADialog;
import com.mayastudios.ixml.common.SystemInfo;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.mwt.GUIHelper;
import com.mayastudios.mscl.mwt.tablelayout.CCellProps;
import com.mayastudios.mscl.mwt.tablelayout.CTableLayout;
import com.mayastudios.mscl.mwt.widgets.APaintHelperPanel;
import com.mayastudios.mscl.mwt.widgets.CLinkText;
import com.mayastudios.mscl.mwt.windowcloser.CWindowCloser;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class CDlgHelpShowAbout
extends JDialog {
    private static final int DIALOG_PADDING = 8;
    private static final int TEXT_HEIGHT = SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 280 : 295;
    String[] m_aInfo = null;

    public CDlgHelpShowAbout() {
        super((Frame)MainController.getInstance().getMainWindow(), true);
        CTableLayout cTableLayout = CTableLayout.initLayout((Container)this.getContentPane());
        CCellProps cCellProps = new CCellProps();
        cTableLayout.addRow.AutoHeightRow();
        cTableLayout.addCell.AutoWidthCell((Component)((Object)new CLogoComponent()));
        cTableLayout.addRow.FixedHeightRow(TEXT_HEIGHT);
        cTableLayout.addCell.AutoGlueCell((Component)new CInfoPanel());
        cTableLayout.addRow.AutoHeightRow();
        cTableLayout.addCell.AutoGlueCell((Component)new JSeparator(0));
        cTableLayout.addRow.AutoGlueRow();
        cCellProps.setAlignment(CCellProps.AX.right, CCellProps.AY.bottom);
        cCellProps.setMargin(8, 8, 8, 8);
        JButton jButton = new JButton(Labels.get("Text.OK", new Object[0]));
        jButton.setPreferredSize(new Dimension(70, jButton.getPreferredSize().height));
        jButton.addActionListener(new COkButtonListener());
        cTableLayout.addCell.AutoGlueCell((Component)jButton, cCellProps);
        this.getContentPane().addMouseListener(new CTestingListener());
        GUIHelper.initWindow((Window)this, (String)Labels.get("Dlg.Help.About.Title", new Object[0]), (int)CLogoComponent.LOGO_IMAGE.getIconWidth(), (int)(CLogoComponent.LOGO_IMAGE.getIconHeight() + TEXT_HEIGHT + 70), (boolean)true, (boolean)false);
    }

    private class COkButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CWindowCloser.closeWindow((Window)CDlgHelpShowAbout.this);
        }
    }

    private static class CInfoPanel
    extends JPanel {
        public CInfoPanel() {
            this.setBackground(Color.WHITE);
            CTableLayout cTableLayout = CTableLayout.initLayout((Container)this, (int)14, (int)8, (int)8, (int)8);
            CCellProps cCellProps = new CCellProps(CCellProps.AX.maximized, CCellProps.AY.maximized);
            cTableLayout.addRow.AutoHeightRow();
            StringBuilder stringBuilder = new StringBuilder(255);
            for (String string : FredInfo.COPYRIGHTS) {
                stringBuilder.append(string).append("<br>");
            }
            cTableLayout.addCell.AutoGlueCell((Component)new JLabel(String.format("<html>%s<br>%s %s<br><br>%s", stringBuilder, Labels.get("Dlg.Help.About.SpecialThanks", new Object[0]), "Wolfgang Bischoff (long gone team member), Julien Boucachard (French translation)", Labels.get("Dlg.Help.About.License", new Object[0]))));
            CLinkText cLinkText = new CLinkText("http://fred.mayastudios.com");
            cLinkText.setListener((CLinkText.IClickListener)new CLinkListener());
            cTableLayout.addRow.AutoHeightRow();
            cCellProps.setAlignment(CCellProps.AX.left, CCellProps.AY.center);
            cCellProps.setMargin(0, 10, 0, 10);
            cTableLayout.addCell.AutoGlueCell((Component)cLinkText, cCellProps);
            String string = "<html><b>" + Labels.get("Dlg.Help.About.UsedLibraries", new Object[0]) + ":</b><br>";
            string = string + this._createExternalPackageString(FredInfo.TRAY_ICON_INFO);
            string = string + this._createExternalPackageString(FredInfo.BROWSER_LAUNCHER_INFO);
            string = string + this._createExternalPackageString(FredInfo.MSCL4J_INFO);
            string = string + this._createExternalPackageString(FredInfo.IXML_INFO);
            string = string + "<br><b>" + Labels.get("Dlg.Help.About.UsedIconsets", new Object[0]) + ":</b><br>";
            string = string + this._createIconPackageString("Tango Icon Theme", "0.8.0", "http://tango.freedesktop.org");
            string = string + this._createIconPackageString("FamFamFam Silk Icons", "1.3", "http://www.famfamfam.com");
            cTableLayout.addRow.AutoHeightRow();
            cTableLayout.addCell.AutoGlueCell((Component)new JLabel(string));
        }

        private String _createExternalPackageString(FredInfo.CExternalPackageInfo cExternalPackageInfo) {
            return String.format("\u2022 %s (%s)<br>", cExternalPackageInfo.getName(), cExternalPackageInfo.getVersion());
        }

        private String _createIconPackageString(String string, String string2, String string3) {
            return String.format("\u2022 %s %s (<font color=blue><u>%s</u></font>)<br>", string, string2, string3);
        }

        private static class CLinkListener
        implements CLinkText.IClickListener {
            public void clickPerformed(CLinkText cLinkText) {
                try {
                    BrowserLauncher browserLauncher = new BrowserLauncher(null);
                    browserLauncher.openURLinBrowser("http://fred.mayastudios.com");
                }
                catch (Exception exception) {
                    ADialog.LOGGER.error("Error when launching browser", (Throwable)exception);
                }
            }
        }
    }

    private static class CLogoComponent
    extends APaintHelperPanel {
        public static final ImageIcon LOGO_IMAGE;
        public static final int LEFT_MARGIN = 14;
        private static final Color VERSION_COLOR;

        public CLogoComponent() {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(LOGO_IMAGE.getIconWidth(), LOGO_IMAGE.getIconHeight()));
            JLabel jLabel = new JLabel(String.format("<html><b>%s: %s</b> (%s)&nbsp;&nbsp;&nbsp;%s: %s</html>", Labels.get("Text.Version", new Object[0]), FredInfo.VERSION_NUMBER, FredInfo.BUILD_DATE != null ? DateTime.getDateTimeString(FredInfo.BUILD_DATE) : "", Labels.get("Text.Revision", new Object[0]), FredInfo.REVISION_NUMBER));
            jLabel.setForeground(VERSION_COLOR);
            jLabel.setHorizontalAlignment(2);
            jLabel.setVerticalAlignment(1);
            jLabel.setBounds(14, 235, 300, 20);
            this.add(jLabel);
        }

        protected void paintComponent(Graphics2D graphics2D) {
            graphics2D.drawImage(LOGO_IMAGE.getImage(), 0, 0, (ImageObserver)((Object)this));
        }

        static {
            VERSION_COLOR = new Color(104, 104, 124);
            try {
                LOGO_IMAGE = MainController.getResLoader().getIconExcpt("images/aboutlogo.jpg");
            }
            catch (ResourceLoader.ResourceLoadException resourceLoadException) {
                throw new ExceptionInInitializerError(resourceLoadException);
            }
        }
    }

    private static class CTestingListener
    extends MouseAdapter {
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (mouseEvent.isControlDown()) {
                    MainController.incomingDebugFunction();
                } else if (mouseEvent.isAltDown()) {
                    MainController.incomingInofficialFunction();
                }
            }
        }
    }
}

