/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs.effort;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.model.CEffortImpl;
import com.mayastudios.fred.client.model.CPersonImpl;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.CategoryList;
import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.CCalendarChooser;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.fred.client.view.dialogs.FredMessageBox;
import com.mayastudios.fred.client.view.dialogs.textfields.CDateTextfield;
import com.mayastudios.fred.client.view.dialogs.textfields.CTimeDurationTextfield;
import com.mayastudios.fred.client.view.dialogs.textfields.CTimeTextfield;
import com.mayastudios.ixml.common.BaseEventManager;
import com.mayastudios.ixml.common.SystemInfo;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.mwt.MessageBox;
import com.mayastudios.mscl.mwt.widgets.button.CButtonEvent;
import com.mayastudios.mscl.mwt.widgets.button.CFlatButton;
import com.mayastudios.mscl.mwt.widgets.button.IButtonListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CDlgEffortEditEffort
extends ADialogEx {
    static final ImageIcon LOCK_OPEN_ICON;
    static final ImageIcon LOCK_CLOSED_ICON;
    private static final int DIALOG_HEIGHT = 490;
    private static final int DIALOG_WIDTH;
    private static final int DIALOG_HALF_WIDTH;
    private static final int X_OFFSET_CALENDAR = -55;
    private static final int Y_OFFSET_CALENDAR = -60;
    private static final KeyStroke OK_CTRL_ENTER_STROKE;
    private static final String OK_CTRL_BUTTON_ACTION_NAME = "OK_BUTTON_CTRL_ENTER_PRESSED";
    private final CFocusListener mf_oFocusListener = new CFocusListener();
    private boolean m_bIsValidEffort = false;
    private final DefaultComboBoxModel m_oEmptyModel = new DefaultComboBoxModel();
    private JComboBox m_oProjectComboBox;
    private JComboBox m_oTaskComboBox;
    private JComboBox m_oCategoryComboBox;
    private JComboBox m_oAcceptedComboBox;
    private ComboBoxModel m_oProjectComboBoxModel;
    private ComboBoxModel m_oTaskComboBoxModel;
    private ComboBoxModel m_oCategoryComboBoxModel;
    private CTimeTextfield m_oStartTimeTextfield;
    private CDateTextfield m_oStartDateTextfield;
    private JButton m_oStartTimeCalendarButton;
    private CTimeTextfield m_oEndTimeTextfield;
    private CDateTextfield m_oEndDateTextfield;
    private JButton m_oEndTimeCalendarButton;
    private CLockButton m_oWorkLockButton;
    private CTimeDurationTextfield m_oWorkDurationTextfield;
    private CLockButton m_oPauseLockButton;
    private CTimeDurationTextfield m_oPauseDurationTextfield;
    private JTextArea m_oCommentTextArea;
    private JCheckBox m_oApprovedCheckBox;
    private JCheckBox m_oErrorIgnoredCheckBox;
    private JCheckBox m_oHasErrorCheckBox;
    private JCheckBox m_oReplicatedCheckBox;
    private boolean m_bAutoComputeTimesLock = false;
    private long m_lInitialEndDate = -1L;
    private long m_lInitialEndTime = -1L;
    private CProjectImpl m_oCurrentlySelectedProject = null;
    private CTaskImpl m_oCurrentlySelectedTask = null;
    private CEffortImpl m_oEffortToEdit = null;
    private int m_iCurrentlySelectedCategory = -1;
    private final boolean m_bAllowEditing;

    public CDlgEffortEditEffort(CEffortImpl cEffortImpl, boolean bl, boolean bl2) {
        super((JFrame)MainController.getInstance().getMainWindow(), Labels.get(bl2 ? "CDLGEFFORTEDITEFFORTTITLE_NEW" : "CDLGEFFORTEDITEFFORTTITLE_EDIT", new Object[0]), Labels.get(bl2 ? "CDLGEFFORTEDITEFFORTTITLE_SUBTITLE_NEW" : "CDLGEFFORTEDITEFFORTTITLE_SUBTITLE_EDIT", new Object[0]), "images/dialog-icon-edit-effort.png", true, ADialogEx.OK_BUTTON_TEXT.toString(), !bl ? 3 : 7, new Dimension(DIALOG_WIDTH, 490));
        this.m_oEffortToEdit = cEffortImpl;
        this.m_bAllowEditing = !this.m_oEffortToEdit.getProject().isClosed();
        this.getContentPanel().setLayout(null);
        if (!this._insertProjectComboBox()) {
            return;
        }
        if (!this._insertTaskComboBox()) {
            return;
        }
        this._insertCategoryComboBox();
        this._insertStartDateTime();
        this._insertEndDateTime();
        this._insertDurationArea();
        this._insertStateArea();
        this._insertCommentArea();
        this.m_bIsValidEffort = this._validateEffort();
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(OK_CTRL_ENTER_STROKE, OK_CTRL_BUTTON_ACTION_NAME);
        this.getRootPane().getActionMap().put(OK_CTRL_BUTTON_ACTION_NAME, new COkHandler());
        this.getOkButton().setToolTipText(Labels.get("CDLGEFFORTEDITEFFORTTITLE_OK_TOOLTIP", new Object[0]));
    }

    @Override
    protected Component getDefaultComponent() {
        return this.m_oProjectComboBox;
    }

    private boolean _insertProjectComboBox() {
        this.addLabel(Labels.get("PROJECT", new Object[0]), this.getContentPanel(), true, 0, 0, 90, 20);
        this.m_oProjectComboBoxModel = ProjectList.getInstance().getProjectComboBoxModel();
        if (this.m_oProjectComboBoxModel.getSize() == 0) {
            this.incomingAbort();
            return false;
        }
        this.m_oCurrentlySelectedProject = this.m_oEffortToEdit.getProject();
        this.m_oProjectComboBox = this.addComboBox(this.getContentPanel(), this.m_oProjectComboBoxModel, 100, 0, DIALOG_WIDTH - 100, 20);
        this.m_oProjectComboBox.setEnabled(this.m_bAllowEditing);
        this.m_oProjectComboBox.setSelectedItem(this.m_oCurrentlySelectedProject);
        this.m_oProjectComboBox.addItemListener(new CProjectItemListener());
        this.m_oProjectComboBox.addFocusListener(this.mf_oFocusListener);
        return true;
    }

    private boolean _insertTaskComboBox() {
        this.addLabel(Labels.get("TASK", new Object[0]), this.getContentPanel(), true, 0, 25, 90, 20);
        this.m_oCurrentlySelectedProject = (CProjectImpl)this.m_oProjectComboBoxModel.getSelectedItem();
        this.m_oTaskComboBoxModel = this.m_oCurrentlySelectedProject.getTaskComboBoxModel();
        this.m_oTaskComboBox = this.addComboBox(this.getContentPanel(), this.m_oTaskComboBoxModel, 100, 25, DIALOG_WIDTH - 100, 20);
        this.m_oCurrentlySelectedTask = this.m_oEffortToEdit.getTask();
        this.m_oTaskComboBox.setEnabled(this.m_bAllowEditing);
        this.m_oTaskComboBox.setSelectedItem(this.m_oCurrentlySelectedTask);
        this.m_oTaskComboBox.addItemListener(new CTaskItemListener());
        this.m_oTaskComboBox.addFocusListener(this.mf_oFocusListener);
        return true;
    }

    private void _insertCategoryComboBox() {
        this.addLabel(Labels.get("CATEGORY", new Object[0]), this.getContentPanel(), true, 0, 50, 90, 20);
        this.m_oCategoryComboBoxModel = new DefaultComboBoxModel<CategoryList.CCategory>(CategoryList.getCategories());
        this.m_oCategoryComboBox = this.addComboBox(this.getContentPanel(), this.m_oCategoryComboBoxModel, 100, 50, DIALOG_WIDTH - 100, 20);
        this.m_oCategoryComboBox.setEnabled(this.m_bAllowEditing);
        this.m_iCurrentlySelectedCategory = this.m_oEffortToEdit.getCategory();
        CategoryList.CCategory cCategory = CategoryList.getCategoryByID(this.m_iCurrentlySelectedCategory);
        if (cCategory == null) {
            this.m_oCategoryComboBox.setSelectedItem(CategoryList.getCategory(0));
        } else {
            this.m_oCategoryComboBox.setSelectedItem(cCategory);
        }
        this.m_oCategoryComboBox.addFocusListener(this.mf_oFocusListener);
    }

    private void _insertStartDateTime() {
        JPanel jPanel = this.addBorderedPanel(Labels.get("STARTPOINTINTIME", new Object[0]), this.getContentPanel(), 0, 75, DIALOG_HALF_WIDTH, 80);
        jPanel.setLayout(null);
        JLabel jLabel = this.addLabel(Labels.get("DATE", new Object[0]), jPanel, true, 10, 20, 55, 20);
        this.m_oStartDateTextfield = this.addDateTextfield(jPanel, jLabel, 65, 20, 75);
        this.m_oStartDateTextfield.setEnabled(this.m_bAllowEditing);
        this.m_oStartDateTextfield.addFocusListener(this.mf_oFocusListener);
        this._addDatePattern(jPanel, 150, 20, SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 55 : 60, 20);
        this.m_oStartTimeCalendarButton = this.addButtonWithIcon("images/calendar.png", "Cal", null, jPanel, SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 210 : 225, 18, 28);
        this.m_oStartTimeCalendarButton.setEnabled(this.m_bAllowEditing);
        this.m_oStartTimeCalendarButton.setFocusable(false);
        this.m_oStartTimeCalendarButton.addActionListener(new CCalendarActionListener());
        JLabel jLabel2 = this.addLabel(Labels.get("TIME", new Object[0]), jPanel, true, 10, 50, 55, 20);
        this.m_oStartTimeTextfield = this.addTimeTextfield(jPanel, jLabel2, 65, 50, 75);
        this.m_oStartTimeTextfield.setEnabled(this.m_bAllowEditing);
        this.m_oStartTimeTextfield.addFocusListener(this.mf_oFocusListener);
        this._addTimePattern(jPanel, 150, 50, SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 55 : 60, 20);
        Calendar calendar = this.m_oEffortToEdit.getBegin();
        this.m_oStartDateTextfield.setFromCalendar(calendar);
        this.m_oStartTimeTextfield.setFromCalendar(calendar);
        this.m_oStartDateTextfield.getModel().addChangeListener(new CChangeListener((Component)((Object)this.m_oStartDateTextfield)));
        this.m_oStartTimeTextfield.getModel().addChangeListener(new CChangeListener((Component)((Object)this.m_oStartTimeTextfield)));
    }

    private void _insertEndDateTime() {
        JPanel jPanel = this.addBorderedPanel(Labels.get("ENDPOINTINTIME", new Object[0]), this.getContentPanel(), DIALOG_HALF_WIDTH + 10, 75, DIALOG_HALF_WIDTH, 80);
        jPanel.setLayout(null);
        JLabel jLabel = this.addLabel(Labels.get("DATE", new Object[0]), jPanel, true, 10, 20, 55, 20);
        this.m_oEndDateTextfield = this.addDateTextfield(jPanel, jLabel, 65, 20, 75);
        this.m_oEndDateTextfield.setEnabled(this.m_bAllowEditing);
        this.m_oEndDateTextfield.addFocusListener(this.mf_oFocusListener);
        this._addDatePattern(jPanel, 150, 20, SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 55 : 60, 20);
        this.m_oEndTimeCalendarButton = this.addButtonWithIcon("images/calendar.png", "Cal", null, jPanel, SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 210 : 225, 18, 28);
        this.m_oEndTimeCalendarButton.setEnabled(this.m_bAllowEditing);
        this.m_oEndTimeCalendarButton.setFocusable(false);
        this.m_oEndTimeCalendarButton.addActionListener(new CCalendarActionListener());
        JLabel jLabel2 = this.addLabel(Labels.get("TIME", new Object[0]), jPanel, true, 10, 50, 55, 20);
        this.m_oEndTimeTextfield = this.addTimeTextfield(jPanel, jLabel2, 65, 50, 75);
        this.m_oEndTimeTextfield.setEnabled(this.m_bAllowEditing);
        this.m_oEndTimeTextfield.addFocusListener(this.mf_oFocusListener);
        this._addTimePattern(jPanel, 150, 50, 55, 20);
        Calendar calendar = this.m_oEffortToEdit.getEnd();
        this.m_oEndDateTextfield.setFromCalendar(calendar);
        this.m_oEndTimeTextfield.setFromCalendar(calendar);
        this.m_lInitialEndDate = this.m_oEndDateTextfield.getAsMilliseconds();
        if (this.m_lInitialEndDate != this.m_oStartDateTextfield.getAsMilliseconds()) {
            this.m_lInitialEndDate = -1L;
        }
        this.m_lInitialEndTime = this.m_oEndTimeTextfield.getAsMilliseconds(true);
        if (this.m_lInitialEndDate == -1L || this.m_lInitialEndTime != this.m_oStartTimeTextfield.getAsMilliseconds(true)) {
            this.m_lInitialEndTime = -1L;
        }
        this.m_oEndDateTextfield.getModel().addChangeListener(new CChangeListener((Component)((Object)this.m_oEndDateTextfield)));
        this.m_oEndTimeTextfield.getModel().addChangeListener(new CChangeListener((Component)((Object)this.m_oEndTimeTextfield)));
    }

    private void _insertDurationArea() {
        JPanel jPanel = this.addBorderedPanel("", this.getContentPanel(), 0, 165, DIALOG_WIDTH, 50);
        this.m_oWorkDurationTextfield = this.addTimeDurationTextfield(jPanel, SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 90 : 100, 15, 75);
        this.m_oWorkDurationTextfield.setEnabled(this.m_bAllowEditing);
        this.m_oWorkDurationTextfield.addFocusListener(this.mf_oFocusListener);
        this._addDurationPattern(jPanel, SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 175 : 180, 15, SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 35 : 43, 20);
        this.m_oWorkDurationTextfield.setSecondsCount(this.m_oEffortToEdit.getDuration() * 60);
        this.m_oWorkLockButton = new CLockButton(true);
        this.m_oWorkLockButton.setBounds(SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 220 : 240, 13, 22, 22);
        this.m_oWorkLockButton.setEnabled(this.m_bAllowEditing);
        jPanel.add((Component)((Object)this.m_oWorkLockButton));
        this.m_oWorkDurationTextfield.getModel().addChangeListener(new CChangeListener((Component)((Object)this.m_oWorkDurationTextfield)));
        this.m_oPauseDurationTextfield = this.addTimeDurationTextfield(jPanel, DIALOG_HALF_WIDTH + (SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 100 : 110), 15, 75);
        this.m_oPauseDurationTextfield.setEnabled(false);
        this.m_oPauseDurationTextfield.addFocusListener(this.mf_oFocusListener);
        this._addDurationPattern(jPanel, DIALOG_HALF_WIDTH + (SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 185 : 190), 15, SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 35 : 43, 20);
        this.m_oPauseLockButton = new CLockButton(false);
        this.m_oPauseLockButton.setBounds(DIALOG_HALF_WIDTH + (SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 230 : 250), 13, 22, 22);
        this.m_oPauseLockButton.setEnabled(this.m_bAllowEditing);
        jPanel.add((Component)((Object)this.m_oPauseLockButton));
        this.m_oPauseDurationTextfield.setSecondsCount(this.m_oEffortToEdit.getPauseDuration() * 60);
        this.m_oPauseDurationTextfield.getModel().addChangeListener(new CChangeListener((Component)((Object)this.m_oPauseDurationTextfield)));
    }

    private void _insertStateArea() {
        JPanel jPanel = this.addBorderedPanel("", this.getContentPanel(), 0, 225, DIALOG_WIDTH, 100);
        jPanel.setLayout(null);
        CPersonImpl cPersonImpl = this.m_oEffortToEdit.getPerson();
        this.addLabel(String.format("%s (%s)", cPersonImpl.getFullName(), cPersonImpl.getInitials()), jPanel, false, 10, 15, DIALOG_HALF_WIDTH - 5, 20);
        this.m_oAcceptedComboBox = this.addComboBox(jPanel, CEffortImpl.getEAcceptedComboBoxModel(), DIALOG_HALF_WIDTH + 10, 15, DIALOG_HALF_WIDTH - 10, 20);
        this.m_oAcceptedComboBox.setEnabled(this.m_bAllowEditing);
        JLabel jLabel = this.addLabel(Labels.get("APPROVED", new Object[0]), jPanel, true, 35, 40, DIALOG_HALF_WIDTH - 45, 20);
        this.m_oApprovedCheckBox = this.addCheckBox(null, jPanel, jLabel, 10, 43);
        this.m_oApprovedCheckBox.setEnabled(false);
        JLabel jLabel2 = this.addLabel(Labels.get("DONT_HIGHLIGHT_COLLISION", new Object[0]), jPanel, true, DIALOG_HALF_WIDTH + 35, 40, DIALOG_HALF_WIDTH - 45, 20);
        this.m_oErrorIgnoredCheckBox = this.addCheckBox(null, jPanel, jLabel2, DIALOG_HALF_WIDTH + 10, 43);
        this.m_oErrorIgnoredCheckBox.setEnabled(true);
        JLabel jLabel3 = this.addLabel(Labels.get("COLLISION", new Object[0]), jPanel, true, 35, 65, DIALOG_HALF_WIDTH - 45, 20);
        this.m_oHasErrorCheckBox = this.addCheckBox(null, jPanel, jLabel3, 10, 68);
        this.m_oHasErrorCheckBox.setEnabled(false);
        JLabel jLabel4 = this.addLabel(Labels.get("REPLICATED", new Object[0]), jPanel, true, DIALOG_HALF_WIDTH + 35, 65, DIALOG_HALF_WIDTH - 45, 20);
        this.m_oReplicatedCheckBox = this.addCheckBox(null, jPanel, jLabel4, DIALOG_HALF_WIDTH + 10, 68);
        this.m_oReplicatedCheckBox.setEnabled(false);
        this.m_oApprovedCheckBox.setSelected(this.m_oEffortToEdit.isApproved());
        this.m_oErrorIgnoredCheckBox.setSelected(this.m_oEffortToEdit.ignoresMistake());
        this.m_oHasErrorCheckBox.setSelected(this.m_oEffortToEdit.isColliding());
        this.m_oReplicatedCheckBox.setSelected(this.m_oEffortToEdit.isReplicated());
        this.m_oReplicatedCheckBox.setEnabled(false);
        this.m_oAcceptedComboBox.setSelectedItem(this.m_oEffortToEdit.getAccepted().getDescription());
    }

    private void _insertCommentArea() {
        this.addLabel(Labels.get("Dlg.Label.Description", new Object[0]), this.getContentPanel(), true, 0, 335, 90, 20);
        this.m_oCommentTextArea = super.addTextarea(this.getContentPanel(), true, 0, 360, DIALOG_WIDTH, 130);
        this.m_oCommentTextArea.setEnabled(this.m_bAllowEditing);
        this.m_oCommentTextArea.setLineWrap(true);
        this.m_oCommentTextArea.setWrapStyleWord(true);
        this.m_oCommentTextArea.addFocusListener(this.mf_oFocusListener);
        this.m_oCommentTextArea.setText(this.m_oEffortToEdit.getDescription());
    }

    private JLabel _addDatePattern(JPanel jPanel, int n, int n2, int n3, int n4) {
        JLabel jLabel = new JLabel(DateTime.getReadableDateFormatPattern());
        jLabel.setBounds(n, n2, n3, n4);
        jPanel.add(jLabel);
        return jLabel;
    }

    private JLabel _addTimePattern(JPanel jPanel, int n, int n2, int n3, int n4) {
        JLabel jLabel = new JLabel(DateTime.getReadableTimeFormatPattern());
        jPanel.add(jLabel);
        jLabel.setBounds(n, n2, n3, n4);
        return jLabel;
    }

    private JLabel _addDurationPattern(JPanel jPanel, int n, int n2, int n3, int n4) {
        JLabel jLabel = new JLabel(DateTime.getDurationFormatPattern());
        jPanel.add(jLabel);
        jLabel.setBounds(n, n2, n3, n4);
        return jLabel;
    }

    public CTaskImpl getNewTask() {
        return this.m_oCurrentlySelectedTask;
    }

    public Calendar getBegin() {
        return DateTime.getCalendar(this.m_oStartDateTextfield, this.m_oStartTimeTextfield);
    }

    public int getWorkDuration() {
        return this.m_oWorkDurationTextfield.getSecondsCount() / 60;
    }

    public int getPauseDuration() {
        return this.m_oPauseDurationTextfield.getSecondsCount() / 60;
    }

    @Override
    protected boolean onOK() {
        if (!this.checkDialogHealth(true)) {
            if (this.m_oCurrentlySelectedProject.getTaskCount() == 0) {
                FredMessageBox.showInfoDlg(Labels.get("INFORMATION_EMPTY_PROJEKT", new Object[0]), Labels.get("TITLE_ERROR", new Object[0]), MessageBox.EIcon.WARNING);
            }
            return false;
        }
        this.m_oEffortToEdit.setCategory((CategoryList.CCategory)this.m_oCategoryComboBox.getSelectedItem());
        this.m_oEffortToEdit.setDescription(this.m_oCommentTextArea.getText());
        this.m_oEffortToEdit.setIgnoreMistake(this.m_oErrorIgnoredCheckBox.isSelected());
        this.m_oEffortToEdit.setAccepted(this.m_oAcceptedComboBox.getSelectedIndex());
        this.m_oEffortToEdit.setReplicated(this.m_oReplicatedCheckBox.isSelected());
        this.m_oEffortToEdit.setApproved(true);
        return true;
    }

    private boolean _validateEffort() {
        this.m_bIsValidEffort = true;
        this.m_bIsValidEffort = this.m_bIsValidEffort && this.m_oStartDateTextfield.evaluateContent();
        this.m_bIsValidEffort = this.m_bIsValidEffort && this.m_oStartTimeTextfield.evaluateContent();
        this.m_bIsValidEffort = this.m_bIsValidEffort && this.m_oEndDateTextfield.evaluateContent();
        this.m_bIsValidEffort = this.m_bIsValidEffort && this.m_oEndTimeTextfield.evaluateContent();
        this.m_bIsValidEffort = this.m_bIsValidEffort && this.m_oWorkDurationTextfield.evaluateContent();
        boolean bl = this.m_bIsValidEffort = this.m_bIsValidEffort && this.m_oPauseDurationTextfield.evaluateContent();
        if (!this.m_bIsValidEffort) {
            return false;
        }
        Calendar calendar = DateTime.getCalendar(this.m_oStartDateTextfield, this.m_oStartTimeTextfield);
        Calendar calendar2 = DateTime.getCalendar(this.m_oEndDateTextfield, this.m_oEndTimeTextfield);
        int n = DateTime.calculateDurationInt(calendar, calendar2);
        n = this.m_oWorkLockButton.isToggleButtonActivated() ? (n -= this.m_oPauseDurationTextfield.getSecondsCount() / 60) : (n -= this.m_oWorkDurationTextfield.getSecondsCount() / 60);
        if (n < 0) {
            this.m_bIsValidEffort = false;
            this.setErrorText(Labels.get("WRONG_END_TIME", new Object[0]));
            this.m_oEndDateTextfield.highlightControl(true);
            this.m_oEndTimeTextfield.highlightControl(true);
            return false;
        }
        this.setErrorText(null);
        this.m_oEndDateTextfield.highlightControl(false);
        this.m_oEndTimeTextfield.highlightControl(false);
        return true;
    }

    private boolean checkDialogHealth(boolean bl) {
        if (this.evaluateValidationList(bl, true) != null) {
            return false;
        }
        if (this.m_oTaskComboBox.getSelectedItem() == null) {
            return false;
        }
        return this._validateEffort();
    }

    private void autoComputeTimes(Component component) {
        if (this.m_bAutoComputeTimesLock) {
            return;
        }
        if (!(this.m_oStartDateTextfield.evaluateContent() && this.m_oStartTimeTextfield.evaluateContent() && this.m_oEndDateTextfield.evaluateContent() && this.m_oEndTimeTextfield.evaluateContent() && this.m_oWorkDurationTextfield.evaluateContent() && this.m_oPauseDurationTextfield.evaluateContent())) {
            return;
        }
        this.m_bAutoComputeTimesLock = true;
        boolean bl = this.m_oWorkLockButton.isToggleButtonActivated();
        Calendar calendar = DateTime.getCalendar(this.m_oStartDateTextfield, this.m_oStartTimeTextfield);
        Calendar calendar2 = DateTime.getCalendar(this.m_oEndDateTextfield, this.m_oEndTimeTextfield);
        int n = this.m_oWorkDurationTextfield.getSecondsCount() / 60;
        int n2 = this.m_oPauseDurationTextfield.getSecondsCount() / 60;
        int n3 = DateTime.calculateDurationInt(calendar, calendar2);
        n3 = Math.max(n3, 0);
        if (component == this.m_oEndDateTextfield && this.m_lInitialEndDate != -1L && this.m_lInitialEndDate != this.m_oEndDateTextfield.getAsMilliseconds()) {
            this.m_lInitialEndDate = -1L;
            this.m_lInitialEndTime = -1L;
        }
        if (component == this.m_oEndTimeTextfield && this.m_lInitialEndTime != -1L && this.m_lInitialEndTime != this.m_oEndTimeTextfield.getAsMilliseconds(true)) {
            this.m_lInitialEndTime = -1L;
        }
        if (component == this.m_oStartDateTextfield && this.m_lInitialEndDate != -1L) {
            this.m_oEndDateTextfield.setFromCalendar(calendar);
        } else if (component == this.m_oStartTimeTextfield && this.m_lInitialEndTime != -1L) {
            this.m_oEndTimeTextfield.setFromCalendar(calendar);
        } else if (component == this.m_oStartDateTextfield || component == this.m_oStartTimeTextfield) {
            if (bl) {
                if (n3 <= n2) {
                    if (n == 0) {
                        Calendar calendar3 = (Calendar)calendar.clone();
                        calendar3.add(12, n2);
                        this.m_oEndDateTextfield.setFromCalendar(calendar3);
                        this.m_oEndTimeTextfield.setFromCalendar(calendar3);
                    } else {
                        Calendar calendar4 = (Calendar)calendar2.clone();
                        calendar4.add(12, -n2);
                        this.m_oStartDateTextfield.setFromCalendar(calendar4);
                        this.m_oStartTimeTextfield.setFromCalendar(calendar4);
                    }
                    this.m_oWorkDurationTextfield.setSecondsCount(0);
                    n3 = n2;
                } else {
                    this.m_oWorkDurationTextfield.setSecondsCount((n3 - n2) * 60);
                }
            } else if (n3 <= n) {
                if (n2 == 0) {
                    Calendar calendar5 = (Calendar)calendar.clone();
                    calendar5.add(12, n);
                    this.m_oEndDateTextfield.setFromCalendar(calendar5);
                    this.m_oEndTimeTextfield.setFromCalendar(calendar5);
                } else {
                    Calendar calendar6 = (Calendar)calendar2.clone();
                    calendar6.add(12, -n);
                    this.m_oStartDateTextfield.setFromCalendar(calendar6);
                    this.m_oStartTimeTextfield.setFromCalendar(calendar6);
                }
                this.m_oPauseDurationTextfield.setSecondsCount(0);
                n3 = n;
            } else {
                this.m_oPauseDurationTextfield.setSecondsCount((n3 - n) * 60);
            }
        } else if (component == this.m_oEndDateTextfield || component == this.m_oEndTimeTextfield) {
            if (bl) {
                if (n3 <= n2) {
                    if (n == 0) {
                        Calendar calendar7 = (Calendar)calendar2.clone();
                        calendar7.add(12, -n2);
                        this.m_oStartDateTextfield.setFromCalendar(calendar7);
                        this.m_oStartTimeTextfield.setFromCalendar(calendar7);
                    } else {
                        Calendar calendar8 = (Calendar)calendar.clone();
                        calendar8.add(12, n2);
                        this.m_oEndDateTextfield.setFromCalendar(calendar8);
                        this.m_oEndTimeTextfield.setFromCalendar(calendar8);
                    }
                    this.m_oWorkDurationTextfield.setSecondsCount(0);
                    n3 = n2;
                } else {
                    this.m_oWorkDurationTextfield.setSecondsCount((n3 - n2) * 60);
                }
            } else if (n3 <= n) {
                if (n2 == 0) {
                    Calendar calendar9 = (Calendar)calendar2.clone();
                    calendar9.add(12, -n);
                    this.m_oStartDateTextfield.setFromCalendar(calendar9);
                    this.m_oStartTimeTextfield.setFromCalendar(calendar9);
                } else {
                    Calendar calendar10 = (Calendar)calendar.clone();
                    calendar10.add(12, n);
                    this.m_oEndDateTextfield.setFromCalendar(calendar10);
                    this.m_oEndTimeTextfield.setFromCalendar(calendar10);
                }
                this.m_oPauseDurationTextfield.setSecondsCount(0);
                n3 = n;
            } else {
                this.m_oPauseDurationTextfield.setSecondsCount((n3 - n) * 60);
            }
        } else if (component == this.m_oWorkDurationTextfield || component == this.m_oPauseDurationTextfield) {
            calendar2 = DateTime.getEndDateByDuration(calendar, n + n2);
            this.m_oEndDateTextfield.setFromCalendar(calendar2);
            this.m_oEndTimeTextfield.setFromCalendar(calendar2);
            this.m_lInitialEndDate = -1L;
            this.m_lInitialEndTime = -1L;
        }
        this._validateEffort();
        this.m_bAutoComputeTimesLock = false;
    }

    private void openCalendarChooser(JButton jButton) {
        Point point = new Point();
        SwingUtilities.convertPointToScreen(point, jButton);
        point.x += -55;
        point.y += -60;
        Calendar calendar = this.m_oStartDateTextfield.evaluateContent() && this.m_oStartTimeTextfield.evaluateContent() ? (jButton == this.m_oStartTimeCalendarButton ? this.m_oStartDateTextfield.getAsCalendar() : this.m_oEndDateTextfield.getAsCalendar()) : Calendar.getInstance();
        calendar = CCalendarChooser.chooseDate(this, point.x, point.y, calendar);
        if (calendar != null) {
            if (jButton == this.m_oStartTimeCalendarButton) {
                this.m_oStartDateTextfield.setFromCalendar(calendar);
                this.autoComputeTimes((Component)((Object)this.m_oStartDateTextfield));
            } else {
                this.m_oEndDateTextfield.setFromCalendar(calendar);
                this.autoComputeTimes((Component)((Object)this.m_oEndDateTextfield));
            }
        }
        this.checkDialogHealth(false);
    }

    private void handleProjectSelectionChange() {
        CProjectImpl cProjectImpl;
        this.m_oCurrentlySelectedProject = cProjectImpl = (CProjectImpl)this.m_oProjectComboBox.getSelectedItem();
        if (cProjectImpl.getTaskCount() == 0) {
            this.m_oCategoryComboBox.setEnabled(false);
            this.m_oCategoryComboBox.setModel(this.m_oEmptyModel);
            this.m_oTaskComboBox.setEnabled(false);
            this.m_oTaskComboBox.setModel(this.m_oEmptyModel);
            return;
        }
        this.m_oCategoryComboBox.setModel(this.m_oCategoryComboBoxModel);
        this.m_oCategoryComboBox.setEnabled(true);
        this.m_oTaskComboBoxModel = cProjectImpl.getTaskComboBoxModel();
        this.m_oTaskComboBox.setModel(this.m_oTaskComboBoxModel);
        this.m_oTaskComboBox.setEnabled(true);
        this.handleTaskSelectionChange();
    }

    private void handleTaskSelectionChange() {
        CTaskImpl cTaskImpl = (CTaskImpl)this.m_oTaskComboBoxModel.getSelectedItem();
        if (cTaskImpl == null) {
            return;
        }
        this.m_oCurrentlySelectedTask = cTaskImpl;
        CategoryList.CCategory cCategory = cTaskImpl.getDefaultCCategory();
        this.m_oCategoryComboBox.setSelectedItem(cCategory);
    }

    static {
        try {
            LOCK_OPEN_ICON = MainController.getResLoader().getIconExcpt("images/lock-open.png");
            LOCK_CLOSED_ICON = MainController.getResLoader().getIconExcpt("images/lock-closed.png");
        }
        catch (ResourceLoader.ResourceLoadException resourceLoadException) {
            throw new ExceptionInInitializerError(resourceLoadException);
        }
        DIALOG_WIDTH = SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 510 : 560;
        DIALOG_HALF_WIDTH = (DIALOG_WIDTH - 10) / 2;
        OK_CTRL_ENTER_STROKE = KeyStroke.getKeyStroke(10, 2, true);
    }

    private class COkHandler
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CDlgEffortEditEffort.this.incomingSubmit();
        }
    }

    private class CChangeListener
    implements ChangeListener {
        Component oOwner;

        CChangeListener(Component component) {
            this.oOwner = component;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            CDlgEffortEditEffort.this.autoComputeTimes(this.oOwner);
        }
    }

    private class CLockButton
    extends CFlatButton
    implements IButtonListener {
        CLockButton(boolean bl) {
            super((Icon)LOCK_CLOSED_ICON);
            this.setToggleButton(true);
            this.addButtonListener(this, BaseEventManager.ERefType.REGULAR);
            if (bl) {
                this.activateToggleButton(true, false);
            }
        }

        public void activateToggleButton(boolean bl, boolean bl2) {
            super.activateToggleButton(bl, bl2);
            this._setCorrectIcon();
        }

        public void buttonActionPerformed(CButtonEvent cButtonEvent) {
            boolean bl = cButtonEvent.getSource() == CDlgEffortEditEffort.this.m_oWorkLockButton ? CDlgEffortEditEffort.this.m_oWorkLockButton.isToggleButtonActivated() : !CDlgEffortEditEffort.this.m_oPauseLockButton.isToggleButtonActivated();
            CDlgEffortEditEffort.this.m_oWorkLockButton.activateToggleButton(bl, false);
            CDlgEffortEditEffort.this.m_oPauseLockButton.activateToggleButton(!bl, false);
            CDlgEffortEditEffort.this.m_oWorkDurationTextfield.setEnabled(bl);
            CDlgEffortEditEffort.this.m_oPauseDurationTextfield.setEnabled(!bl);
        }

        private void _setCorrectIcon() {
            if (this.isToggleButtonActivated()) {
                this.setIcon(LOCK_OPEN_ICON);
            } else {
                this.setIcon(LOCK_CLOSED_ICON);
            }
        }
    }

    private class CCalendarActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CDlgEffortEditEffort.this.openCalendarChooser((JButton)actionEvent.getSource());
        }
    }

    private class CTaskItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                CDlgEffortEditEffort.this.handleTaskSelectionChange();
            }
        }
    }

    private class CProjectItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                CDlgEffortEditEffort.this.handleProjectSelectionChange();
            }
        }
    }

    private class CFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            CDlgEffortEditEffort.this.checkDialogHealth(false);
        }
    }
}

