/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view;

import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.CViewContainer;
import com.mayastudios.mscl.mwt.dockpane.statusbar.CAutoHideWidget;
import com.mayastudios.mscl.mwt.dockpane.statusbar.CStatusBar;
import java.awt.Component;
import javax.swing.JLabel;

public class FredStatusBar {
    private static final int DEFAULT_TIMEOUT = 7;
    private static final String STATUSBAR_EFFORT_COUNT_TEXT = Labels.get("STATUSBAR_EFFORT_COUNT_TEXT", new Object[0]);
    private static final String STATUSBAR_EFFORT_DURATION_TEXT = Labels.get("STATUSBAR_EFFORT_DURATION_TEXT", new Object[0]);
    private static CDefaultTextWidget s_oDefaultField = new CDefaultTextWidget();
    private static JLabel s_oEffortCountLabel = new JLabel();
    private static JLabel s_oEffortSumLabel = new JLabel();

    public static void initStatusbar(CViewContainer cViewContainer) {
        CStatusBar cStatusBar = cViewContainer.getStatusBar();
        cStatusBar.addField((Component)((Object)s_oDefaultField), true);
        cStatusBar.addField((Component)s_oEffortCountLabel, false);
        cStatusBar.addField((Component)s_oEffortSumLabel, false);
    }

    public static void setText(String string) {
        FredStatusBar.setTextForInterval(string, 0);
    }

    public static void setTextForInterval(String string) {
        FredStatusBar.setTextForInterval(string, 7);
    }

    public static void setTextForInterval(String string, int n) {
        s_oDefaultField.setText(string);
        s_oDefaultField.hideDelayed(n * 1000);
    }

    public static void refreshEffortData(int n, int n2) {
        s_oEffortCountLabel.setText(String.format(STATUSBAR_EFFORT_COUNT_TEXT, new Integer(n)));
        s_oEffortSumLabel.setText(String.format(STATUSBAR_EFFORT_DURATION_TEXT, DateTime.getDurationString(n2, false)));
    }

    public static void resetEffortData() {
        s_oEffortCountLabel.setText("");
        s_oEffortSumLabel.setText("");
    }

    private static class CDefaultTextWidget
    extends CAutoHideWidget {
        private static final String DEFAULT_TEXT = Labels.get("STATUSBAR_DEFAULT_TEXT", new Object[0]);

        CDefaultTextWidget() {
            super((Component)new JLabel(DEFAULT_TEXT));
        }

        void setText(String string) {
            ((JLabel)this.getComponent()).setText(string);
        }

        protected boolean prepareToHide() {
            this.setText(DEFAULT_TEXT);
            return false;
        }
    }
}

