/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view;

import com.mayastudios.fred.client.model.CColumn;
import com.mayastudios.fred.client.model.CColumnModel;
import com.mayastudios.fred.client.model.CEffortImpl;
import com.mayastudios.fred.client.model.CEffortTableModel;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.CEffortTableRenderer;
import com.mayastudios.ixml.labels.LString;
import com.mayastudios.mscl.mwt.widgets.CTableEx;
import java.awt.event.MouseEvent;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CEffortTable
extends CTableEx {
    private static final LString TOOLTIP_HEADING = Labels.getLS("EffortTable.Tooltip.Heading");
    private static final LString TOOLTIP_REPLICATED_HEADING = Labels.getLS("EffortTable.Tooltip.Replicated.Heading");
    private static final LString TOOLTIP_REPLICATED_NOTPOSSIBLELEADER = Labels.getLS("EffortTable.Tooltip.Replicated.NotPossibleLeader");
    private static final LString TOOLTIP_REPLICATED_COLLECTED = Labels.getLS("EffortTable.Tooltip.Replicated.Collected");
    private static final LString TOOLTIP_REPLICATED_NOTPOSSIBLELOCAL = Labels.getLS("EffortTable.Tooltip.Replicated.NotPossibleLocal");
    private static final LString TOOLTIP_REPLICATED_NOTPOSSIBLELOCALTASK = Labels.getLS("EffortTable.Tooltip.Replicated.NotPossibleLocalTask");
    private static final LString TOOLTIP_REPLICATED_REPLICATED = Labels.getLS("EffortTable.Tooltip.Replicated.Replicated");
    private static final LString TOOLTIP_REPLICATED_NOTYET = Labels.getLS("EffortTable.Tooltip.Replicated.NotYet");
    private static final LString TOOLTIP_COLLISIONS_HEADING = Labels.getLS("EffortTable.Tooltip.Collisions.Heading");
    private static final LString TOOLTIP_COLLISIONS_YESONE = Labels.getLS("EffortTable.Tooltip.Collisions.YesOne");
    private static final LString TOOLTIP_COLLISIONS_YESMULTIPLE = Labels.getLS("EffortTable.Tooltip.Collisions.YesMultiple");
    private static final LString TOOLTIP_ACCEPTED_HEADING = Labels.getLS("EffortTable.Tooltip.Accepted.Heading");
    private static final LString TOOLTIP_CHECKED_HEADING = Labels.getLS("EffortTable.Tooltip.Checked.Heading");
    private static final LString TOOLTIP_YES = Labels.getLS("Text.Yes");
    private static final LString TOOLTIP_NO = Labels.getLS("Text.No");
    private final CTableEx.ISecondRowCallback mf_oSecondRowRenderer;

    public CEffortTable(CEffortTableModel cEffortTableModel, CColumnModel cColumnModel, ListSelectionModel listSelectionModel) {
        super((TableModel)cEffortTableModel, (TableColumnModel)cColumnModel, listSelectionModel);
        super.setSelectionMode(2);
        super.setAutoResizeMode(0);
        super.setDefaultRenderer(CEffortImpl.class, (TableCellRenderer)new CEffortTableRenderer());
        this.mf_oSecondRowRenderer = CEffortTableRenderer.createSecondRowRenderer(cEffortTableModel);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new CTableHeaderEx(this.columnModel);
    }

    public void setEnableSecondRow(boolean bl) {
        if (bl) {
            super.enableSecondRow(this.mf_oSecondRowRenderer, 1, 20);
        } else {
            super.disableSecondRow();
        }
    }

    @Deprecated
    public void enableSecondRow(CTableEx.ISecondRowCallback iSecondRowCallback, int n, int n2) {
        super.enableSecondRow(iSecondRowCallback, n, n2);
    }

    @Deprecated
    public void disableSecondRow() {
        super.disableSecondRow();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        if (n == -1) {
            return "";
        }
        CEffortImpl cEffortImpl = ((CEffortTableModel)this.getModel()).getRow(n);
        String string = TOOLTIP_HEADING.format(new Object[]{cEffortImpl.getContent(CColumnModel.EColumnType.StartEndTime)});
        string = string + TOOLTIP_REPLICATED_HEADING;
        string = cEffortImpl.getProject().isBroadcasted() ? (cEffortImpl.isUserOwner() ? string + TOOLTIP_REPLICATED_NOTPOSSIBLELEADER : string + TOOLTIP_REPLICATED_COLLECTED) : (!cEffortImpl.getProject().isTeamProject() ? string + TOOLTIP_REPLICATED_NOTPOSSIBLELOCAL : (!cEffortImpl.getTask().isSubscibed() ? string + TOOLTIP_REPLICATED_NOTPOSSIBLELOCALTASK : (cEffortImpl.isReplicated() ? string + TOOLTIP_REPLICATED_REPLICATED : string + TOOLTIP_REPLICATED_NOTYET)));
        string = string + TOOLTIP_COLLISIONS_HEADING;
        string = !cEffortImpl.isColliding() ? string + TOOLTIP_NO : (cEffortImpl.getCollisionCount() == 1 ? string + TOOLTIP_COLLISIONS_YESONE : string + TOOLTIP_COLLISIONS_YESMULTIPLE.format(new Object[]{new Integer(cEffortImpl.getCollisionCount())}));
        string = string + TOOLTIP_ACCEPTED_HEADING + cEffortImpl.getAccepted().getDescription();
        string = string + TOOLTIP_CHECKED_HEADING;
        string = cEffortImpl.isApproved() ? string + TOOLTIP_YES : string + TOOLTIP_NO;
        return string;
    }

    private class CTableHeaderEx
    extends JTableHeader {
        CTableHeaderEx(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.columnModel.getColumnIndexAtX(mouseEvent.getPoint().x);
            if (n >= 0) {
                return ((CColumn)this.columnModel.getColumn(n)).getTooltip();
            }
            return "";
        }
    }
}

