/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.util.avltree;

import com.mayastudios.fred.client.util.avltree.AVLNode;
import com.mayastudios.fred.client.util.avltree.AVLTreeException;
import com.mayastudios.fred.client.util.avltree.NodeIteratorDown;
import com.mayastudios.fred.client.util.avltree.NodeIteratorLevel;
import com.mayastudios.fred.client.util.avltree.NodeIteratorNull;
import com.mayastudios.fred.client.util.avltree.NodeIteratorUp;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

public class AVLTree<E extends Comparable<? super E>>
implements SortedSet<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<E> m_GenericClass;
    private AVLNode<E> m_RootNode = null;
    private AVLNode<E> m_FirstNode = null;
    private AVLNode<E> m_LastNode = null;
    private int mi_Size = 0;
    private long ml_OperationCount;
    private boolean m_bUseSuccesor = true;
    private int m_iChecksum;
    private AVLNode<E> m_CheckSmallest;
    private AVLNode<E> m_CheckLargest;

    public AVLTree(Class<E> clazz) {
        this.m_GenericClass = clazz;
    }

    @Override
    public int size() {
        return this.mi_Size;
    }

    @Override
    public Iterator<E> iterator() {
        return this.iteratorUpAll();
    }

    public Iterator<E> iteratorUpAll() {
        if (this.isEmpty()) {
            return new NodeIteratorNull();
        }
        return new NodeIteratorUp<E>(this, this.m_FirstNode, this.m_LastNode.m_Element);
    }

    public Iterator<E> iteratorUpLarger(E e) {
        if (this.isEmpty()) {
            return new NodeIteratorNull();
        }
        return this.iteratorUpBetween(e, this.m_LastNode.m_Element);
    }

    public Iterator<E> iteratorUpSmaller(E e) {
        if (this.isEmpty()) {
            return new NodeIteratorNull();
        }
        return this.iteratorUpBetween(this.m_FirstNode.m_Element, e);
    }

    public Iterator<E> iteratorUpBetween(E e, E e2) {
        if (this.isEmpty()) {
            return new NodeIteratorNull();
        }
        AVLSearchResult aVLSearchResult = this.findNode(e);
        AVLNode aVLNode = null;
        if (aVLSearchResult.m_NodePointer != null) {
            aVLNode = aVLSearchResult.m_NodePointer;
        } else if (aVLSearchResult.m_NodeParent != null) {
            aVLNode = aVLSearchResult.mb_PointsLeft ? aVLSearchResult.m_NodeParent : this.getSuccessor(aVLSearchResult.m_NodeParent);
        }
        return new NodeIteratorUp(this, aVLNode, e2);
    }

    public Iterator<E> iteratorDownAll() {
        if (this.isEmpty()) {
            return new NodeIteratorNull();
        }
        return new NodeIteratorDown<E>(this, this.m_LastNode, this.m_FirstNode.m_Element);
    }

    public Iterator<E> iteratorDown(E e) {
        if (this.isEmpty()) {
            return new NodeIteratorNull();
        }
        return this.iteratorDown(e, this.m_FirstNode.m_Element);
    }

    public Iterator<E> iteratorDown(E e, E e2) {
        if (this.isEmpty()) {
            return new NodeIteratorNull();
        }
        AVLSearchResult aVLSearchResult = this.findNode(e);
        AVLNode aVLNode = null;
        if (aVLSearchResult.m_NodePointer != null) {
            aVLNode = aVLSearchResult.m_NodePointer;
        } else if (aVLSearchResult.m_NodeParent != null) {
            aVLNode = !aVLSearchResult.mb_PointsLeft ? aVLSearchResult.m_NodeParent : this.getPredecessor(aVLSearchResult.m_NodeParent);
        }
        return new NodeIteratorDown(this, aVLNode, e2);
    }

    public Iterator<E> iteratorLevel() {
        if (this.isEmpty()) {
            return new NodeIteratorNull();
        }
        return new NodeIteratorLevel<E>(this, this.m_RootNode);
    }

    @Override
    public Comparator<? super E> comparator() {
        return new AVLElementComparator();
    }

    @Override
    public SortedSet<E> subSet(E e, E e2) {
        AVLTree<Comparable> aVLTree = new AVLTree<Comparable>(this.m_GenericClass);
        Iterator<E> iterator = this.iteratorUpBetween(e, e2);
        while (iterator.hasNext()) {
            aVLTree.add((Comparable)iterator.next());
        }
        return aVLTree;
    }

    @Override
    public SortedSet<E> headSet(E e) {
        return this.subSet((E)this.m_FirstNode.m_Element, e);
    }

    @Override
    public SortedSet<E> tailSet(E e) {
        return this.subSet(e, (E)this.m_LastNode.m_Element);
    }

    @Override
    public E first() {
        return this.m_FirstNode != null ? (E)this.m_FirstNode.m_Element : null;
    }

    @Override
    public E last() {
        return this.m_LastNode != null ? (E)this.m_LastNode.m_Element : null;
    }

    @Override
    public boolean isEmpty() {
        if (this.mi_Size == 0 != (this.m_RootNode == null)) {
            throw new AVLTreeException("isEmpty: !((this.mi_Size == 0) == (this.m_RootNode == null))");
        }
        return this.mi_Size == 0;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null || !this.m_GenericClass.isInstance(object)) {
            return false;
        }
        Comparable comparable = (Comparable)this.m_GenericClass.cast(object);
        return this.findNode(comparable).m_NodePointer != null;
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        if (objectArray.length == 0) {
            return objectArray;
        }
        Iterator<E> iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        return objectArray;
    }

    @Override
    public synchronized <T> T[] toArray(T[] objectArray) {
        if (objectArray == null) {
            throw new NullPointerException("aoStorage == null");
        }
        Class<E> clazz = objectArray.getClass().getComponentType();
        if (!clazz.isAssignableFrom(this.m_GenericClass)) {
            throw new ArrayStoreException(clazz.getName() + " is no superclass of " + this.m_GenericClass.getName());
        }
        if (objectArray.length < this.size()) {
            objectArray = (Object[])Array.newInstance(clazz, this.size());
        }
        Iterator<E> iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = clazz.cast(iterator.next());
            ++n;
        }
        while (n < objectArray.length) {
            objectArray[n] = null;
            ++n;
        }
        return objectArray;
    }

    @Override
    public synchronized boolean add(E e) {
        if (e == null) {
            return false;
        }
        if (this.isEmpty()) {
            this.m_RootNode = new AVLNode<E>(e);
            this.m_FirstNode = this.m_RootNode;
            this.m_LastNode = this.m_RootNode;
            this.notifyNodeAdded();
            return true;
        }
        AVLSearchResult aVLSearchResult = this.findNode(e);
        if (aVLSearchResult.m_NodePointer != null) {
            return false;
        }
        if (aVLSearchResult.m_NodeParent == null) {
            throw new AVLTreeException("add: searchResult.m_NodeParent == null");
        }
        if (aVLSearchResult.mb_PointsLeft) {
            AVLNode<E> aVLNode = new AVLNode<E>(e);
            aVLNode.m_NodeParent = aVLSearchResult.m_NodeParent;
            aVLSearchResult.m_NodeParent.m_NodeLeft = aVLNode;
            this.setBalancesAfterAdd(aVLNode);
            this.notifyNodeAdded();
            if (this.m_FirstNode.compareTo(e) > 0) {
                this.m_FirstNode = aVLNode;
            }
            return true;
        }
        if (!aVLSearchResult.mb_PointsLeft) {
            AVLNode<E> aVLNode = new AVLNode<E>(e);
            aVLNode.m_NodeParent = aVLSearchResult.m_NodeParent;
            aVLSearchResult.m_NodeParent.m_NodeRight = aVLNode;
            this.setBalancesAfterAdd(aVLNode);
            this.notifyNodeAdded();
            if (this.m_LastNode.compareTo(e) < 0) {
                this.m_LastNode = aVLNode;
            }
            return true;
        }
        throw new AVLTreeException("add: unreachable Code");
    }

    private void setBalancesAfterAdd(AVLNode<E> aVLNode) {
        if (aVLNode != null) {
            AVLNode<E> aVLNode2 = aVLNode;
            AVLNode aVLNode3 = aVLNode.m_NodeParent;
            while (aVLNode3 != null) {
                if (aVLNode3.m_NodeLeft == aVLNode2) {
                    aVLNode3.m_byBalance = (byte)(aVLNode3.m_byBalance - 1);
                } else if (aVLNode3.m_NodeRight == aVLNode2) {
                    aVLNode3.m_byBalance = (byte)(aVLNode3.m_byBalance + 1);
                } else {
                    throw new AVLTreeException("setBalancesAfterAdd: pointerParent.m_NodeLeft != pointerChild && pointerParent.m_NodeRight != pointerChild");
                }
                if (aVLNode3.m_byBalance == 0) {
                    return;
                }
                if (aVLNode3.m_byBalance == -2 || aVLNode3.m_byBalance == 2) {
                    this.rotate(aVLNode3);
                    return;
                }
                aVLNode2 = aVLNode3;
                aVLNode3 = aVLNode3.m_NodeParent;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AVLNode<E> rotate(AVLNode<E> aVLNode) {
        if (aVLNode == null) return null;
        if (aVLNode.m_byBalance == 2) {
            AVLNode aVLNode2 = aVLNode.m_NodeRight;
            if (aVLNode2 == null) {
                throw new AVLTreeException("rotate (2|?): pointerChild == null");
            }
            if (aVLNode2.m_byBalance == -1) {
                AVLNode aVLNode3 = aVLNode2.m_NodeLeft;
                if (aVLNode3 == null) {
                    throw new AVLTreeException("rotate (2|-1): pointerGrandChild == null");
                }
                AVLNode aVLNode4 = aVLNode.m_NodeParent;
                if (aVLNode4 == null) {
                    if (aVLNode != this.m_RootNode) throw new AVLTreeException("rotate (2|-1): pointerParent != this.m_RootNode && pointerGrandFather == null");
                    ++this.ml_OperationCount;
                    this.m_RootNode = aVLNode3;
                    aVLNode3.m_NodeParent = null;
                } else if (aVLNode4.m_NodeLeft == aVLNode) {
                    ++this.ml_OperationCount;
                    aVLNode4.m_NodeLeft = aVLNode3;
                    aVLNode3.m_NodeParent = aVLNode4;
                } else {
                    if (aVLNode4.m_NodeRight != aVLNode) throw new AVLTreeException("rotate (2|-1): pointerGrandFather.m_NodeLeft != pointerParent && pointerGrandFather.m_NodeRight != pointerParent");
                    ++this.ml_OperationCount;
                    aVLNode4.m_NodeRight = aVLNode3;
                    aVLNode3.m_NodeParent = aVLNode4;
                }
                this.ml_OperationCount += 4L;
                aVLNode.m_NodeRight = aVLNode3.m_NodeLeft;
                if (aVLNode.m_NodeRight != null) {
                    aVLNode.m_NodeRight.m_NodeParent = aVLNode;
                }
                aVLNode2.m_NodeLeft = aVLNode3.m_NodeRight;
                if (aVLNode2.m_NodeLeft != null) {
                    aVLNode2.m_NodeLeft.m_NodeParent = aVLNode2;
                }
                aVLNode3.m_NodeLeft = aVLNode;
                aVLNode.m_NodeParent = aVLNode3;
                aVLNode3.m_NodeRight = aVLNode2;
                aVLNode2.m_NodeParent = aVLNode3;
                if (aVLNode3.m_byBalance == -1) {
                    aVLNode.m_byBalance = 0;
                    aVLNode2.m_byBalance = 1;
                } else if (aVLNode3.m_byBalance == 0) {
                    aVLNode.m_byBalance = 0;
                    aVLNode2.m_byBalance = 0;
                } else if (aVLNode3.m_byBalance == 1) {
                    aVLNode.m_byBalance = (byte)-1;
                    aVLNode2.m_byBalance = 0;
                }
                aVLNode3.m_byBalance = 0;
                return aVLNode3;
            }
            if (aVLNode2.m_byBalance != 1 && aVLNode2.m_byBalance != 0) throw new AVLTreeException("rotate (2|?): pointerChild.m_byBalance != -1 && pointerChild.m_byBalance != 1 && pointerChild.m_byBalance != 0");
            AVLNode aVLNode5 = aVLNode.m_NodeParent;
            if (aVLNode5 == null) {
                if (aVLNode != this.m_RootNode) throw new AVLTreeException("rotate (2|1/0): pointerParent != this.m_RootNode && pointerGrandFather == null");
                ++this.ml_OperationCount;
                this.m_RootNode = aVLNode2;
                aVLNode2.m_NodeParent = null;
            } else if (aVLNode5.m_NodeLeft == aVLNode) {
                ++this.ml_OperationCount;
                aVLNode5.m_NodeLeft = aVLNode2;
                aVLNode2.m_NodeParent = aVLNode5;
            } else {
                if (aVLNode5.m_NodeRight != aVLNode) throw new AVLTreeException("rotate (2|1/0): pointerGrandFather.m_NodeLeft != pointerParent && pointerGrandFather.m_NodeRight != pointerParent");
                ++this.ml_OperationCount;
                aVLNode5.m_NodeRight = aVLNode2;
                aVLNode2.m_NodeParent = aVLNode5;
            }
            this.ml_OperationCount += 2L;
            aVLNode.m_NodeRight = aVLNode2.m_NodeLeft;
            if (aVLNode.m_NodeRight != null) {
                aVLNode.m_NodeRight.m_NodeParent = aVLNode;
            }
            aVLNode2.m_NodeLeft = aVLNode;
            aVLNode.m_NodeParent = aVLNode2;
            if (aVLNode2.m_byBalance == 1) {
                aVLNode.m_byBalance = 0;
                aVLNode2.m_byBalance = 0;
                return aVLNode2;
            } else {
                if (aVLNode2.m_byBalance != 0) return aVLNode2;
                aVLNode.m_byBalance = 1;
                aVLNode2.m_byBalance = (byte)-1;
            }
            return aVLNode2;
        }
        if (aVLNode.m_byBalance == -2) {
            AVLNode aVLNode6 = aVLNode.m_NodeLeft;
            if (aVLNode6 == null) {
                throw new AVLTreeException("rotate (-2|?): pointerChild == null");
            }
            if (aVLNode6.m_byBalance == 1) {
                AVLNode aVLNode7 = aVLNode6.m_NodeRight;
                if (aVLNode7 == null) {
                    throw new AVLTreeException("rotate (-2|1): pointerGrandChild == null");
                }
                AVLNode aVLNode8 = aVLNode.m_NodeParent;
                if (aVLNode8 == null) {
                    if (aVLNode != this.m_RootNode) throw new AVLTreeException("rotate (-2|1): pointerParent != this.m_RootNode && pointerGrandFather == null");
                    ++this.ml_OperationCount;
                    this.m_RootNode = aVLNode7;
                    aVLNode7.m_NodeParent = null;
                } else if (aVLNode8.m_NodeLeft == aVLNode) {
                    ++this.ml_OperationCount;
                    aVLNode8.m_NodeLeft = aVLNode7;
                    aVLNode7.m_NodeParent = aVLNode8;
                } else {
                    if (aVLNode8.m_NodeRight != aVLNode) throw new AVLTreeException("rotate (-2|1): pointerGrandFather.m_NodeLeft != pointerParent&& pointerGrandFather.m_NodeRight != pointerParent");
                    ++this.ml_OperationCount;
                    aVLNode8.m_NodeRight = aVLNode7;
                    aVLNode7.m_NodeParent = aVLNode8;
                }
                this.ml_OperationCount += 4L;
                aVLNode.m_NodeLeft = aVLNode7.m_NodeRight;
                if (aVLNode.m_NodeLeft != null) {
                    aVLNode.m_NodeLeft.m_NodeParent = aVLNode;
                }
                aVLNode6.m_NodeRight = aVLNode7.m_NodeLeft;
                if (aVLNode6.m_NodeRight != null) {
                    aVLNode6.m_NodeRight.m_NodeParent = aVLNode6;
                }
                aVLNode7.m_NodeLeft = aVLNode6;
                aVLNode6.m_NodeParent = aVLNode7;
                aVLNode7.m_NodeRight = aVLNode;
                aVLNode.m_NodeParent = aVLNode7;
                if (aVLNode7.m_byBalance == 1) {
                    aVLNode.m_byBalance = 0;
                    aVLNode6.m_byBalance = (byte)-1;
                } else if (aVLNode7.m_byBalance == 0) {
                    aVLNode.m_byBalance = 0;
                    aVLNode6.m_byBalance = 0;
                } else if (aVLNode7.m_byBalance == -1) {
                    aVLNode.m_byBalance = 1;
                    aVLNode6.m_byBalance = 0;
                }
                aVLNode7.m_byBalance = 0;
                return aVLNode7;
            }
            if (aVLNode6.m_byBalance != -1 && aVLNode6.m_byBalance != 0) throw new AVLTreeException("rotate (-2|?): pointerChild.m_byBalance != -1 && pointerChild.m_byBalance != 1 && pointerChild.m_byBalance != 0");
            AVLNode aVLNode9 = aVLNode.m_NodeParent;
            if (aVLNode9 == null) {
                if (aVLNode != this.m_RootNode) throw new AVLTreeException("rotate (-2|-1/0): pointerParent != this.m_RootNode && pointerGrandFather == null");
                ++this.ml_OperationCount;
                this.m_RootNode = aVLNode6;
                aVLNode6.m_NodeParent = null;
            } else if (aVLNode9.m_NodeLeft == aVLNode) {
                ++this.ml_OperationCount;
                aVLNode9.m_NodeLeft = aVLNode6;
                aVLNode6.m_NodeParent = aVLNode9;
            } else {
                if (aVLNode9.m_NodeRight != aVLNode) throw new AVLTreeException("rotate (-2|-1/0): pointerGrandFather.m_NodeLeft != pointerParent && pointerGrandFather.m_NodeRight != pointerParent");
                ++this.ml_OperationCount;
                aVLNode9.m_NodeRight = aVLNode6;
                aVLNode6.m_NodeParent = aVLNode9;
            }
            this.ml_OperationCount += 2L;
            aVLNode.m_NodeLeft = aVLNode6.m_NodeRight;
            if (aVLNode.m_NodeLeft != null) {
                aVLNode.m_NodeLeft.m_NodeParent = aVLNode;
            }
            aVLNode6.m_NodeRight = aVLNode;
            aVLNode.m_NodeParent = aVLNode6;
            if (aVLNode6.m_byBalance == -1) {
                aVLNode.m_byBalance = 0;
                aVLNode6.m_byBalance = 0;
                return aVLNode6;
            } else {
                if (aVLNode6.m_byBalance != 0) return aVLNode6;
                aVLNode.m_byBalance = (byte)-1;
                aVLNode6.m_byBalance = 1;
            }
            return aVLNode6;
        }
        if (aVLNode.m_byBalance <= 2 && aVLNode.m_byBalance >= -2) return null;
        throw new AVLTreeException("pointerParent.m_byBalance > 2 || pointerParent.m_byBalance < -2");
    }

    @Override
    public synchronized boolean remove(Object object) {
        if (object == null || !this.m_GenericClass.isInstance(object)) {
            return false;
        }
        Comparable comparable = (Comparable)this.m_GenericClass.cast(object);
        AVLSearchResult aVLSearchResult = this.findNode(comparable);
        if (aVLSearchResult.m_NodePointer == null) {
            return false;
        }
        AVLNode aVLNode = aVLSearchResult.m_NodePointer;
        AVLNode aVLNode2 = aVLNode.m_NodeParent;
        if (aVLNode == this.m_FirstNode) {
            this.m_FirstNode = this.getSuccessor(this.m_FirstNode);
        }
        if (aVLNode == this.m_LastNode) {
            this.m_LastNode = this.getPredecessor(this.m_LastNode);
        }
        if (aVLNode.m_NodeLeft == null) {
            if (aVLNode2 == null) {
                if (aVLNode == this.m_RootNode) {
                    this.m_RootNode = aVLNode.m_NodeRight;
                    if (this.m_RootNode != null) {
                        this.m_RootNode.m_NodeParent = null;
                    }
                    this.notifyNodeRemoved();
                    return true;
                }
                throw new AVLTreeException("remove: nodeToDelete.m_NodeLeft == null && nodeParent == null&& nodeToDelete != this.m_RootNode");
            }
            if (aVLNode2.m_NodeLeft == aVLNode) {
                aVLNode2.m_NodeLeft = aVLNode.m_NodeRight;
                if (aVLNode2.m_NodeLeft != null) {
                    aVLNode2.m_NodeLeft.m_NodeParent = aVLNode2;
                }
                this.setBalancesAfterDeletion(aVLNode2, aVLNode2.m_NodeLeft);
                this.notifyNodeRemoved();
                return true;
            }
            if (aVLNode2.m_NodeRight == aVLNode) {
                aVLNode2.m_NodeRight = aVLNode.m_NodeRight;
                if (aVLNode2.m_NodeRight != null) {
                    aVLNode2.m_NodeRight.m_NodeParent = aVLNode2;
                }
                this.setBalancesAfterDeletion(aVLNode2, aVLNode2.m_NodeRight);
                this.notifyNodeRemoved();
                return true;
            }
            throw new AVLTreeException("remove: nodeToDelete.m_NodeLeft == null && nodeParent != null&& nodeParent.m_NodeLeft != nodeToDelete && nodeParent.m_NodeRight != nodeToDelete");
        }
        if (aVLNode.m_NodeRight == null) {
            if (aVLNode2 == null) {
                if (aVLNode == this.m_RootNode) {
                    this.m_RootNode = aVLNode.m_NodeLeft;
                    this.m_RootNode.m_NodeParent = null;
                    this.notifyNodeRemoved();
                    return true;
                }
                throw new AVLTreeException("remove: nodeToDelete.m_NodeRight == null && nodeParent == null&& nodeToDelete != this.m_RootNode");
            }
            if (aVLNode2.m_NodeLeft == aVLNode) {
                aVLNode2.m_NodeLeft = aVLNode.m_NodeLeft;
                aVLNode2.m_NodeLeft.m_NodeParent = aVLNode2;
                this.setBalancesAfterDeletion(aVLNode2, aVLNode2.m_NodeLeft);
                this.notifyNodeRemoved();
                return true;
            }
            if (aVLNode2.m_NodeRight == aVLNode) {
                aVLNode2.m_NodeRight = aVLNode.m_NodeLeft;
                aVLNode2.m_NodeRight.m_NodeParent = aVLNode2;
                this.setBalancesAfterDeletion(aVLNode2, aVLNode2.m_NodeRight);
                this.notifyNodeRemoved();
                return true;
            }
            throw new AVLTreeException("remove: nodeToDelete.m_NodeRight == null && nodeParent != null&& nodeParent.m_NodeLeft != nodeToDelete && nodeParent.m_NodeRight != nodeToDelete");
        }
        if (this.m_bUseSuccesor) {
            AVLNode aVLNode3 = this.getSuccessor(aVLNode);
            if (aVLNode3 == null || aVLNode3.m_NodeLeft != null) {
                throw new AVLTreeException("remove: pointerSuccessor == null || pointerSuccessor.m_NodeLeft != null");
            }
            if (aVLNode3 == this.m_LastNode) {
                this.m_LastNode = aVLNode;
            }
            this.remove(aVLNode3.m_Element);
            aVLNode.m_Element = aVLNode3.m_Element;
        } else {
            AVLNode aVLNode4 = this.getPredecessor(aVLNode);
            if (aVLNode4 == null || aVLNode4.m_NodeRight != null) {
                throw new AVLTreeException("remove: pointerPredecessor == null || pointerPredecessor.m_NodeRight != null");
            }
            if (aVLNode4 == this.m_FirstNode) {
                this.m_FirstNode = aVLNode;
            }
            this.remove(aVLNode4.m_Element);
            aVLNode.m_Element = aVLNode4.m_Element;
        }
        this.m_bUseSuccesor = !this.m_bUseSuccesor;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setBalancesAfterDeletion(AVLNode<E> aVLNode, AVLNode<E> aVLNode2) {
        AVLNode<E> aVLNode3 = aVLNode;
        AVLNode<E> aVLNode4 = aVLNode2;
        while (aVLNode3 != null) {
            if (aVLNode4 == null) {
                if (aVLNode3.m_NodeLeft == null) {
                    aVLNode3.m_byBalance = aVLNode3.m_NodeRight == null ? (byte)0 : (byte)(aVLNode3.m_byBalance + 1);
                } else {
                    if (aVLNode3.m_NodeRight != null) throw new AVLTreeException("setBalancesAfterDeletion: pointerChild == null && pointerParent.m_NodeLeft != null && pointerParent.m_NodeRight != null");
                    aVLNode3.m_byBalance = (byte)(aVLNode3.m_byBalance - 1);
                }
            } else if (aVLNode3.m_NodeLeft == aVLNode4) {
                aVLNode3.m_byBalance = (byte)(aVLNode3.m_byBalance + 1);
            } else {
                if (aVLNode3.m_NodeRight != aVLNode4) throw new AVLTreeException("setBalancesAfterDeletion: pointerParent.m_NodeLeft != pointerChild && pointerParent.m_NodeRight != pointerChild");
                aVLNode3.m_byBalance = (byte)(aVLNode3.m_byBalance - 1);
            }
            if (aVLNode3.m_byBalance == -2 || aVLNode3.m_byBalance == 2) {
                aVLNode3 = this.rotate(aVLNode3);
            }
            if (aVLNode3 == null) {
                throw new AVLTreeException("setBalancesAfterDeletion: pointerParent == null");
            }
            if (aVLNode3.m_byBalance == -1 || aVLNode3.m_byBalance == 1) {
                return;
            }
            aVLNode4 = aVLNode3;
            aVLNode3 = aVLNode3.m_NodeParent;
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.add((E)((Comparable)iterator.next()));
        }
        return bl;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.remove(iterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        this.mi_Size = 0;
        this.m_RootNode = null;
        this.m_FirstNode = null;
        this.m_LastNode = null;
    }

    public String toString() {
        return "Empty: " + (this.isEmpty() ? "Yes" : "No") + "; Elementcount: " + this.mi_Size + "; Modificationcount: " + this.ml_OperationCount;
    }

    public void printInorderRekursive(PrintStream printStream, String string) {
        if (printStream == null || this.isEmpty()) {
            return;
        }
        this.printInorderRekursive(printStream, this.m_RootNode, string);
    }

    private void printInorderRekursive(PrintStream printStream, AVLNode<E> aVLNode, String string) {
        if (aVLNode.m_NodeLeft != null) {
            this.printInorderRekursive(printStream, aVLNode.m_NodeLeft, string);
        }
        printStream.print(aVLNode + string);
        if (aVLNode.m_NodeRight != null) {
            this.printInorderRekursive(printStream, aVLNode.m_NodeRight, string);
        }
    }

    public void printInorderIterative(PrintStream printStream, String string) {
        if (printStream == null || this.isEmpty()) {
            return;
        }
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            printStream.print(iterator.next() + string);
        }
    }

    public void printInorderIterativeDown(PrintStream printStream, String string) {
        if (printStream == null || this.isEmpty()) {
            return;
        }
        Iterator<E> iterator = this.iteratorDownAll();
        while (iterator.hasNext()) {
            printStream.print(iterator.next() + string);
        }
    }

    public void printLevelOrderIterative(PrintStream printStream, String string) {
        if (printStream == null || this.isEmpty()) {
            return;
        }
        Iterator<E> iterator = this.iteratorLevel();
        while (iterator.hasNext()) {
            printStream.print(iterator.next() + string);
        }
    }

    private AVLSearchResult findNode(E e) {
        AVLNode<E> aVLNode;
        AVLSearchResult aVLSearchResult;
        block5: {
            aVLSearchResult = new AVLSearchResult();
            if (e == null || this.isEmpty()) {
                return aVLSearchResult;
            }
            aVLNode = this.m_RootNode;
            AVLNode aVLNode2 = null;
            while (true) {
                int n;
                if ((n = aVLNode.compareTo(e)) > 0) {
                    aVLNode2 = aVLNode.m_NodeLeft;
                    if (aVLNode2 != null) {
                        aVLNode = aVLNode2;
                        continue;
                    }
                    aVLSearchResult.m_NodePointer = null;
                    aVLSearchResult.m_NodeParent = aVLNode;
                    aVLSearchResult.mb_PointsLeft = true;
                    return aVLSearchResult;
                }
                if (n >= 0) break block5;
                aVLNode2 = aVLNode.m_NodeRight;
                if (aVLNode2 == null) break;
                aVLNode = aVLNode2;
            }
            aVLSearchResult.m_NodePointer = null;
            aVLSearchResult.m_NodeParent = aVLNode;
            aVLSearchResult.mb_PointsLeft = false;
            return aVLSearchResult;
        }
        aVLSearchResult.m_NodePointer = aVLNode;
        aVLSearchResult.m_NodeParent = aVLNode.m_NodeParent;
        if (aVLSearchResult.m_NodeParent != null) {
            aVLSearchResult.mb_PointsLeft = aVLSearchResult.m_NodeParent.m_NodeLeft == aVLSearchResult.m_NodePointer;
        }
        return aVLSearchResult;
    }

    private void notifyNodeAdded() {
        ++this.mi_Size;
        ++this.ml_OperationCount;
    }

    private void notifyNodeRemoved() {
        if (this.mi_Size <= 0) {
            throw new AVLTreeException("notifyNodeRemoved: this.mi_Size <= 0");
        }
        --this.mi_Size;
        ++this.ml_OperationCount;
    }

    AVLNode<E> getSuccessor(AVLNode<E> aVLNode) {
        if (aVLNode == null) {
            return null;
        }
        if (aVLNode.m_NodeRight != null) {
            AVLNode aVLNode2 = aVLNode.m_NodeRight;
            while (true) {
                if (aVLNode2.m_NodeLeft == null) {
                    return aVLNode2;
                }
                aVLNode2 = aVLNode2.m_NodeLeft;
            }
        }
        AVLNode<E> aVLNode3 = aVLNode;
        AVLNode aVLNode4 = aVLNode.m_NodeParent;
        while (aVLNode4 != null) {
            if (aVLNode3 == aVLNode4.m_NodeLeft) {
                return aVLNode4;
            }
            aVLNode3 = aVLNode4;
            aVLNode4 = aVLNode3.m_NodeParent;
        }
        return null;
    }

    AVLNode<E> getPredecessor(AVLNode<E> aVLNode) {
        if (aVLNode == null) {
            return null;
        }
        if (aVLNode.m_NodeLeft != null) {
            AVLNode aVLNode2 = aVLNode.m_NodeLeft;
            while (true) {
                if (aVLNode2.m_NodeRight == null) {
                    return aVLNode2;
                }
                aVLNode2 = aVLNode2.m_NodeRight;
            }
        }
        AVLNode<E> aVLNode3 = aVLNode;
        AVLNode aVLNode4 = aVLNode.m_NodeParent;
        while (aVLNode4 != null) {
            if (aVLNode3 == aVLNode4.m_NodeRight) {
                return aVLNode4;
            }
            aVLNode3 = aVLNode4;
            aVLNode4 = aVLNode3.m_NodeParent;
        }
        return null;
    }

    public void checkTree(PrintWriter printWriter) throws AVLException {
        if (printWriter == null || this.isEmpty()) {
            return;
        }
        this.m_iChecksum = 0;
        this.m_CheckSmallest = null;
        this.m_CheckLargest = null;
        this.checkTree(printWriter, this.m_RootNode);
        if (this.m_iChecksum != this.mi_Size) {
            printWriter.println("checkTree: m_iChecksum != this.mi_Size " + this.m_iChecksum + " vs. " + this.mi_Size);
            throw new AVLException();
        }
        if (this.m_CheckSmallest != this.m_FirstNode) {
            printWriter.println("checkTree: this.m_CheckSmallest != this.m_FirstNode");
            throw new AVLException();
        }
        if (this.m_CheckLargest != this.m_LastNode) {
            printWriter.println("checkTree: this.m_CheckLargest != this.m_LastNode");
            throw new AVLException();
        }
    }

    private int checkTree(PrintWriter printWriter, AVLNode<E> aVLNode) {
        int n;
        ++this.m_iChecksum;
        int n2 = 0;
        int n3 = 0;
        if (aVLNode.m_NodeLeft != null) {
            n2 = this.checkTree(printWriter, aVLNode.m_NodeLeft);
            if (aVLNode.m_NodeLeft.m_NodeParent != aVLNode) {
                printWriter.println("checkTree: leftNode |" + aVLNode.m_NodeLeft.toString() + ".parent != |" + aVLNode.toString() + "|");
                throw new AVLException();
            }
            if (aVLNode.compareTo(aVLNode.m_NodeLeft.m_Element) <= 0) {
                printWriter.println("checkTree: leftNode |" + aVLNode.m_NodeLeft.toString() + "| >= |" + aVLNode.toString() + "|");
                throw new AVLException();
            }
        }
        if (aVLNode.m_NodeRight != null) {
            n3 = this.checkTree(printWriter, aVLNode.m_NodeRight);
            if (aVLNode.m_NodeRight.m_NodeParent != aVLNode) {
                printWriter.println("checkTree: rightNode |" + aVLNode.m_NodeRight.toString() + ".parent != |" + aVLNode.toString() + "|");
                throw new AVLException();
            }
            if (aVLNode.compareTo(aVLNode.m_NodeRight.m_Element) >= 0) {
                printWriter.println("checkTree: leftNode |" + aVLNode.m_NodeRight.toString() + "| <= |" + aVLNode.toString() + "|");
                throw new AVLException();
            }
        }
        if ((n = n3 - n2) != aVLNode.m_byBalance) {
            printWriter.println("checkTree: |" + aVLNode.toString() + "| balance " + n + " vs. " + aVLNode.m_byBalance);
            throw new AVLException();
        }
        if (n < -2 || n > 2) {
            printWriter.println("checkTree: |" + aVLNode.toString() + "| balance " + n);
            throw new AVLException();
        }
        if (this.m_CheckSmallest == null || this.m_CheckSmallest.compareTo(aVLNode.m_Element) > 0) {
            this.m_CheckSmallest = aVLNode;
        }
        if (this.m_CheckLargest == null || this.m_CheckLargest.compareTo(aVLNode.m_Element) < 0) {
            this.m_CheckLargest = aVLNode;
        }
        return Math.max(n2, n3) + 1;
    }

    public static class AVLException
    extends RuntimeException {
    }

    private static class AVLElementComparator<E extends Comparable<? super E>>
    implements Comparator<E> {
        @Override
        public int compare(E e, E e2) {
            return e.compareTo(e2);
        }
    }

    private class AVLSearchResult {
        AVLNode<E> m_NodePointer = null;
        AVLNode<E> m_NodeParent = null;
        boolean mb_PointsLeft = true;
    }
}

