/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.resources;

import com.mayastudios.fred.client.filehandling.DirectoryUtil;
import com.mayastudios.fred.client.filehandling.objectcontainer.AChildlessXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.resources.CEntry;
import com.mayastudios.fred.client.resources.configfile.ConfigFile;
import java.util.ArrayList;
import java.util.Collections;
import org.xml.sax.Attributes;

public class WorkFileSettings
implements IXMLizable {
    public static final String XML_TAG_NAME = "configuration";
    private static final String XML_ENTRY_NAME = "entry";
    private static final String XML_ATTRIBUTE_KEY = "key";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private static WorkFileSettings s_oInstance;
    private final ConfigFile m_oConfiguration = new ConfigFile();

    private WorkFileSettings() {
    }

    public static void initialize() {
        s_oInstance = new WorkFileSettings();
        WorkFileSettings.set(EConf.SaveViews, Boolean.TRUE);
        WorkFileSettings.set(EConf.ShowSecondRowPerDefault, Boolean.TRUE);
        WorkFileSettings.set(EConf.SaveNotAcceptedEfforts, Boolean.TRUE);
        WorkFileSettings.set(EConf.LastExportPath, DirectoryUtil.getHomeDirectory().getAbsolutePath());
        WorkFileSettings.set(EConf.MinimizeToTray, Boolean.FALSE);
        WorkFileSettings.set(EConf.MakeBackup, Boolean.TRUE);
        WorkFileSettings.set(EConf.ConfirmQuickSplit, Boolean.TRUE);
    }

    public static String getAsString(EConf eConf) {
        return WorkFileSettings.s_oInstance.m_oConfiguration.getAsString(eConf.toString());
    }

    public static long getAsLong(EConf eConf) {
        return WorkFileSettings.s_oInstance.m_oConfiguration.getLong(eConf.toString());
    }

    public static boolean getAsBoolean(EConf eConf) {
        return WorkFileSettings.s_oInstance.m_oConfiguration.getAsBoolean(eConf.toString());
    }

    public static void set(EConf eConf, String string) {
        WorkFileSettings.s_oInstance.m_oConfiguration.set(eConf.toString(), string);
    }

    public static void set(EConf eConf, long l) {
        WorkFileSettings.s_oInstance.m_oConfiguration.set(eConf.toString(), l);
    }

    public static void set(EConf eConf, boolean bl) {
        WorkFileSettings.s_oInstance.m_oConfiguration.set(eConf.toString(), bl);
    }

    public static void xmlizeConfiguration(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        s_oInstance.xmlize(cSimpleXMLStream);
    }

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        new CConfigFileXMLizer(this.m_oConfiguration, XML_TAG_NAME).xmlize(cSimpleXMLStream);
    }

    private static class CConfigFileXMLizer
    implements IXMLizable {
        private final ConfigFile m_oConfigFile;
        private final String m_strRootName;

        public CConfigFileXMLizer(ConfigFile configFile, String string) {
            this.m_oConfigFile = configFile;
            this.m_strRootName = string;
        }

        @Override
        public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
            ArrayList<String> arrayList = new ArrayList<String>(this.m_oConfigFile.size());
            for (String string : this.m_oConfigFile) {
                arrayList.add(string);
            }
            Collections.sort(arrayList);
            cSimpleXMLStream.startElement(this.m_strRootName);
            for (String string : arrayList) {
                cSimpleXMLStream.startElement(WorkFileSettings.XML_ENTRY_NAME);
                cSimpleXMLStream.addAttribute(WorkFileSettings.XML_ATTRIBUTE_KEY, string);
                cSimpleXMLStream.addAttribute(WorkFileSettings.XML_ATTRIBUTE_VALUE, this.m_oConfigFile.getAsString(string));
                cSimpleXMLStream.endElement(WorkFileSettings.XML_ENTRY_NAME);
            }
            cSimpleXMLStream.endElement(this.m_strRootName);
        }
    }

    private static class CEntryContainer
    extends AChildlessXMLObjectContainer<CEntry<?, ?>> {
        @Override
        protected CEntry<?, ?> createContainedObject(Attributes attributes, int n) {
            String string = attributes.getValue(WorkFileSettings.XML_ATTRIBUTE_KEY);
            String string2 = attributes.getValue(WorkFileSettings.XML_ATTRIBUTE_VALUE);
            EConf eConf = null;
            Object object = null;
            if (string.equals(EConf.SaveViews.name())) {
                eConf = EConf.SaveViews;
                object = new Boolean(string2);
            } else if (string.equals(EConf.ShowSecondRowPerDefault.name())) {
                eConf = EConf.ShowSecondRowPerDefault;
                object = new Boolean(string2);
            } else if (string.equals(EConf.SaveNotAcceptedEfforts.name())) {
                eConf = EConf.SaveNotAcceptedEfforts;
                object = new Boolean(string2);
            } else if (string.equals("DoNotSaveNotAcceptedEfforts")) {
                eConf = EConf.SaveNotAcceptedEfforts;
                object = new Boolean(!Boolean.getBoolean(string2));
            } else if (string.equals(EConf.MinimizeToTray.name())) {
                eConf = EConf.MinimizeToTray;
                object = new Boolean(string2);
            } else if (string.equals("CloseAtX")) {
                eConf = EConf.MinimizeToTray;
                object = string2.equals("HIDE_MAIN_WINDOW") ? Boolean.TRUE : Boolean.FALSE;
            } else if (string.equals(EConf.MakeBackup.name())) {
                eConf = EConf.MakeBackup;
                object = new Boolean(string2);
            } else if (string.equals(EConf.ConfirmQuickSplit.name())) {
                eConf = EConf.ConfirmQuickSplit;
                object = new Boolean(string2);
            } else {
                for (EConf eConf2 : EConf.values()) {
                    if (!eConf2.name().equals(string)) continue;
                    eConf = eConf2;
                    object = string2;
                    break;
                }
            }
            if (eConf != null) {
                return new CEntry<EConf, Boolean>(eConf, (Boolean)object);
            }
            return null;
        }
    }

    public static class CConfigurationContainer
    extends AXMLObjectContainer<WorkFileSettings> {
        private static final CEntryContainer ENTRY_CONTAINER = new CEntryContainer();

        @Override
        protected WorkFileSettings createContainedObject(Attributes attributes, int n) {
            return s_oInstance;
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (!string.equals(WorkFileSettings.XML_ENTRY_NAME)) {
                return null;
            }
            return ENTRY_CONTAINER;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals(WorkFileSettings.XML_ENTRY_NAME) && object != null) {
                CEntry cEntry = (CEntry)object;
                WorkFileSettings.set((EConf)((Object)cEntry.getKey()), cEntry.getValue().toString());
            }
        }
    }

    public static enum EConf {
        SaveViews,
        ShowSecondRowPerDefault,
        SaveNotAcceptedEfforts,
        LastExportPath,
        MinimizeToTray,
        MakeBackup,
        ConfirmQuickSplit,
        ExportCSVDurationFormat;

    }
}

