/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.resources;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.exceptions.CFredAbortException;
import com.mayastudios.fred.client.filehandling.xml.CSimpleDefaultHandler;
import com.mayastudios.fred.client.filehandling.xml.XMLFileHandling;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class CategoryList {
    private static final String XML_FILE_PATH = "cfg/Categories.xml";
    private static final String XML_SCHEMA_PATH = "schemas/Categories.xsd";
    public static final String XML_ROOT_NAME = "categorylist";
    public static final String XML_ENTRY_NAME = "category";
    public static final String XML_ATTRIBUTE_ID = "id";
    public static final String XML_ATTRIBUTE_NAME = "name";
    public static final String XML_ATTRIBUTE_DESCRIPTION = "description";
    private static final CategoryList INSTANCE = new CategoryList();
    private final CCategory[] mf_oCategories;
    private final HashMap<Integer, CCategory> mf_oCategoryMap;

    private CategoryList() {
        InputStream inputStream = MainController.getResLoader().getResourceStream(XML_FILE_PATH);
        try {
            URL uRL = MainController.getResLoader().getResourceUrlExcpt(XML_SCHEMA_PATH);
            CCategoryHandler cCategoryHandler = new CCategoryHandler();
            XMLFileHandling.processXML(XML_FILE_PATH, inputStream, uRL, cCategoryHandler);
            Vector<CCategory> vector = cCategoryHandler.getCategories();
            this.mf_oCategories = vector.toArray(new CCategory[vector.size()]);
            this.mf_oCategoryMap = new HashMap((int)((double)this.mf_oCategories.length / 0.75) + 1);
            for (CCategory cCategory : this.mf_oCategories) {
                this.mf_oCategoryMap.put(cCategory.getID(), cCategory);
            }
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    public static int getCategoryCount() {
        return CategoryList.INSTANCE.mf_oCategories.length;
    }

    public static CCategory getCategory(int n) {
        return CategoryList.INSTANCE.mf_oCategories[n];
    }

    public static CCategory getCategoryByID(int n) {
        return CategoryList.INSTANCE.mf_oCategoryMap.get(new Integer(n));
    }

    public static CCategory[] getCategories() {
        return CategoryList.INSTANCE.mf_oCategories;
    }

    public static DefaultListModel getCategoriesListModel() {
        DefaultListModel<CCategory> defaultListModel = new DefaultListModel<CCategory>();
        for (CCategory cCategory : CategoryList.INSTANCE.mf_oCategories) {
            defaultListModel.addElement(cCategory);
        }
        return defaultListModel;
    }

    public static DefaultComboBoxModel getCategoriesComboBoxModel() {
        return new DefaultComboBoxModel<CCategory>(CategoryList.getCategories());
    }

    private static class CCategoryHandler
    extends CSimpleDefaultHandler {
        private boolean m_bRootNodeFound = false;
        private final Vector<CCategory> mf_oCategoryVector = new Vector();

        public Vector<CCategory> getCategories() {
            return this.mf_oCategoryVector;
        }

        @Override
        public void startElement(String string, Attributes attributes) {
            if (!this.m_bRootNodeFound && string.equals(CategoryList.XML_ROOT_NAME)) {
                this.m_bRootNodeFound = true;
            } else if (this.m_bRootNodeFound && string.equals(CategoryList.XML_ENTRY_NAME)) {
                CCategory cCategory = new CCategory();
                try {
                    cCategory.m_iID = Integer.parseInt(attributes.getValue(CategoryList.XML_ATTRIBUTE_ID));
                }
                catch (NumberFormatException numberFormatException) {
                    cCategory.m_iID = 0;
                }
                cCategory.m_strName = attributes.getValue(CategoryList.XML_ATTRIBUTE_NAME);
                cCategory.m_strDescription = attributes.getValue(CategoryList.XML_ATTRIBUTE_DESCRIPTION);
                cCategory.m_iIndex = this.mf_oCategoryVector.size();
                cCategory.refreshToString();
                this.mf_oCategoryVector.add(cCategory);
            } else {
                throw new CFredAbortException("Falsches Format der Konfigurationsdatei");
            }
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            throw new CFredAbortException(sAXParseException.getMessage());
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            throw new CFredAbortException(sAXParseException.getMessage());
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            throw new CFredAbortException(sAXParseException.getMessage());
        }
    }

    public static class CCategory {
        int m_iIndex;
        int m_iID;
        String m_strName;
        String m_strDescription;
        private String m_strToString;

        public int getIndex() {
            return this.m_iIndex;
        }

        public int getID() {
            return this.m_iID;
        }

        public String getName() {
            return this.m_strName;
        }

        public String getDescription() {
            return this.m_strDescription;
        }

        public String toString() {
            return this.m_strToString;
        }

        void refreshToString() {
            this.m_strToString = "[" + this.m_iID + "] " + this.m_strName;
        }
    }
}

