/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.resources;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCommandInvoker {
    private final Method mf_oCallbackMethod;
    private static final Logger LOGGER = LoggerFactory.getLogger(CCommandInvoker.class);

    public CCommandInvoker(String string) throws CInvalidMethodException, ClassNotFoundException {
        String[] stringArray = string.split("#");
        if (stringArray.length != 2) {
            throw new CInvalidMethodException("Illegal method name: " + string);
        }
        this.mf_oCallbackMethod = CCommandInvoker._getMethodFromName(Class.forName(stringArray[0]), stringArray[1]);
    }

    public CCommandInvoker(Class<?> clazz, String string) throws CInvalidMethodException {
        this.mf_oCallbackMethod = CCommandInvoker._getMethodFromName(clazz, string);
    }

    public CCommandInvoker(Method method) throws CInvalidMethodException {
        CCommandInvoker._checkMethod(method);
        this.mf_oCallbackMethod = method;
    }

    private static Method _getMethodFromName(Class<?> clazz, String string) throws CInvalidMethodException {
        Method method;
        try {
            method = clazz.getMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CInvalidMethodException("Method " + string + " does not exist.");
        }
        CCommandInvoker._checkMethod(method);
        return method;
    }

    private static void _checkMethod(Method method) throws CInvalidMethodException {
        int n = method.getModifiers();
        if (!Modifier.isPublic(n)) {
            throw new CInvalidMethodException("Method " + method.getName() + " is not public.");
        }
        if (!Modifier.isStatic(n)) {
            throw new CInvalidMethodException("Method " + method.getName() + " is not static.");
        }
    }

    public void invokeMethod() {
        try {
            this.mf_oCallbackMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.error("IllegalAccessException: " + this.mf_oCallbackMethod.getName(), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.error("InvocationTargetException: " + this.mf_oCallbackMethod.getName(), invocationTargetException.getCause());
            if (invocationTargetException.getCause() != null) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
            throw new RuntimeException(invocationTargetException);
        }
    }

    public static class CInvalidMethodException
    extends Exception {
        public CInvalidMethodException(String string) {
            super(string);
        }
    }
}

