/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.model;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.filehandling.CEffortExportCSVSettings;
import com.mayastudios.fred.client.filehandling.objectcontainer.AChildlessXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.objectcontainer.ADummyXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.model.AFilter;
import com.mayastudios.fred.client.model.AReplicateableObjectImpl;
import com.mayastudios.fred.client.model.CColumnModel;
import com.mayastudios.fred.client.model.CPersonImpl;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.model.DefaultTask;
import com.mayastudios.fred.client.model.ObjectFactoryImpl;
import com.mayastudios.fred.client.resources.CategoryList;
import com.mayastudios.fred.client.resources.DataMask;
import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.fred.client.resources.ID;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.resources.StringFunctions;
import com.mayastudios.fred.client.servertuning.IEffortEx;
import de.sopra06.domainmodel.Person;
import de.sopra06.domainmodel.Task;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class CEffortImpl
extends AReplicateableObjectImpl
implements IEffortEx,
IXMLizable,
Comparable<CEffortImpl> {
    public static final char ID_PREFIX = 'E';
    private static final String COMPAREABLE_LEFT_ID = "ECOMPARABLE_LEFT";
    private static final String COMPAREABLE_RIGHT_ID = "ECOMPARABLE_RIGHT";
    public static final String XML_TAG_NAME = "effort";
    private static final String XML_ATT_ID = "id";
    private static final String XML_ATT_BEGIN = "begin";
    private static final String XML_ATT_DURATION = "duration";
    private static final String XML_ATT_PAUSEDURATION = "pause";
    private static final String XML_ATT_DESCRIPTION = "description";
    private static final String XML_ATT_CATEGORY = "category";
    private static final String XML_ATT_PERSON = "person";
    private static final String XML_ATT_IS_APPROVED = "isapproved";
    private static final String XML_ATT_IGNORE_MISTAKES = "ignoremistakes";
    private static final String XML_ATT_IS_REPLICATED = "isreplicated";
    private static final String XML_ATT_ACCEPTED = "eaccepted";
    private static final String XML_COLLISIONS_TAG_NAME = "collisions";
    private static final String XML_COLLISION_TAG_NAME = "collision";
    private static final String XML_COLLISION_ATT_ID = "id";
    private static final boolean DEFAULT_APPROVED = true;
    private static final boolean DEFAULT_IGNORE_MISTAKES = false;
    private static final boolean DEFAULT_REPLICATED = false;
    static final EAccepted DEFAULT_ACCEPTED = EAccepted.Accepted;
    private static final int MILLISECONDS_PER_MINUTE = 60000;
    private static final EAccepted[] EACCEPT_ARRAY = EAccepted.values();
    private static final Logger LOGGER = LoggerFactory.getLogger(CEffortImpl.class);
    private long m_lBeginMilliSeconds;
    private int m_iDuration;
    private int m_iPauseDuration;
    private String m_strDescription = null;
    private CategoryList.CCategory m_oCategory;
    private CTaskImpl m_oTask = null;
    private CPersonImpl m_oPerson = null;
    private boolean m_bApproved = false;
    private HashSet<CEffortImpl> m_oCollidators = null;
    private boolean m_bIgnoreMistakes = false;
    private boolean m_bIsReplicated = false;
    private EAccepted m_eAccepted = EAccepted.NotYetAccepted;
    private short m_shCurrentMask = 0;
    private boolean m_bUpdateStatistic = false;

    CEffortImpl(String string) {
        this.setID(string);
        this.m_lBeginMilliSeconds = -1L;
        this.m_iDuration = -1;
    }

    public static CEffortImpl create() {
        if (!DefaultTask.isSet()) {
            throw new IllegalStateException("Default task is not set.");
        }
        CEffortImpl cEffortImpl = ObjectFactoryImpl.createEffortImpl(ID.createNewID('E'));
        cEffortImpl.setBegin(Calendar.getInstance());
        cEffortImpl.setDuration(0);
        CPersonImpl cPersonImpl = MainController.getInstance().getUser();
        cEffortImpl.setPerson(cPersonImpl);
        CTaskImpl cTaskImpl = DefaultTask.get();
        cEffortImpl.setTask(cTaskImpl);
        if (cTaskImpl.getDefaultCategory() == -1) {
            cEffortImpl.setCategory(CategoryList.getCategory(0));
        } else {
            cEffortImpl.setCategory(cTaskImpl.getDefaultCategory());
        }
        cEffortImpl.setAccepted(EAccepted.Accepted);
        return cEffortImpl;
    }

    public static CEffortImpl createComparableEffort(Calendar calendar, boolean bl) {
        CEffortImpl cEffortImpl = new CEffortImpl(bl ? COMPAREABLE_LEFT_ID : COMPAREABLE_RIGHT_ID);
        cEffortImpl.setBegin(calendar);
        cEffortImpl.setDuration(0);
        cEffortImpl.setPauseDuration(0);
        return cEffortImpl;
    }

    public Calendar getBegin() {
        return DateTime.createCalendar(this.m_lBeginMilliSeconds);
    }

    public void setBegin(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.clear(13);
        calendar2.clear(14);
        this.m_lBeginMilliSeconds = calendar2.getTimeInMillis();
    }

    public Calendar getEnd() {
        return DateTime.getEndDateByDuration(this.m_lBeginMilliSeconds, this.m_iDuration + this.m_iPauseDuration);
    }

    public int getDuration() {
        return this.m_iDuration;
    }

    public void setDuration(int n) {
        if (n >= 0) {
            if (this.updateStatisticNeeded() && this.m_iDuration != n) {
                this.m_oTask.getStatistic().updateFieldValue(1, n - this.m_iDuration);
            }
            this.m_iDuration = n;
        } else {
            LOGGER.error("{}#setDuration: negative Duration: {}", (Object)this.getClass().getName(), (Object)n);
        }
    }

    @Override
    public int getPauseDuration() {
        return this.m_iPauseDuration;
    }

    @Override
    public void setPauseDuration(int n) {
        this.m_iPauseDuration = n;
    }

    public String getDescription() {
        return StringFunctions.readNullString(this.m_strDescription);
    }

    public void setDescription(String string) {
        this.m_strDescription = StringFunctions.storeNullString(string);
    }

    public int getCategory() {
        if (this.m_oCategory == null) {
            return -1;
        }
        return this.m_oCategory.getID();
    }

    public CategoryList.CCategory getCCategory() {
        return this.m_oCategory;
    }

    public void setCategory(int n) {
        this.setCategory(CategoryList.getCategoryByID(n));
    }

    public void setCategory(CategoryList.CCategory cCategory) {
        if (cCategory != null) {
            if (this.updateStatisticNeeded() && this.m_oCategory != cCategory) {
                this.m_oTask.getStatistic().updateEffortsOfCategory(this.m_oCategory, -1);
                this.m_oTask.getStatistic().updateEffortsOfCategory(cCategory, 1);
            }
            this.m_oCategory = cCategory;
        }
    }

    public CTaskImpl getTask() {
        return this.m_oTask;
    }

    public void setTask(Task task) {
        this.m_oTask = (CTaskImpl)task;
    }

    public CProjectImpl getProject() {
        if (this.m_oTask != null) {
            return this.m_oTask.getProject();
        }
        return null;
    }

    public CPersonImpl getPerson() {
        return this.m_oPerson;
    }

    public void setPerson(Person person) {
        if (this.updateStatisticNeeded() && this.m_oPerson != person) {
            this.m_oTask.getStatistic().updateEffortsOfPerson(this.m_oPerson, -1);
            this.m_oTask.getStatistic().updateEffortsOfPerson((CPersonImpl)person, 1);
        }
        this.m_oPerson = (CPersonImpl)person;
    }

    public boolean isApproved() {
        return this.m_bApproved;
    }

    public void setApproved(boolean bl) {
        this.m_bApproved = bl;
        this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 5, bl);
    }

    public boolean isValid() {
        return this.getProject() != null && this.getCCategory() != null;
    }

    public boolean isColliding() {
        return this.getCollisionCount() > 0;
    }

    public int getCollisionCount() {
        if (this.m_oCollidators == null) {
            return 0;
        }
        return this.m_oCollidators.size();
    }

    boolean isOverlapping(CEffortImpl cEffortImpl) {
        if (this._isOverlapping(cEffortImpl)) {
            if (this != cEffortImpl && this.getPerson() != null && this.getPerson() == cEffortImpl.getPerson()) {
                this.addCollidation(cEffortImpl);
                cEffortImpl.addCollidation(this);
            }
            return true;
        }
        return false;
    }

    boolean containsCollidator(CEffortImpl cEffortImpl) {
        return this.isColliding() && this.m_oCollidators.contains(cEffortImpl);
    }

    boolean hasMoreOverlappers(CEffortImpl cEffortImpl) {
        Iterator<CEffortImpl> iterator = this.m_oCollidators.iterator();
        while (iterator.hasNext()) {
            if (!cEffortImpl._isOverlapping(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean _isOverlapping(CEffortImpl cEffortImpl) {
        long l = this.m_lBeginMilliSeconds + (long)((this.m_iDuration + this.m_iPauseDuration) * 60000);
        long l2 = cEffortImpl.m_lBeginMilliSeconds + (long)((cEffortImpl.m_iDuration + cEffortImpl.m_iPauseDuration) * 60000);
        if (this.m_lBeginMilliSeconds == l || cEffortImpl.m_lBeginMilliSeconds == l2) {
            return false;
        }
        return this.m_lBeginMilliSeconds <= cEffortImpl.m_lBeginMilliSeconds && l > cEffortImpl.m_lBeginMilliSeconds || this.m_lBeginMilliSeconds >= cEffortImpl.m_lBeginMilliSeconds && this.m_lBeginMilliSeconds < l2;
    }

    void addCollidation(CEffortImpl cEffortImpl) {
        if (this.m_oCollidators == null) {
            this.m_oCollidators = new HashSet(11);
        }
        this.m_oCollidators.add(cEffortImpl);
        this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 4, true);
    }

    public Calendar getEarliestColidersStart() {
        Calendar calendar = this.getBegin();
        Iterator<CEffortImpl> iterator = this.m_oCollidators.iterator();
        while (iterator.hasNext()) {
            Calendar calendar2 = iterator.next().getBegin();
            if (!calendar2.before(calendar)) continue;
            calendar = calendar2;
        }
        return calendar;
    }

    public Calendar getLatestColidersEnd() {
        Calendar calendar = this.getEnd();
        Iterator<CEffortImpl> iterator = this.m_oCollidators.iterator();
        while (iterator.hasNext()) {
            Calendar calendar2 = iterator.next().getEnd();
            if (!calendar2.after(calendar)) continue;
            calendar = calendar2;
        }
        return calendar;
    }

    public void removeAllCollidations() {
        if (this.m_oCollidators != null) {
            Iterator<CEffortImpl> iterator = this.m_oCollidators.iterator();
            while (iterator.hasNext()) {
                iterator.next()._removeCollidation(this);
            }
            this.m_oCollidators = null;
            this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 4, false);
        }
    }

    private void _removeCollidation(CEffortImpl cEffortImpl) {
        if (cEffortImpl != null) {
            if (this.m_oCollidators != null) {
                this.m_oCollidators.remove(cEffortImpl);
                if (this.m_oCollidators.size() == 0) {
                    this.m_oCollidators = null;
                    this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 4, false);
                }
            } else {
                LOGGER.error("{}#_removeCollidation: this.m_oColladations == null", (Object)this.getClass().getName());
            }
        }
    }

    public boolean ignoresMistake() {
        return this.m_bIgnoreMistakes;
    }

    public void setIgnoreMistake(boolean bl) {
        this.m_bIgnoreMistakes = bl;
        this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 3, bl);
    }

    public boolean isReplicated() {
        return this.m_bIsReplicated;
    }

    public void setReplicated(boolean bl) {
        if (this.updateStatisticNeeded() && this.m_bIsReplicated != bl) {
            if (bl) {
                this.m_oTask.getStatistic().updateFieldValue(2, 1);
            } else {
                this.m_oTask.getStatistic().updateFieldValue(2, -1);
            }
        }
        this.m_bIsReplicated = bl;
        this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 2, bl);
    }

    public EAccepted getAccepted() {
        return this.m_eAccepted;
    }

    public void setAccepted(int n) {
        this.setAccepted(CEffortImpl.getEAcceptedByIndex(n));
    }

    public void setAccepted(EAccepted eAccepted) {
        if (this.m_eAccepted != eAccepted) {
            if (this.updateStatisticNeeded()) {
                if (this.m_eAccepted == EAccepted.Accepted) {
                    this.m_oTask.getStatistic().updateFieldValue(3, -1);
                } else if (this.m_eAccepted == EAccepted.NotAccepted) {
                    this.m_oTask.getStatistic().updateFieldValue(4, -1);
                }
                if (eAccepted == EAccepted.Accepted) {
                    this.m_oTask.getStatistic().updateFieldValue(3, 1);
                } else if (eAccepted == EAccepted.NotAccepted) {
                    this.m_oTask.getStatistic().updateFieldValue(4, 1);
                }
            }
            this.m_eAccepted = eAccepted;
            if (eAccepted == EAccepted.NotYetAccepted) {
                this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 1, false);
                this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 0, false);
            } else {
                this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 1, true);
                if (eAccepted == EAccepted.Accepted) {
                    this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 0, true);
                } else if (eAccepted == EAccepted.NotAccepted) {
                    this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 0, false);
                }
            }
        }
    }

    public boolean isUserOwner() {
        return MainController.getInstance().getUser() == this.m_oPerson;
    }

    public Object getContent(CColumnModel.EColumnType eColumnType) {
        switch (eColumnType) {
            case StartDate: {
                return DateTime.getDateString(this.getBegin());
            }
            case StartTime: {
                return DateTime.getTimeString(this.getBegin());
            }
            case EndDate: {
                return DateTime.getDateString(this.getEnd());
            }
            case EndTime: {
                return DateTime.getTimeString(this.getEnd());
            }
            case StartEndTime: {
                return DateTime.getTimeString(this.getBegin()) + " - " + DateTime.getTimeString(this.getEnd());
            }
            case StartDayOfWeek: {
                return DateTime.getDayOfWeekString(this.getBegin());
            }
            case OverallDuration: {
                return DateTime.getDurationString(this.m_iDuration + this.m_iPauseDuration, false);
            }
            case WorkDuration: {
                return DateTime.getDurationString(this.m_iDuration, false);
            }
            case PauseDuration: {
                return DateTime.getDurationString(this.m_iPauseDuration, false);
            }
            case Project: {
                return this.getProject().getName();
            }
            case Task: {
                return this.m_oTask.getName();
            }
            case TaskShort: {
                return this.m_oTask.getShortName();
            }
            case CategoryName: {
                return this.m_oCategory.getName();
            }
            case CategoryID: {
                return String.valueOf(this.getCategory());
            }
            case PersonFullName: {
                return this.m_oPerson.getFullName();
            }
            case PersonShortname: {
                return this.m_oPerson.getInitials();
            }
            case PersonID: {
                return this.m_oPerson.getID();
            }
            case Description: {
                return this.getDescription();
            }
            case Approved: {
                return new Boolean(this.isApproved());
            }
            case Collisions: {
                return new Boolean(this.isColliding());
            }
            case IgnoreCollisions: {
                return new Boolean(this.m_bIgnoreMistakes);
            }
            case Replicated: {
                return new Boolean(this.m_bIsReplicated);
            }
            case Accepted: {
                return this.getAccepted().getDescription();
            }
        }
        throw new IllegalStateException("unhandled column type");
    }

    public void writeContentForExport(Writer writer, CColumnModel.EColumnType eColumnType, boolean bl, CEffortExportCSVSettings cEffortExportCSVSettings) throws IOException {
        String string;
        block27: {
            block26: {
                switch (eColumnType) {
                    case Approved: {
                        StringFunctions.writeBoolean(writer, this.isApproved());
                        return;
                    }
                    case Collisions: {
                        StringFunctions.writeBoolean(writer, this.isColliding());
                        return;
                    }
                    case IgnoreCollisions: {
                        StringFunctions.writeBoolean(writer, this.ignoresMistake());
                        return;
                    }
                    case Replicated: {
                        StringFunctions.writeBoolean(writer, this.isReplicated());
                        return;
                    }
                }
                string = this.getContent(eColumnType).toString();
                if (string == null) {
                    LOGGER.error("{}#getContentForExport: unknown column: {}", (Object)this.getClass().getName(), (Object)eColumnType);
                    return;
                }
                CEffortExportCSVSettings.IExportDurationFormat iExportDurationFormat = cEffortExportCSVSettings != null ? cEffortExportCSVSettings.getExportDurationFormat() : null;
                if (!bl) break block26;
                switch (eColumnType) {
                    case OverallDuration: {
                        if (iExportDurationFormat != null) {
                            string = iExportDurationFormat.formatDuration(this.m_iDuration + this.m_iPauseDuration);
                            break;
                        }
                        break block27;
                    }
                    case WorkDuration: {
                        if (iExportDurationFormat != null) {
                            string = iExportDurationFormat.formatDuration(this.m_iDuration);
                            break;
                        }
                        break block27;
                    }
                    case PauseDuration: {
                        if (iExportDurationFormat != null) {
                            string = iExportDurationFormat.formatDuration(this.m_iPauseDuration);
                            break;
                        }
                        break block27;
                    }
                    case StartDayOfWeek: {
                        StringFunctions.writeForCSVCell(writer, string);
                        return;
                    }
                    case Project: {
                        StringFunctions.writeForCSVCell(writer, string);
                        return;
                    }
                    case Task: {
                        StringFunctions.writeForCSVCell(writer, string);
                        return;
                    }
                    case TaskShort: {
                        StringFunctions.writeForCSVCell(writer, string);
                        return;
                    }
                    case CategoryName: {
                        StringFunctions.writeForCSVCell(writer, string);
                        return;
                    }
                    case PersonFullName: {
                        StringFunctions.writeForCSVCell(writer, string);
                        return;
                    }
                    case PersonShortname: {
                        StringFunctions.writeForCSVCell(writer, string);
                        return;
                    }
                    case PersonID: {
                        StringFunctions.writeForCSVCell(writer, string);
                        return;
                    }
                    case Description: {
                        StringFunctions.writeForCSVCell(writer, string);
                        return;
                    }
                    case Accepted: {
                        StringFunctions.writeForCSVCell(writer, string);
                        return;
                    }
                }
                break block27;
            }
            if (eColumnType == CColumnModel.EColumnType.Description) {
                StringFunctions.writeCommentForHTML(writer, string);
                return;
            }
        }
        writer.write(string);
    }

    public boolean passesFilterTasks(AFilter aFilter) {
        return aFilter.containsTask(this.m_oTask);
    }

    public boolean passesFilterCategories(AFilter aFilter) {
        return aFilter.containsMappedCategory(this.m_oCategory, this.getProject());
    }

    public boolean passesFilterFull(AFilter aFilter) {
        if (aFilter.useThisFilter()) {
            return aFilter.containsTask(this.m_oTask) && aFilter.containsMappedCategory(this.m_oCategory, this.getProject()) && aFilter.containsPerson(this.m_oPerson) && aFilter.isDurationIncluded(this.m_lBeginMilliSeconds, this.m_lBeginMilliSeconds + (long)this.m_iDuration * 60000L) && aFilter.isCurrentMaskIncluded(this.m_shCurrentMask) && aFilter.containsSearchString(this.getDescription());
        }
        if (aFilter instanceof AFilter.CTasksInTreeFilter) {
            return this.passesFilterTasks(aFilter);
        }
        return this.passesFilterCategories(aFilter);
    }

    public boolean passesFilterColliding(AFilter aFilter) {
        return this.passesFilterFull(aFilter) && aFilter.isReferenceColidingWith(this);
    }

    boolean updateStatisticNeeded() {
        return this.m_bUpdateStatistic;
    }

    void setUpdateStatistic(boolean bl) {
        this.m_bUpdateStatistic = bl;
    }

    short getCurrentMask() {
        return this.m_shCurrentMask;
    }

    private void _recalcCurrentMask() {
        this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 5, this.isApproved());
        this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 4, this.isColliding());
        this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 3, this.m_bIgnoreMistakes);
        this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 2, this.m_bIsReplicated);
        EAccepted eAccepted = this.getAccepted();
        if (eAccepted == EAccepted.NotYetAccepted) {
            this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 1, false);
            this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 0, false);
        } else {
            this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 1, true);
            if (eAccepted == EAccepted.Accepted) {
                this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 0, true);
            } else if (eAccepted == EAccepted.NotAccepted) {
                this.m_shCurrentMask = (short)DataMask.setBit(this.m_shCurrentMask, 0, false);
            }
        }
    }

    @Override
    public int compareTo(CEffortImpl cEffortImpl) {
        int n;
        if (this == cEffortImpl) {
            return 0;
        }
        int n2 = this.m_lBeginMilliSeconds < cEffortImpl.m_lBeginMilliSeconds ? -1 : (n = this.m_lBeginMilliSeconds == cEffortImpl.m_lBeginMilliSeconds ? 0 : 1);
        if (n == 0) {
            if (this.getID() == COMPAREABLE_LEFT_ID) {
                return cEffortImpl.getID() == COMPAREABLE_LEFT_ID ? 0 : -1;
            }
            if (this.getID() == COMPAREABLE_RIGHT_ID) {
                return cEffortImpl.getID() == COMPAREABLE_RIGHT_ID ? 0 : 1;
            }
            if (cEffortImpl.getID() == COMPAREABLE_LEFT_ID) {
                return 1;
            }
            if (cEffortImpl.getID() == COMPAREABLE_RIGHT_ID) {
                return -1;
            }
            long l = this.m_iDuration + this.m_iPauseDuration;
            long l2 = cEffortImpl.m_iDuration + cEffortImpl.m_iPauseDuration;
            int n3 = l < l2 ? -1 : (n = l == l2 ? 0 : 1);
            if (n != 0) {
                return n;
            }
            n = this.getID().compareTo(cEffortImpl.getID());
            if (n == 0) {
                throw new IllegalStateException("Two different efforts have the same local id.");
            }
            return n;
        }
        return n;
    }

    public String toString() {
        return this.getContent(CColumnModel.EColumnType.StartDate) + " " + this.getContent(CColumnModel.EColumnType.StartTime) + " > " + this.getContent(CColumnModel.EColumnType.EndDate) + " " + this.getContent(CColumnModel.EColumnType.EndTime) + "\n" + this.m_oPerson + "\n" + Integer.toBinaryString(this.m_shCurrentMask);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        cSimpleXMLStream.startElement(XML_TAG_NAME);
        cSimpleXMLStream.addAttribute("id", String.valueOf(this.getID()));
        cSimpleXMLStream.addAttribute(XML_ATT_BEGIN, DateTime.getXMLDateTime(this.getBegin()));
        cSimpleXMLStream.addAttribute(XML_ATT_DURATION, String.valueOf(this.getDuration()));
        cSimpleXMLStream.addAttribute(XML_ATT_PAUSEDURATION, String.valueOf(this.getPauseDuration()));
        cSimpleXMLStream.addAttribute(XML_ATT_DESCRIPTION, this.getDescription());
        cSimpleXMLStream.addAttribute(XML_ATT_CATEGORY, String.valueOf(this.getCategory()));
        cSimpleXMLStream.addAttribute(XML_ATT_PERSON, this.getPerson().getID());
        if (!this.isApproved()) {
            cSimpleXMLStream.addAttribute(XML_ATT_IS_APPROVED, String.valueOf(this.isApproved()));
        }
        if (this.ignoresMistake()) {
            cSimpleXMLStream.addAttribute(XML_ATT_IGNORE_MISTAKES, String.valueOf(this.ignoresMistake()));
        }
        if (this.isReplicated()) {
            cSimpleXMLStream.addAttribute(XML_ATT_IS_REPLICATED, String.valueOf(this.isReplicated()));
        }
        if (this.getAccepted() != DEFAULT_ACCEPTED) {
            cSimpleXMLStream.addAttribute(XML_ATT_ACCEPTED, this.getAccepted().toString());
        }
        if (this.isColliding()) {
            cSimpleXMLStream.startElement(XML_COLLISIONS_TAG_NAME);
            Iterator<CEffortImpl> iterator = this.m_oCollidators.iterator();
            while (iterator.hasNext()) {
                cSimpleXMLStream.startElement(XML_COLLISION_TAG_NAME);
                cSimpleXMLStream.addAttribute("id", iterator.next().getID());
                cSimpleXMLStream.endElement(XML_COLLISION_TAG_NAME);
            }
            cSimpleXMLStream.endElement(XML_COLLISIONS_TAG_NAME);
        }
        cSimpleXMLStream.endElement(XML_TAG_NAME);
    }

    public static DefaultComboBoxModel getEAcceptedComboBoxModel() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (EAccepted eAccepted : EACCEPT_ARRAY) {
            defaultComboBoxModel.addElement(eAccepted.getDescription());
        }
        return defaultComboBoxModel;
    }

    public static EAccepted getEAcceptedByIndex(int n) {
        return EACCEPT_ARRAY[n];
    }

    public static enum EAccepted {
        Accepted,
        NotAccepted,
        NotYetAccepted;

        private final String m_strDescription = Labels.get("EACCEPTED_" + this.name(), new Object[0]);

        public String getDescription() {
            return this.m_strDescription;
        }
    }

    private static class CCollisionStoreContainer
    extends AChildlessXMLObjectContainer<CEffortImpl> {
        @Override
        protected CEffortImpl createContainedObject(Attributes attributes, int n) {
            String string = attributes.getValue("id");
            return ObjectFactoryImpl.createEffortImpl(string);
        }
    }

    private static class CCollisionsStoreContainer
    extends ADummyXMLObjectContainer {
        private static final CCollisionStoreContainer COLLISION_CONTAINER = new CCollisionStoreContainer();
        private final CEffortImpl m_oThisEffort;

        CCollisionsStoreContainer(CEffortImpl cEffortImpl) {
            this.m_oThisEffort = cEffortImpl;
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals(CEffortImpl.XML_COLLISION_TAG_NAME)) {
                return COLLISION_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals(CEffortImpl.XML_COLLISION_TAG_NAME)) {
                this.m_oThisEffort.addCollidation((CEffortImpl)object);
            }
        }
    }

    public static class CEffortStoreContainer
    extends AXMLObjectContainer<CEffortImpl> {
        @Override
        protected CEffortImpl createContainedObject(Attributes attributes, int n) {
            String string = attributes.getValue("id");
            CEffortImpl cEffortImpl = ObjectFactoryImpl.createEffortImpl(string);
            cEffortImpl.setBegin(DateTime.parseXMLDateTime(attributes.getValue(CEffortImpl.XML_ATT_BEGIN)));
            cEffortImpl.setDuration(Integer.parseInt(attributes.getValue(CEffortImpl.XML_ATT_DURATION)));
            if (n >= 2) {
                cEffortImpl.setPauseDuration(Integer.parseInt(attributes.getValue(CEffortImpl.XML_ATT_PAUSEDURATION)));
            } else {
                cEffortImpl.setPauseDuration(0);
            }
            cEffortImpl.setDescription(attributes.getValue(CEffortImpl.XML_ATT_DESCRIPTION));
            cEffortImpl.setCategory(Integer.parseInt(attributes.getValue(CEffortImpl.XML_ATT_CATEGORY)));
            CPersonImpl cPersonImpl = ObjectFactoryImpl.createPersonImpl(attributes.getValue(CEffortImpl.XML_ATT_PERSON));
            cEffortImpl.setPerson(cPersonImpl);
            String string2 = attributes.getValue(CEffortImpl.XML_ATT_IS_APPROVED);
            if (string2 == null) {
                cEffortImpl.setApproved(true);
            } else {
                cEffortImpl.setApproved(Boolean.parseBoolean(string2));
            }
            String string3 = attributes.getValue(CEffortImpl.XML_ATT_IGNORE_MISTAKES);
            if (string3 == null) {
                cEffortImpl.setIgnoreMistake(false);
            } else {
                cEffortImpl.setIgnoreMistake(Boolean.parseBoolean(string3));
            }
            String string4 = attributes.getValue(CEffortImpl.XML_ATT_IS_REPLICATED);
            if (string4 == null) {
                cEffortImpl.setReplicated(false);
            } else {
                cEffortImpl.setReplicated(Boolean.parseBoolean(string4));
            }
            String string5 = attributes.getValue(CEffortImpl.XML_ATT_ACCEPTED);
            if (string5 == null) {
                cEffortImpl.setAccepted(DEFAULT_ACCEPTED);
            } else {
                cEffortImpl.setAccepted(EAccepted.valueOf(string5));
            }
            return cEffortImpl;
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (CEffortImpl.XML_COLLISIONS_TAG_NAME.equals(string)) {
                return new CCollisionsStoreContainer((CEffortImpl)this.m_oObject);
            }
            return null;
        }
    }
}

