/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.model;

import com.mayastudios.fred.client.exceptions.CModelException;
import com.mayastudios.fred.client.filehandling.objectcontainer.AChildlessXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.model.CColumnModel;
import javax.swing.table.TableColumn;
import org.xml.sax.Attributes;

public class CColumn
extends TableColumn
implements IXMLizable,
Cloneable {
    public static final String XML_TAG_NAME = "column";
    private static final String XML_ATT_ENUM_NAME = "ecolumnname";
    private static final String XML_ATT_WIDTH = "width";
    private CColumnModel.EColumnType m_eColumn;

    public CColumn(CColumnModel.EColumnType eColumnType) {
        this(eColumnType, eColumnType.getDefaultColumnWidth());
    }

    public CColumn(CColumnModel.EColumnType eColumnType, int n) {
        this.m_eColumn = eColumnType;
        super.setHeaderValue((Object)this.m_eColumn);
        super.setModelIndex(this.m_eColumn.ordinal());
        super.setIdentifier((Object)eColumnType);
        super.setPreferredWidth(n);
    }

    public CColumnModel.EColumnType getColumnType() {
        return this.m_eColumn;
    }

    public CColumn clone() {
        CColumn cColumn = new CColumn(this.getColumnType());
        cColumn.setPreferredWidth(super.getWidth());
        return cColumn;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CColumn)) {
            return false;
        }
        return this.m_eColumn.equals((Object)((CColumn)object).m_eColumn);
    }

    public String toString() {
        return this.m_eColumn.getDescription();
    }

    public String getTooltip() {
        return this.m_eColumn.getTooltipText();
    }

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        cSimpleXMLStream.startElement(XML_TAG_NAME);
        cSimpleXMLStream.addAttribute(XML_ATT_ENUM_NAME, this.m_eColumn.name());
        cSimpleXMLStream.addAttribute(XML_ATT_WIDTH, String.valueOf(super.getWidth()));
        cSimpleXMLStream.endElement(XML_TAG_NAME);
    }

    public static class CColumnContainer
    extends AChildlessXMLObjectContainer<CColumn> {
        @Override
        protected CColumn createContainedObject(Attributes attributes, int n) throws CModelException {
            CColumnModel.EColumnType eColumnType;
            String string = attributes.getValue(CColumn.XML_ATT_ENUM_NAME);
            if ("Duration".equals(string)) {
                eColumnType = CColumnModel.EColumnType.WorkDuration;
            } else {
                try {
                    eColumnType = CColumnModel.EColumnType.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CModelException("Invalid enum name: " + string + "\n");
                }
            }
            int n2 = Integer.parseInt(attributes.getValue(CColumn.XML_ATT_WIDTH));
            return new CColumn(eColumnType, n2);
        }
    }
}

