/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.filehandling.xml;

import com.mayastudios.fred.client.exceptions.CModelException;
import com.mayastudios.mscl.CSortedLinkedList;
import java.util.ListIterator;

public class CVersionedXMLElement {
    private final CSortedLinkedList<CElement> m_oElementList = new CSortedLinkedList(false);

    public CVersionedXMLElement(String string, int n) {
        this.add(string, n);
    }

    public CVersionedXMLElement add(String string, int n) {
        this.m_oElementList.add((Comparable)new CElement(string, n));
        return this;
    }

    public String getName(int n) throws CModelException {
        ListIterator listIterator = this.m_oElementList.listIterator();
        String string = null;
        while (listIterator.hasNext()) {
            CElement cElement = (CElement)listIterator.next();
            if (cElement.m_iVersion > n) break;
            string = cElement.m_strElementName;
        }
        if (string == null) {
            throw new CModelException("No element name belongs to this version!");
        }
        return string;
    }

    public String getNewestName() {
        return ((CElement)this.m_oElementList.getLast()).m_strElementName;
    }

    private static class CElement
    implements Comparable<CElement> {
        final String m_strElementName;
        final int m_iVersion;

        CElement(String string, int n) {
            this.m_strElementName = string;
            this.m_iVersion = n;
        }

        @Override
        public int compareTo(CElement cElement) {
            if (this.m_iVersion < cElement.m_iVersion) {
                return -1;
            }
            if (this.m_iVersion > cElement.m_iVersion) {
                return 1;
            }
            return 0;
        }
    }
}

