/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.filehandling.xml;

import com.mayastudios.fred.client.filehandling.COutputFile;
import java.io.IOException;
import java.io.Writer;
import org.jibx.runtime.ICharacterEscaper;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.GenericXMLWriter;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UTF8Escaper;

public class CSimpleXMLStream {
    public static final String XML_ENCODING = "UTF-8";
    public static final String USED_LINE_SEPERATOR = "\r\n";
    private COutputFile m_oOutputFile;
    private MarshallingContext m_marshallingContext;
    private Writer m_oWriter;

    public CSimpleXMLStream(COutputFile cOutputFile, int n, Writer writer) {
        this.m_oOutputFile = cOutputFile;
        this.m_marshallingContext = new MarshallingContext(new String[0], new String[0], new String[]{"", "http://www.w3.org/XML/1998/namespace"}, null);
        CustomXMLWriter customXMLWriter = new CustomXMLWriter();
        customXMLWriter.setIndentSpaces(n, "\n", ' ');
        this.m_marshallingContext.setXmlWriter((IXMLWriter)customXMLWriter);
        this.m_oWriter = writer;
        this.m_marshallingContext.setOutput(writer, (ICharacterEscaper)new CustomCharacterEscaper());
    }

    public long getOutputFilePosition() {
        return this.m_oOutputFile.getFilePosition();
    }

    public Writer getWriter() {
        return this.m_oWriter;
    }

    public void flushWriter() throws IOException {
        if (this.m_oWriter != null) {
            this.m_marshallingContext.getXmlWriter().flush();
            this.m_oWriter.flush();
        }
    }

    public void startElement(String string) throws XmlWriteException {
        try {
            this.m_marshallingContext.startTagAttributes(0, string);
        }
        catch (JiBXException jiBXException) {
            throw new XmlWriteException(jiBXException.getMessage(), jiBXException);
        }
    }

    public void addAttribute(String string, String string2) throws XmlWriteException {
        try {
            this.m_marshallingContext.attribute(0, string, string2);
        }
        catch (JiBXException jiBXException) {
            throw new XmlWriteException(jiBXException.getMessage(), jiBXException);
        }
    }

    public void endElement(String string) throws XmlWriteException {
        try {
            this.m_marshallingContext.endTag(0, string);
        }
        catch (JiBXException jiBXException) {
            throw new XmlWriteException(jiBXException.getMessage(), jiBXException);
        }
    }

    public void comment(String string) throws XmlWriteException {
        try {
            this.m_marshallingContext.getXmlWriter().writeComment(string);
        }
        catch (IOException iOException) {
            throw new XmlWriteException(iOException.getMessage(), iOException);
        }
    }

    public void startDocument() throws XmlWriteException {
        try {
            this.m_marshallingContext.startDocument(XML_ENCODING, Boolean.valueOf(true));
        }
        catch (JiBXException jiBXException) {
            throw new XmlWriteException(jiBXException.getMessage(), jiBXException);
        }
    }

    public void endDocument() throws XmlWriteException {
        try {
            this.m_marshallingContext.endDocument();
        }
        catch (JiBXException jiBXException) {
            throw new XmlWriteException(jiBXException.getMessage(), jiBXException);
        }
    }

    public void indent(int n) {
        ((CustomXMLWriter)this.m_marshallingContext.getXmlWriter()).incrementIndent(n);
    }

    public static class XmlWriteException
    extends Exception {
        public XmlWriteException(String string) {
            super(string);
        }

        public XmlWriteException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    private static class CustomCharacterEscaper
    implements ICharacterEscaper {
        private UTF8Escaper m_delegateEscaper = (UTF8Escaper)UTF8Escaper.getInstance();

        private CustomCharacterEscaper() {
        }

        public void writeAttribute(String string, Writer writer) throws IOException {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\"') {
                    writer.write(string, n, i - n);
                    n = i + 1;
                    writer.write("&quot;");
                    continue;
                }
                if (c == '&') {
                    writer.write(string, n, i - n);
                    n = i + 1;
                    writer.write("&amp;");
                    continue;
                }
                if (c == '<') {
                    writer.write(string, n, i - n);
                    n = i + 1;
                    writer.write("&lt;");
                    continue;
                }
                if (c == '>') {
                    writer.write(string, n, i - n);
                    n = i + 1;
                    writer.write("&gt;");
                    continue;
                }
                if (c < ' ') {
                    writer.write(string, n, i - n);
                    n = i + 1;
                    writer.write("&#" + Integer.toString(c) + ";");
                    continue;
                }
                if (c <= '\ud7ff' || c >= '\ue000' && c != '\ufffe' && c != '\uffff' && c <= '\u10ffff') continue;
                throw new IOException("Illegal character code 0x" + Integer.toHexString(c) + " in attribute value text");
            }
            writer.write(string, n, string.length() - n);
        }

        public void writeCData(String string, Writer writer) throws IOException {
            this.m_delegateEscaper.writeCData(string, writer);
        }

        public void writeContent(String string, Writer writer) throws IOException {
            this.m_delegateEscaper.writeContent(string, writer);
        }
    }

    private static class CustomXMLWriter
    extends GenericXMLWriter {
        public CustomXMLWriter() {
            super(new String[]{"", "http://www.w3.org/XML/1998/namespace"});
        }

        public void incrementIndent(int n) {
            for (int i = 0; i < n; ++i) {
                this.incrementNesting();
            }
        }
    }
}

