/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.filehandling;

import com.mayastudios.fred.client.filehandling.CEffortExportCSVSettings;
import com.mayastudios.fred.client.filehandling.CSSTemplate;
import com.mayastudios.fred.client.model.CColumnModel;
import com.mayastudios.fred.client.model.CEffortImpl;
import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.fred.client.resources.Labels;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Export {
    private static final String ODD_ROW_CSS_CLASS = "oddRow";
    private static final String EVEN_ROW_CSS_CLASS = "evenRow";
    private static final float HTML_COLUMN_WIDTH_FACTOR = 1.5f;
    private static final Charset CSV_CHARSET = Charset.forName("ISO8859_1");
    private static final int CSV_BUFFER_SIZE = 8192;
    private static final char CSV_LINE_SEPARATOR = '\n';
    private static final char CSV_SEPARATOR = ';';
    private static final String HTML_TITLE = Labels.get("EXPORT_HTML_TITLE", new Object[0]);
    private static final Charset HTML_CHARSET = Charset.forName("ISO8859_15");
    private static final int HTML_BUFFER_SIZE = 8192;
    private static final char[] HTML_TR_OPEN_ODD = " <tr class=\"oddRow\">\n".toCharArray();
    private static final char[] HTML_TR_OPEN_EVEN = " <tr class=\"evenRow\">\n".toCharArray();
    private static final char[] HTML_TR_CLOSE = " </tr>\n".toCharArray();
    private static final char[] HTML_TD_OPEN = "  <td>".toCharArray();
    private static final char[] HTML_TD_CLOSE = "</td>\n".toCharArray();
    private static final Logger LOGGER = LoggerFactory.getLogger(Export.class);

    public static boolean exportToCSV(String string, Collection<CEffortImpl> collection, Vector<CColumnModel.EColumnType> vector, CEffortExportCSVSettings cEffortExportCSVSettings) {
        File file = null;
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        Iterator<CEffortImpl> iterator = null;
        Enumeration<CColumnModel.EColumnType> enumeration = null;
        CEffortImpl cEffortImpl2 = null;
        file = new File(string);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, CSV_CHARSET);
            bufferedWriter = new BufferedWriter(outputStreamWriter, 8192);
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                bufferedWriter.write("\"");
                bufferedWriter.write(enumeration.nextElement().getDescription());
                bufferedWriter.write("\"");
                bufferedWriter.write(59);
            }
            bufferedWriter.write(10);
            bufferedWriter.flush();
            for (CEffortImpl cEffortImpl2 : collection) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    cEffortImpl2.writeContentForExport(bufferedWriter, enumeration.nextElement(), true, cEffortExportCSVSettings);
                    bufferedWriter.write(59);
                }
                bufferedWriter.write(10);
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            return true;
        }
        catch (IOException iOException) {
            LOGGER.warn("Fehler beim Schreiben in CSV.");
            return false;
        }
    }

    public static boolean exportToHTML(String string, Collection<CEffortImpl> collection, Vector<CColumnModel.EColumnType> vector) {
        File file = null;
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        Iterator<CEffortImpl> iterator = null;
        Enumeration<CColumnModel.EColumnType> enumeration = null;
        CEffortImpl cEffortImpl = null;
        file = new File(string);
        try {
            int n;
            if (!file.exists()) {
                file.createNewFile();
            }
            fileOutputStream = new FileOutputStream(string);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, HTML_CHARSET);
            bufferedWriter = new BufferedWriter(outputStreamWriter, 8192);
            bufferedWriter.write("<html>\n");
            bufferedWriter.write("<head>\n");
            bufferedWriter.write("<title>" + HTML_TITLE + " - " + DateTime.getCurrentDate() + "</title>\n");
            String string2 = CSSTemplate.getTemplate();
            if (string2 != null && string2.length() > 0) {
                bufferedWriter.write(string2 + "\n");
            }
            bufferedWriter.write("</head>\n");
            bufferedWriter.write("<body>\n");
            int n2 = 0;
            for (n = 0; n < vector.size(); ++n) {
                n2 += vector.get(n).getDefaultColumnWidth();
            }
            n2 = (int)((float)n2 * 1.5f);
            bufferedWriter.write("<table cellspacing = \"0\" width=\"" + n2 + "\">\n");
            bufferedWriter.write("<caption>Datum: " + DateTime.getCurrentDate() + " Uhrzeit: " + DateTime.getCurrentTime() + " " + "</caption>\n");
            bufferedWriter.write(" <colgroup>\n");
            for (n = 0; n < vector.size(); ++n) {
                int n3 = (int)((float)vector.get(n).getDefaultColumnWidth() * 1.5f);
                bufferedWriter.write("  <col width = \"" + n3 + "\" " + "class=\"col_" + vector.get(n).toString() + "\" />\n");
            }
            bufferedWriter.write(" </colgroup>\n\n");
            bufferedWriter.write(" <thead>\n  <tr>\n");
            for (n = 0; n < vector.size(); ++n) {
                bufferedWriter.write("  <th>");
                bufferedWriter.write(vector.get(n).getDescription());
                bufferedWriter.write("</th>\n");
            }
            bufferedWriter.write("  </tr>\n </thead>\n\n");
            iterator = collection.iterator();
            n = 0;
            while (iterator.hasNext()) {
                if (++n % 2 == 1) {
                    bufferedWriter.write(HTML_TR_OPEN_ODD);
                } else {
                    bufferedWriter.write(HTML_TR_OPEN_EVEN);
                }
                cEffortImpl = iterator.next();
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    bufferedWriter.write(HTML_TD_OPEN);
                    cEffortImpl.writeContentForExport(bufferedWriter, enumeration.nextElement(), false, null);
                    bufferedWriter.write(HTML_TD_CLOSE);
                }
                bufferedWriter.write(HTML_TR_CLOSE);
            }
            bufferedWriter.write("</table>\n");
            bufferedWriter.write("</body>\n</html>\n");
            bufferedWriter.flush();
            bufferedWriter.close();
            return true;
        }
        catch (IOException iOException) {
            LOGGER.warn("Fehler beim Schreiben in HTML.");
            return false;
        }
    }
}

