/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.controller;

import com.mayastudios.fred.client.filehandling.CWorkfile;
import com.mayastudios.fred.client.filehandling.DirectoryUtil;
import com.mayastudios.fred.client.filehandling.xml.XMLFileHandling;
import com.mayastudios.fred.client.view.QuickBar;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ShutdownHook
extends Thread {
    private static final String SHUTDOWN_SUFFIX = ".rescue";
    private final CWorkfile mf_oWorkfile;

    public ShutdownHook(CWorkfile cWorkfile) {
        this.mf_oWorkfile = cWorkfile;
    }

    @Override
    public void run() {
        boolean bl = false;
        if (QuickBar.getInstance().isRecording() && (QuickBar.getInstance().getCurrentWorkDuration() > 60 || QuickBar.getInstance().getCurrentPauseDuration() > 60)) {
            QuickBar.getInstance().quickSplit(true);
            bl = true;
        }
        if (!this.mf_oWorkfile.hasChanged() && !bl) {
            return;
        }
        File file = this.mf_oWorkfile.getWorkFilePath();
        File file2 = file.getParentFile();
        if (!file2.canWrite()) {
            String string = System.getProperty("user.home");
            if (string == null) {
                return;
            }
            file2 = new File(string);
            if (!file2.canWrite()) {
                return;
            }
        }
        this.saveRescueFile(file2.getAbsoluteFile(), file.getName() + SHUTDOWN_SUFFIX);
    }

    public void onOpenWorkFile() {
        Runtime.getRuntime().addShutdownHook(this);
    }

    public void onCloseWorkFile() {
        Runtime.getRuntime().removeShutdownHook(this);
    }

    private void saveRescueFile(File file, String string) {
        try {
            XMLFileHandling.writeXMLComplete(new File(file, string), this.mf_oWorkfile.getXMLizable(), false);
        }
        catch (Exception exception) {
            try {
                FileWriter fileWriter = new FileWriter(file + "/fredexception.txt");
                fileWriter.write(exception.toString());
                fileWriter.close();
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            exception.printStackTrace();
            return;
        }
    }

    public static File doesRescueFileExist(File file) {
        try {
            File file2 = new File(file + SHUTDOWN_SUFFIX);
            if (file2.exists()) {
                return file2.getCanonicalFile();
            }
            file2 = new File(DirectoryUtil.getHomeDirectory(), file.getName() + SHUTDOWN_SUFFIX);
            if (file2.exists()) {
                return file2.getCanonicalFile();
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return null;
    }
}

