/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.resources.FredInfo;
import com.mayastudios.launcher.AppInfo;
import com.mayastudios.launcher.impl.EasyJniClassLoader;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.ResourceLoaderInstance;
import com.mayastudios.mscl.SingleAppInstance;
import com.mayastudios.mscl.mwt.GUIHelper;
import com.mayastudios.mscl.mwt.InitHelper;
import com.mayastudios.mscl.mwt.LaFManager;
import com.mayastudios.mscl.mwt.MessageBox;
import com.mayastudios.mscl.mwt.widgets.SplashScreen;
import com.mayastudios.systeminfo.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Main {
    public static void main(String[] stringArray) {
        AppInfo.init((String[])stringArray);
        if (!EasyJniClassLoader.checkClassLoader()) {
            throw new ExceptionInInitializerError("The class loader 'EasyJniClassLoader' is not used. See the readme file for more information.");
        }
        EasyJniClassLoader.addCustomLibraryPath((String[])new String[]{"lib"});
        ImageIcon imageIcon = ResourceLoader.getIcon(Main.class, (String)"res/images/splash.png");
        if (imageIcon == null) {
            throw new ExceptionInInitializerError("Splash screen could not be loaded.");
        }
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Version " + FredInfo.VERSION_NUMBER);
        StringBuilder stringBuilder = new StringBuilder(255);
        for (String string : FredInfo.COPYRIGHTS) {
            stringBuilder.append(string).append("<br>");
        }
        JLabel jLabel2 = new JLabel("<html>" + stringBuilder.toString() + "http://fred.mayastudios.com");
        jPanel.setLayout(null);
        jLabel.setForeground(Color.WHITE);
        jPanel.add(jLabel);
        jLabel2.setForeground(Color.WHITE);
        jPanel.add(jLabel2);
        LaFManager.changeLookAndFeel((Component)jPanel, (LaFManager.EStyles)LaFManager.EStyles.System);
        Font font = jLabel.getFont().deriveFont(0, 11.0f);
        jLabel2.setFont(font);
        jLabel.setFont(font);
        jLabel.setSize(jLabel.getPreferredSize());
        Dimension dimension = jLabel2.getPreferredSize();
        jLabel2.setSize(dimension);
        jLabel.setLocation(33, 112);
        jLabel2.setLocation(33, 185 - dimension.height);
        SplashScreen.showAlwaysOnTop((boolean)false);
        SplashScreen.openSplashScreen((Icon)imageIcon, (SplashScreen.IPaintListener)new CPaintListener(), (boolean)true, (JPanel)jPanel);
    }

    public static void createInstance() {
        if (System.getProperty("UseDoubleInstanceCheck") == null || !System.getProperty("UseDoubleInstanceCheck").equals("0")) {
            try {
                SingleAppInstance.initAppLock((String)"fred2007");
                if (!SingleAppInstance.checkAppLock()) {
                    Main.showAppLockMessage(null);
                }
            }
            catch (SingleAppInstance.CSingleInstanceException cSingleInstanceException) {
                Main.showAppLockMessage((Exception)((Object)cSingleInstanceException));
            }
            catch (IOException iOException) {
                Main.showAppLockMessage(iOException);
            }
        }
        MainController.LOGGER.info(SystemInfo.INFO.toString());
        GUIHelper.enableDynamicLayout((boolean)false);
        MainController.initMainController(new ResourceLoaderInstance(Main.class, "res/"));
        MainController.getInstance().startUp();
    }

    private static void showAppLockMessage(Exception exception) {
        if (MessageBox.showOptionDlg(null, (String)"An instance of Fred is already running. Start anyway?", (String)"Question", (MessageBox.EIcon)MessageBox.EIcon.QUESTION, (MessageBox.EOptionButtons)MessageBox.EOptionButtons.YES_NO) == MessageBox.EButton.NO) {
            System.exit(1);
        }
    }

    private static class CPaintListener
    implements SplashScreen.IPaintListener {
        public void paintPerformed() {
            InitHelper.initApplication(Main.class, (String)"createInstance");
        }
    }
}

